/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.eiramoticons.emoticon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.blay09.mods.eiramoticons.api.IEmoticon;
import net.blay09.mods.eiramoticons.api.IEmoticonLoader;
import net.blay09.mods.eiramoticons.api.ReloadEmoticons;
import net.blay09.mods.eiramoticons.emoticon.Emoticon;
import net.blay09.mods.eiramoticons.emoticon.EmoticonGroup;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EmoticonRegistry {
    private static final AtomicInteger idCounter = new AtomicInteger();
    private static final IntHashMap<Emoticon> emoticonMap = new IntHashMap();
    private static final Map<String, Emoticon> namedMap = new HashMap<String, Emoticon>();
    private static final Map<String, EmoticonGroup> groupMap = new HashMap<String, EmoticonGroup>();
    private static final List<Emoticon> disposalList = new ArrayList<Emoticon>();
    public static boolean isLoading;

    public static IEmoticon registerEmoticon(String name, IEmoticonLoader loader) {
        Emoticon emoticon = new Emoticon(idCounter.incrementAndGet(), name, loader);
        emoticonMap.func_76038_a(emoticon.id, (Object)emoticon);
        namedMap.put(emoticon.code, emoticon);
        return emoticon;
    }

    public static Collection<EmoticonGroup> getGroups() {
        return groupMap.values();
    }

    public static EmoticonGroup registerEmoticonGroup(String groupName, ITextComponent listComponent) {
        EmoticonGroup group = new EmoticonGroup(groupName, listComponent);
        groupMap.put(groupName, group);
        return group;
    }

    public static Emoticon fromName(String name) {
        return namedMap.get(name);
    }

    public static Emoticon fromId(int id) {
        return (Emoticon)emoticonMap.func_76041_a(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadEmoticons() {
        List<Emoticon> list = disposalList;
        synchronized (list) {
            for (Emoticon emoticon : namedMap.values()) {
                disposalList.add(emoticon);
            }
        }
        idCounter.set(0);
        emoticonMap.func_76046_c();
        groupMap.clear();
        namedMap.clear();
        MinecraftForge.EVENT_BUS.post((Event)new ReloadEmoticons());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runDisposal() {
        List<Emoticon> list = disposalList;
        synchronized (list) {
            if (!disposalList.isEmpty()) {
                for (Emoticon emoticon : disposalList) {
                    emoticon.disposeTexture();
                }
                disposalList.clear();
            }
        }
    }
}

