/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.eiramoticons.render;

import net.blay09.mods.eiramoticons.addon.VanillaChatContainer;
import net.blay09.mods.eiramoticons.api.ChatContainer;
import net.blay09.mods.eiramoticons.emoticon.Emoticon;
import net.blay09.mods.eiramoticons.emoticon.EmoticonRegistry;
import net.blay09.mods.eiramoticons.render.EmoticonBuffer;
import net.blay09.mods.eiramoticons.render.FontRendererExt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class EmoticonRenderer {
    public static final float EMOTICON_WIDTH = 16.0f;
    public static final float EMOTICON_HEIGHT = 14.0f;
    private final Minecraft mc;
    private final int spaceWidth;
    private final EmoticonBuffer buffer = new EmoticonBuffer();
    private ChatContainer chatContainer = new VanillaChatContainer();

    public EmoticonRenderer(Minecraft mc) {
        this.mc = mc;
        this.spaceWidth = mc.field_71466_p.func_78256_a("   ");
    }

    @SubscribeEvent
    public void startRenderChat(RenderGameOverlayEvent.Chat event) {
        EmoticonRegistry.runDisposal();
        FontRendererExt.enableEmoticons = true;
    }

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CHAT) {
            return;
        }
        FontRendererExt.enableEmoticons = false;
        int mouseX = Mouse.getX() * event.getResolution().func_78326_a() / this.mc.field_71443_c;
        int mouseY = event.getResolution().func_78328_b() - Mouse.getY() * event.getResolution().func_78328_b() / this.mc.field_71440_d - 1;
        float chatScale = this.chatContainer.getChatScale(event.getResolution());
        if (this.chatContainer.isCustomTransform()) {
            this.chatContainer.pushTransform(event.getResolution());
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.chatContainer.getOffsetX(event.getResolution()), (float)this.chatContainer.getOffsetY(event.getResolution()), (float)0.0f);
            GlStateManager.func_179152_a((float)chatScale, (float)chatScale, (float)1.0f);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        Emoticon hoverEmoticon = null;
        for (int i = this.buffer.count - 1; i >= 0; --i) {
            if (this.buffer.emoticons[i].getTextureId() == -1) {
                this.buffer.emoticons[i].requestTexture();
                continue;
            }
            float renderWidth = (float)this.buffer.emoticons[i].getWidth() * this.buffer.emoticons[i].getScaleX();
            float renderHeight = (float)this.buffer.emoticons[i].getHeight() * this.buffer.emoticons[i].getScaleY();
            float renderX = this.buffer.positionX[i] + ((float)(this.spaceWidth / 2) - renderWidth / 2.0f);
            float renderY = this.buffer.positionY[i] + ((float)(this.mc.field_71466_p.field_78288_b / 2) - renderHeight / 2.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)renderX, (float)renderY, (float)0.0f);
            GlStateManager.func_179152_a((float)this.buffer.emoticons[i].getScaleX(), (float)this.buffer.emoticons[i].getScaleY(), (float)1.0f);
            GlStateManager.func_179144_i((int)this.buffer.emoticons[i].getTextureId());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.buffer.alpha[i]);
            if (this.buffer.emoticons[i].isAnimated()) {
                this.buffer.emoticons[i].updateAnimation();
                EmoticonRenderer.drawTexturedRect(0.0f, 0.0f, this.buffer.emoticons[i].getCurrentFrameTexCoordX(), this.buffer.emoticons[i].getCurrentFrameTexCoordY(), this.buffer.emoticons[i].getWidth(), this.buffer.emoticons[i].getHeight(), this.buffer.emoticons[i].getSheetWidth(), this.buffer.emoticons[i].getSheetHeight());
            } else {
                EmoticonRenderer.drawTexturedRect(0.0f, 0.0f, this.buffer.emoticons[i].getWidth(), this.buffer.emoticons[i].getHeight());
            }
            GlStateManager.func_179121_F();
            if (hoverEmoticon != null) continue;
            float offsetX = this.chatContainer.getOffsetX(event.getResolution());
            float offsetY = this.chatContainer.getOffsetY(event.getResolution());
            if (!((float)mouseX > offsetX + renderX) || !((float)mouseX <= offsetX + renderX + renderWidth * chatScale) || !((float)mouseY > offsetY + renderY) || !((float)mouseY <= offsetY + renderY + renderHeight * chatScale)) continue;
            hoverEmoticon = this.buffer.emoticons[i];
        }
        GlStateManager.func_179084_k();
        if (this.chatContainer.isCustomTransform()) {
            this.chatContainer.popTransform(event.getResolution());
        } else {
            GlStateManager.func_179121_F();
        }
        if (hoverEmoticon != null && this.mc.field_71462_r instanceof GuiChat) {
            this.drawHoveringText(hoverEmoticon.getTooltip(), mouseX, mouseY, event.getResolution().func_78326_a(), event.getResolution().func_78328_b());
        }
        this.buffer.freeMemory();
    }

    private static void drawTexturedRect(float x, float y, float textureX, float textureY, float width, float height, float sheetWidth, float sheetHeight) {
        GL11.glBegin((int)4);
        GL11.glTexCoord2f((float)(textureX / sheetWidth), (float)((textureY + height) / sheetHeight));
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)((textureX + width) / sheetWidth), (float)(textureY / sheetHeight));
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glTexCoord2f((float)(textureX / sheetWidth), (float)(textureY / sheetHeight));
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)(textureX / sheetWidth), (float)((textureY + height) / sheetHeight));
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)((textureX + width) / sheetWidth), (float)((textureY + height) / sheetHeight));
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)((textureX + width) / sheetWidth), (float)(textureY / sheetHeight));
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    private static void drawTexturedRect(float x, float y, float width, float height) {
        GL11.glBegin((int)4);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    protected void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor, int zLevel) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexBuffer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexBuffer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        vertexBuffer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    protected void drawHoveringText(String[] lines, int mouseX, int mouseY, int width, int height) {
        if (lines != null && lines.length > 0) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int maxLineWidth = 0;
            for (String s : lines) {
                int lineWidth = this.mc.field_71466_p.func_78256_a(s);
                if (lineWidth <= maxLineWidth) continue;
                maxLineWidth = lineWidth;
            }
            int x = mouseX + 12;
            int y = mouseY - 10;
            int tooltipHeight = 8;
            if (lines.length > 1) {
                tooltipHeight += 2 + (lines.length - 1) * 10;
            }
            if (x + maxLineWidth > width) {
                x -= 28 + maxLineWidth;
            }
            if (y + tooltipHeight + 6 > height) {
                y = height - tooltipHeight - 6;
            }
            int bgColor = -267386864;
            this.drawGradientRect(x - 3, y - 4, x + maxLineWidth + 3, y - 3, bgColor, bgColor, 300);
            this.drawGradientRect(x - 3, y + tooltipHeight + 3, x + maxLineWidth + 3, y + tooltipHeight + 4, bgColor, bgColor, 300);
            this.drawGradientRect(x - 3, y - 3, x + maxLineWidth + 3, y + tooltipHeight + 3, bgColor, bgColor, 300);
            this.drawGradientRect(x - 4, y - 3, x - 3, y + tooltipHeight + 3, bgColor, bgColor, 300);
            this.drawGradientRect(x + maxLineWidth + 3, y - 3, x + maxLineWidth + 4, y + tooltipHeight + 3, bgColor, bgColor, 300);
            int fgColor1 = 0x505000FF;
            int fgColor2 = (fgColor1 & 0xFEFEFE) >> 1 | fgColor1 & 0xFF000000;
            this.drawGradientRect(x - 3, y - 3 + 1, x - 3 + 1, y + tooltipHeight + 3 - 1, fgColor1, fgColor2, 300);
            this.drawGradientRect(x + maxLineWidth + 2, y - 3 + 1, x + maxLineWidth + 3, y + tooltipHeight + 3 - 1, fgColor1, fgColor2, 300);
            this.drawGradientRect(x - 3, y - 3, x + maxLineWidth + 3, y - 3 + 1, fgColor1, fgColor1, 300);
            this.drawGradientRect(x - 3, y + tooltipHeight + 2, x + maxLineWidth + 3, y + tooltipHeight + 3, fgColor2, fgColor2, 300);
            for (String line : lines) {
                this.mc.field_71466_p.func_175065_a(line, (float)x, (float)y, -1, true);
                y += 10;
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }

    public EmoticonBuffer getBuffer() {
        return this.buffer;
    }

    public void setChatContainer(ChatContainer chatContainer) {
        this.chatContainer = chatContainer;
    }
}

