/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu;

import com.feed_the_beast.ftbl.api.IFTBLibRegistry;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.INotification;
import com.feed_the_beast.ftbl.api.NotificationId;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.Notification;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api_impl.ChunkUpgrade;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class FTBUNotifications {
    public static final INotification NO_TEAM = FTBUNotifications.create("no_team", 0).setError(FTBLibLang.TEAM_NO_TEAM.textComponent(new Object[0]));
    public static final INotification CANT_MODIFY_CHUNK = FTBUNotifications.create("cant_modify_chunk", 0).setError((ITextComponent)new TextComponentString("Can't modify this chunk!"));
    public static final INotification CLAIMING_NOT_ENABLED = FTBUNotifications.create("cant_claim_chunk", 0).setError((ITextComponent)new TextComponentString("Claiming is not enabled on this server!"));
    public static final INotification CLAIMING_NOT_ALLOWED = FTBUNotifications.create("cant_claim_chunk", 1).setError((ITextComponent)new TextComponentString("You are not allowed to claim this chunk"));
    public static final INotification UNCLAIMED_ALL = FTBUNotifications.create("unclaimed_all", 0).addText((ITextComponent)new TextComponentString("Unclaimed all chunks"));
    public static final INotification CHUNK_CLAIMED = FTBUNotifications.create("chunk_modified", 0).addText((ITextComponent)new TextComponentString("Chunk claimed"));
    public static final INotification CHUNK_UNCLAIMED = FTBUNotifications.create("chunk_modified", 1).addText((ITextComponent)new TextComponentString("Chunk unclaimed"));
    public static final INotification CHUNK_LOADED = FTBUNotifications.create("chunk_modified", 2).addText((ITextComponent)new TextComponentString("Chunk loaded"));
    public static final INotification CHUNK_UNLOADED = FTBUNotifications.create("chunk_modified", 3).addText((ITextComponent)new TextComponentString("Chunk unloaded"));
    public static final Notification WILDERNESS = FTBUNotifications.create("chunk_changed", 0).setTimer(3000).setColor(new Color4I(-12938950)).setItem(new ItemStack(Blocks.field_150395_bd));

    public static void init(IFTBLibRegistry reg) {
        reg.addNotification(NO_TEAM);
        reg.addNotification(CANT_MODIFY_CHUNK);
        reg.addNotification(CLAIMING_NOT_ENABLED);
        reg.addNotification(CLAIMING_NOT_ALLOWED);
        reg.addNotification(UNCLAIMED_ALL);
        reg.addNotification(CHUNK_CLAIMED);
        reg.addNotification(CHUNK_UNCLAIMED);
        reg.addNotification(CHUNK_LOADED);
        reg.addNotification(CHUNK_UNLOADED);
        reg.addNotification((INotification)WILDERNESS);
    }

    private static Notification create(String s, int v) {
        return new Notification(new NotificationId(FTBUFinals.get(s), v));
    }

    public static INotification chunkClaimedFor(int chunkXPos, int chunkZPos, int dimension, IForgePlayer p) {
        String label = String.format("Claimed the chunk %d, %d in dim [%d] on behalf of %s", chunkXPos, chunkZPos, dimension, p.getName());
        return FTBUNotifications.create("chunk_modified", 0).addText((ITextComponent)new TextComponentString(label));
    }

    public static INotification chunkUnclaimedFor(int chunkXPos, int chunkZPos, int dimension, IForgePlayer p) {
        String label = String.format("Unclaimed the chunk %d, %d in dim [%d] on behalf of %s", chunkXPos, chunkZPos, dimension, p.getName());
        return FTBUNotifications.create("chunk_modified", 0).addText((ITextComponent)new TextComponentString(label));
    }

    public static INotification chunkChanged(@Nullable IForgeTeam team) {
        if (team == null) {
            return WILDERNESS;
        }
        TextComponentString msg = new TextComponentString(team.getTitle());
        msg.func_150256_b().func_150227_a(Boolean.valueOf(true));
        Notification n = new Notification(WILDERNESS.getId().variant(1));
        n.addText((ITextComponent)msg);
        if (!team.getDesc().isEmpty()) {
            msg = new TextComponentString(team.getDesc());
            msg.func_150256_b().func_150217_b(Boolean.valueOf(true));
            n.addText((ITextComponent)msg);
        }
        n.setTimer(3000);
        n.setColor(team.getColor().getColor());
        return n;
    }

    static {
        ITextComponent msg = ChunkUpgrade.WILDERNESS.getLangKey().textComponent(new Object[0]);
        msg.func_150256_b().func_150227_a(Boolean.valueOf(true));
        WILDERNESS.addText(msg);
    }
}

