/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.api_impl;

import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.lib.io.Bits;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbu.FTBUPermissions;
import com.feed_the_beast.ftbu.api.chunks.IChunkUpgrade;
import com.feed_the_beast.ftbu.api.chunks.IClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ChunkUpgrade;
import com.feed_the_beast.ftbu.config.FTBUConfigWorld;
import com.feed_the_beast.ftbu.world.FTBUTeamData;
import com.mojang.authlib.GameProfile;
import net.minecraftforge.server.permission.PermissionAPI;

public class ClaimedChunk
implements IClaimedChunk {
    private final ChunkDimPos pos;
    private final IForgePlayer owner;
    private int flags;

    public ClaimedChunk(ChunkDimPos c, IForgePlayer p, int f) {
        this.pos = c;
        this.owner = p;
        this.flags = f;
    }

    @Override
    public ChunkDimPos getPos() {
        return this.pos;
    }

    @Override
    public IForgePlayer getOwner() {
        return this.owner;
    }

    @Override
    public boolean hasUpgrade(IChunkUpgrade upgrade) {
        if (upgrade == ChunkUpgrade.ACTUALLY_LOADED) {
            if (!(FTBUConfigWorld.CHUNK_LOADING.getBoolean() && this.hasUpgrade(ChunkUpgrade.LOADED) && FTBUPermissions.canUpgradeChunk(this.owner.getProfile(), ChunkUpgrade.LOADED))) {
                return false;
            }
            return this.owner.isOnline() || PermissionAPI.hasPermission((GameProfile)this.owner.getProfile(), (String)"ftbu.chunkloader.load_offline", null);
        }
        if (upgrade == ChunkUpgrade.NO_EXPLOSIONS) {
            if (!FTBUPermissions.canUpgradeChunk(this.owner.getProfile(), ChunkUpgrade.NO_EXPLOSIONS)) {
                return false;
            }
            FTBUTeamData data = this.owner.getTeam() == null ? null : FTBUTeamData.get(this.owner.getTeam());
            return data != null && data.disableExplosions();
        }
        return Bits.getFlag((int)this.flags, (int)(1 << upgrade.getId()));
    }

    @Override
    public void setHasUpgrade(IChunkUpgrade upgrade, boolean v) {
        this.flags = Bits.setFlag((int)this.flags, (int)(1 << upgrade.getId()), (boolean)v);
    }
}

