/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IImageProvider;
import com.feed_the_beast.ftbl.api.info.IPageIconRenderer;
import com.feed_the_beast.ftbl.api.info.ISpecialInfoButton;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiInfo;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.info.InfoPageHelper;
import com.feed_the_beast.ftbl.lib.info.ItemPageIconRenderer;
import com.feed_the_beast.ftbl.lib.info.SpecialInfoButton;
import com.feed_the_beast.ftbl.lib.info.TexturePageIconRenderer;
import com.feed_the_beast.ftbl.lib.util.LMJsonUtils;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api.guide.ClientGuideEvent;
import com.feed_the_beast.ftbu.api.guide.GuideFormat;
import com.feed_the_beast.ftbu.api.guide.IGuide;
import com.feed_the_beast.ftbu.gui.InfoPageGuide;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public enum Guides implements IResourceManagerReloadListener
{
    INSTANCE;

    private static final InfoPage INFO_PAGE;
    private static boolean isReloading;
    private static Thread reloadingThread;
    private static GuiInfo cachedGui;
    public static final Map<String, String> SUBSTITUTE_CACHE;

    public static void setShouldReload() {
        cachedGui = null;
    }

    public static void refresh() {
        GuiHelper.playClickSound();
        Guides.setShouldReload();
        Guides.openGui();
    }

    public static void openGui() {
        if (cachedGui == null) {
            if (!isReloading) {
                isReloading = true;
                new GuiLoading(){

                    public void startLoading() {
                        reloadingThread = new Thread(() -> {
                            INSTANCE.func_110549_a(Minecraft.func_71410_x().func_110442_L());
                            isReloading = false;
                        });
                        reloadingThread.start();
                    }

                    public boolean isLoading() {
                        return isReloading;
                    }

                    public void finishLoading() {
                        reloadingThread = null;
                        cachedGui = new GuiInfo(INFO_PAGE);
                        cachedGui.openGui();
                    }
                }.openGui();
            }
        } else if (!isReloading) {
            cachedGui.openGui();
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        FTBUFinals.LOGGER.info("Reloading guides...");
        INFO_PAGE.clear();
        INFO_PAGE.setTitle((ITextComponent)new TextComponentString("Guides"));
        ArrayList<InfoPageGuide> guides = new ArrayList<InfoPageGuide>();
        SUBSTITUTE_CACHE.clear();
        for (String domain : resourceManager.func_135055_a()) {
            try {
                IResource iResource = resourceManager.func_110536_a(new ResourceLocation(domain, "guide.json"));
                JsonElement infoFile = LMJsonUtils.fromJson((Reader)new InputStreamReader(iResource.func_110527_b()));
                if (!infoFile.isJsonObject()) continue;
                InfoPageGuide guide = new InfoPageGuide(domain, infoFile.getAsJsonObject());
                GuideFormat format = guide.getFormat();
                if (format == GuideFormat.UNSUPPORTED) {
                    guide.getPage().println((Object)"Unsupported format!");
                    guide.getPage().println((Object)"Please update FTBUtilities or contact mod author!");
                } else {
                    Guides.loadTree(resourceManager, domain, guide.getPage(), format, "guide");
                }
                guides.add(guide);
            }
            catch (Exception exception) {
                if (exception instanceof FileNotFoundException) continue;
                exception.printStackTrace();
            }
        }
        HashMap<String, IGuide> eventMap = new HashMap<String, IGuide>();
        MinecraftForge.EVENT_BUS.post((Event)new ClientGuideEvent(eventMap, resourceManager));
        guides.addAll(eventMap.values());
        for (IGuide iGuide : guides) {
            INFO_PAGE.addSub(iGuide.getPage());
        }
        INFO_PAGE.cleanup();
        INFO_PAGE.sort(false);
    }

    private static boolean validChar(char c) {
        return c == '_' || c == '.' || c == '{' || c == '}' || LMStringUtils.isTextChar((char)c, (boolean)true);
    }

    private static void loadTree(IResourceManager resourceManager, String domain, InfoPage page, GuideFormat format, String parentDir) throws Exception {
        block19: {
            block18: {
                try {
                    switch (format) {
                        case JSON: {
                            for (JsonElement e : LMJsonUtils.fromJson((String)Guides.replaceSubstitutes(LMStringUtils.readString((InputStream)resourceManager.func_110536_a(new ResourceLocation(domain, parentDir + "/index.json")).func_110527_b()))).getAsJsonArray()) {
                                page.println((Object)InfoPageHelper.createLine((InfoPage)page, (JsonElement)e));
                            }
                            break;
                        }
                        case MD: {
                            for (String s : LMStringUtils.readStringList((InputStream)resourceManager.func_110536_a(new ResourceLocation(domain, parentDir + "/README.md")).func_110527_b())) {
                                page.println((Object)s);
                            }
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    if (ex instanceof FileNotFoundException) break block18;
                    FTBUFinals.LOGGER.error("Failed to load " + page.getFullID() + ": " + ex);
                }
            }
            try {
                for (JsonElement e : LMJsonUtils.fromJson((Reader)new InputStreamReader(resourceManager.func_110536_a(new ResourceLocation(domain, parentDir + "/pages.json")).func_110527_b())).getAsJsonArray()) {
                    InfoPage page1;
                    if (e.isJsonObject()) {
                        JsonObject o = e.getAsJsonObject();
                        page1 = new InfoPage(o.get("id").getAsString());
                        if (o.has("icon")) {
                            page1.setIcon((IPageIconRenderer)new TexturePageIconRenderer((IImageProvider)new ImageProvider(new ResourceLocation(o.get("icon").getAsString()))));
                        } else if (o.has("icon_item")) {
                            page1.setIcon((IPageIconRenderer)new ItemPageIconRenderer(o.get("icon_item")));
                        }
                        if (o.has("lang")) {
                            page1.setTitle((ITextComponent)new TextComponentTranslation(o.get("lang").getAsString(), new Object[0]));
                        } else {
                            page1.setTitle((ITextComponent)new TextComponentTranslation(domain + '.' + parentDir.replace('/', '.') + "." + page1.func_176610_l(), new Object[0]));
                        }
                        page.addSub(page1);
                    } else {
                        page1 = page.getSub(e.getAsString());
                        page1.setTitle((ITextComponent)new TextComponentTranslation(domain + '.' + parentDir.replace('/', '.') + "." + page1.func_176610_l(), new Object[0]));
                    }
                    Guides.loadTree(resourceManager, domain, page1, format, parentDir + "/" + page1.func_176610_l());
                }
            }
            catch (Exception ex) {
                if (!LMUtils.DEV_ENV || ex instanceof FileNotFoundException) break block19;
                ex.printStackTrace();
            }
        }
    }

    private static String replaceSubstitutes(CharSequence text) {
        StringBuilder builder = new StringBuilder();
        StringBuilder keyBuilder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (keyBuilder.length() > 0) {
                if (Guides.validChar(c)) {
                    keyBuilder.append(c);
                    continue;
                }
                String value = SUBSTITUTE_CACHE.computeIfAbsent(keyBuilder.substring(1), k -> Guides.replaceSubstitutes(I18n.func_135052_a((String)k, (Object[])new Object[0])));
                builder.append(value);
                if (c != '$') {
                    builder.append(c);
                }
                keyBuilder.setLength(0);
                continue;
            }
            if (c == '$' && (i < 1 || text.charAt(i - 1) != '\\')) {
                keyBuilder.append(c);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    static {
        INFO_PAGE = new InfoPage("guides").setSpecialButton((ISpecialInfoButton)new SpecialInfoButton(GuiLang.BUTTON_REFRESH.textComponent(new Object[0]), (IDrawableObject)GuiIcons.REFRESH, button -> Guides.refresh()));
        isReloading = false;
        reloadingThread = null;
        cachedGui = null;
        SUBSTITUTE_CACHE = new HashMap<String, String>();
    }
}

