/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui;

import com.feed_the_beast.ftbl.api.gui.IImageProvider;
import com.feed_the_beast.ftbl.api.info.IPageIconRenderer;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.info.ItemPageIconRenderer;
import com.feed_the_beast.ftbl.lib.info.TexturePageIconRenderer;
import com.feed_the_beast.ftbu.api.guide.GuideFormat;
import com.feed_the_beast.ftbu.api.guide.GuideType;
import com.feed_the_beast.ftbu.api.guide.IGuide;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.ModContainer;

public class InfoPageGuide
implements IGuide {
    private final InfoPage page;
    private final GuideType type;
    private final GuideFormat format;
    private final List<String> authors;
    private final List<String> guideAuthors;

    public InfoPageGuide(String id, GuideType t, Collection<String> _authors, Collection<String> _guideAuthors) {
        this.page = new InfoPage(id);
        this.type = t;
        this.format = GuideFormat.JSON;
        this.authors = _authors.isEmpty() ? Collections.emptyList() : new ArrayList<String>(_authors);
        this.guideAuthors = _guideAuthors.isEmpty() ? Collections.emptyList() : new ArrayList<String>(_guideAuthors);
    }

    public InfoPageGuide(ModContainer mod) {
        this(mod.getModId(), GuideType.MOD, mod.getMetadata().authorList, Collections.singleton("Autogenerated"));
        if (!mod.getMetadata().description.isEmpty()) {
            for (String s : mod.getMetadata().description.split("\n")) {
                this.page.println((Object)s);
            }
        }
        this.page.setTitle((ITextComponent)new TextComponentString(mod.getName()));
    }

    public InfoPageGuide(String id, JsonObject o) {
        this.page = new InfoPage(id);
        this.page.setTitle((ITextComponent)new TextComponentTranslation(id + ".guide", new Object[0]));
        if (o.has("icon")) {
            this.page.setIcon((IPageIconRenderer)new TexturePageIconRenderer((IImageProvider)new ImageProvider(new ResourceLocation(o.get("icon").getAsString()))));
        } else if (o.has("icon_item")) {
            this.page.setIcon((IPageIconRenderer)new ItemPageIconRenderer(o.get("icon_item")));
        } else {
            this.page.setIcon((IPageIconRenderer)new TexturePageIconRenderer((IImageProvider)new ImageProvider(new ResourceLocation(id, "textures/icon.png"))));
        }
        this.type = o.has("type") ? GuideType.getFromString(o.get("type").getAsString()) : GuideType.OTHER;
        this.format = o.has("format") ? GuideFormat.getFromString(o.get("format").getAsString()) : GuideFormat.JSON;
        ArrayList<String> l = new ArrayList<String>();
        for (JsonElement e : o.get("authors").getAsJsonArray()) {
            l.add(e.getAsString());
        }
        this.authors = Collections.unmodifiableList(l);
        l = new ArrayList();
        if (o.has("guide_authors")) {
            for (JsonElement e : o.get("guide_authors").getAsJsonArray()) {
                l.add(e.getAsString());
            }
        }
        this.guideAuthors = Collections.unmodifiableList(l);
    }

    @Override
    public GuideType getType() {
        return this.type;
    }

    @Override
    public GuideFormat getFormat() {
        return this.format;
    }

    @Override
    public List<String> getAuthors() {
        return this.authors;
    }

    @Override
    public List<String> getGuideAuthors() {
        return this.guideAuthors;
    }

    @Override
    public InfoPage getPage() {
        return this.page;
    }
}

