/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.handlers;

import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.events.universe.ForgeUniverseClosedEvent;
import com.feed_the_beast.ftbl.api.events.universe.ForgeUniverseLoadedBeforePlayersEvent;
import com.feed_the_beast.ftbl.api.events.universe.ForgeUniverseLoadedEvent;
import com.feed_the_beast.ftbl.lib.config.PropertyEntityClass;
import com.feed_the_beast.ftbu.config.FTBUConfigWorld;
import com.feed_the_beast.ftbu.world.FTBUUniverseData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FTBUWorldEventHandler {
    @SubscribeEvent
    public static void onWorldLoaded(ForgeUniverseLoadedEvent event) {
        FTBUUniverseData data = FTBUUniverseData.get();
        if (data != null) {
            data.onLoaded();
        }
    }

    @SubscribeEvent
    public static void onWorldLoadedBeforePlayers(ForgeUniverseLoadedBeforePlayersEvent event) {
        FTBUUniverseData data = FTBUUniverseData.get();
        if (data != null) {
            data.onLoadedBeforePlayers();
        }
    }

    @SubscribeEvent
    public static void onWorldClosed(ForgeUniverseClosedEvent event) {
        FTBUUniverseData data = FTBUUniverseData.get();
        if (data != null) {
            data.onClosed();
        }
    }

    @SubscribeEvent
    public static void onMobSpawned(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && !FTBUWorldEventHandler.isEntityAllowed(event.getEntity())) {
            event.getEntity().func_70106_y();
            event.setCanceled(true);
        }
    }

    private static boolean isEntityAllowed(Entity e) {
        if (e instanceof EntityPlayer) {
            return true;
        }
        for (IConfigValue value : FTBUConfigWorld.BLOCKED_ENTITIES) {
            if (!((PropertyEntityClass)value).matches(e.getClass(), true)) continue;
            return false;
        }
        if (FTBUConfigWorld.SAFE_SPAWN.getBoolean() && FTBUUniverseData.isInSpawnD(e.field_71093_bK, e.field_70165_t, e.field_70161_v)) {
            if (e instanceof IMob) {
                return false;
            }
            if (e instanceof EntityChicken && !e.func_184188_bt().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        FTBUUniverseData.handleExplosion(event.getWorld(), event.getExplosion());
    }
}

