/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world;

import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.lib.BroadcastSender;
import com.feed_the_beast.ftbl.lib.internal.FTBLibStats;
import com.feed_the_beast.ftbl.lib.math.BlockDimPos;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbl.lib.math.MathHelperLM;
import com.feed_the_beast.ftbl.lib.util.LMJsonUtils;
import com.feed_the_beast.ftbl.lib.util.LMServerUtils;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.feed_the_beast.ftbu.FTBLibIntegration;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.FTBUNotifications;
import com.feed_the_beast.ftbu.FTBUPermissions;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.api.chunks.ChunkModifiedEvent;
import com.feed_the_beast.ftbu.api.chunks.IClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ChunkUpgrade;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunkStorage;
import com.feed_the_beast.ftbu.api_impl.FTBUtilitiesAPI_Impl;
import com.feed_the_beast.ftbu.api_impl.LoadedChunkStorage;
import com.feed_the_beast.ftbu.cmd.CmdRestart;
import com.feed_the_beast.ftbu.config.FTBUConfigBackups;
import com.feed_the_beast.ftbu.config.FTBUConfigGeneral;
import com.feed_the_beast.ftbu.config.FTBUConfigWebAPI;
import com.feed_the_beast.ftbu.config.FTBUConfigWorld;
import com.feed_the_beast.ftbu.world.JsonTable;
import com.feed_the_beast.ftbu.world.backups.Backups;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class FTBUUniverseData
implements INBTSerializable<NBTBase>,
ITickable {
    private static final Map<UUID, String> LOCAL_BADGES = new HashMap<UUID, String>();
    public static final Function<ChunkDimPos, Boolean> ALLOW_EXPLOSION = pos -> {
        if (pos.dim == 0 && FTBUConfigWorld.SAFE_SPAWN.getBoolean() && FTBUUniverseData.isInSpawn(pos)) {
            return false;
        }
        IClaimedChunk chunk = ClaimedChunkStorage.INSTANCE.getChunk((ChunkDimPos)pos);
        return chunk == null || !chunk.hasUpgrade(ChunkUpgrade.NO_EXPLOSIONS);
    };
    public long restartMillis;
    private long nextChunkloaderUpdate;
    private long nextWebApiUpdate;
    private final Map<String, BlockDimPos> warps = new HashMap<String, BlockDimPos>();
    private String lastRestartMessage = "";

    @Nullable
    public static FTBUUniverseData get() {
        return (FTBUUniverseData)FTBLibIntegration.API.getUniverse().getData(FTBLibIntegration.FTBU_DATA);
    }

    public static String getServerBadge(@Nullable IForgePlayer p) {
        if (p == null) {
            return "";
        }
        String b = LOCAL_BADGES.get(p.getId());
        if (b == null) {
            b = FTBUtilitiesAPI_Impl.INSTANCE.getRankConfig(p.getProfile(), "ftbu.badge").getString();
        }
        return b;
    }

    public static void reloadServerBadges() {
        try {
            LOCAL_BADGES.clear();
            File file = new File(LMUtils.folderLocal, "ftbu/server_badges.json");
            if (!file.exists()) {
                JsonObject o = new JsonObject();
                o.add("uuid", (JsonElement)new JsonPrimitive("url_to.png"));
                LMJsonUtils.toJson((File)file, (JsonElement)o);
            } else {
                for (Map.Entry entry : LMJsonUtils.fromJson((File)file).getAsJsonObject().entrySet()) {
                    UUID id = LMStringUtils.fromString((String)((String)entry.getKey()));
                    if (id == null) continue;
                    LOCAL_BADGES.put(id, ((JsonElement)entry.getValue()).getAsString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isInSpawn(ChunkDimPos pos) {
        MinecraftServer server = LMServerUtils.getServer();
        if (pos.dim != 0 || !server.func_71262_S() && !FTBUConfigWorld.SPAWN_AREA_IN_SP.getBoolean()) {
            return false;
        }
        int radius = server.func_82357_ak();
        if (radius <= 0) {
            return false;
        }
        BlockPos c = server.func_130014_f_().func_175694_M();
        int minX = MathHelperLM.chunk((int)(c.func_177958_n() - radius));
        int minZ = MathHelperLM.chunk((int)(c.func_177952_p() - radius));
        int maxX = MathHelperLM.chunk((int)(c.func_177958_n() + radius));
        int maxZ = MathHelperLM.chunk((int)(c.func_177952_p() + radius));
        return pos.posX >= minX && pos.posX <= maxX && pos.posZ >= minZ && pos.posZ <= maxZ;
    }

    public static boolean isInSpawnD(int dim, double x, double z) {
        return dim == 0 && FTBUUniverseData.isInSpawn(new ChunkDimPos(MathHelperLM.chunk((double)x), MathHelperLM.chunk((double)z), dim));
    }

    public static void handleExplosion(World world, Explosion explosion) {
        if (world.field_72995_K || explosion.func_180343_e().isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(explosion.func_180343_e());
        explosion.func_180342_d();
        HashMap<ChunkDimPos, Boolean> map = new HashMap<ChunkDimPos, Boolean>();
        for (BlockPos pos : list) {
            if (!map.computeIfAbsent(new ChunkDimPos(pos, world.field_73011_w.getDimension()), ALLOW_EXPLOSION).booleanValue()) continue;
            explosion.func_180343_e().add(pos);
        }
    }

    public static boolean claimChunk(IForgePlayer player, ChunkDimPos pos) {
        if (!FTBUConfigWorld.CHUNK_CLAIMING.getBoolean() || !FTBUPermissions.allowDimension(player.getProfile(), pos.dim)) {
            return false;
        }
        if (player.getTeam() == null) {
            if (player.isOnline()) {
                FTBLibIntegration.API.sendNotification((EntityPlayer)player.getPlayer(), FTBUNotifications.NO_TEAM);
            }
            return false;
        }
        int max = FTBUtilitiesAPI_Impl.INSTANCE.getRankConfig(player.getProfile(), "ftbu.claims.max_chunks").getInt();
        if (max == 0) {
            return false;
        }
        if (ClaimedChunkStorage.INSTANCE.getChunks(player).size() >= max) {
            return false;
        }
        IForgePlayer chunkOwner = ClaimedChunkStorage.INSTANCE.getChunkOwner(pos);
        if (chunkOwner != null) {
            return false;
        }
        ClaimedChunk chunk = new ClaimedChunk(pos, player, 0);
        ClaimedChunkStorage.INSTANCE.setChunk(pos, chunk);
        MinecraftForge.EVENT_BUS.post((Event)new ChunkModifiedEvent.Claimed(chunk));
        return true;
    }

    public static boolean unclaimChunk(IForgePlayer player, ChunkDimPos pos) {
        IClaimedChunk chunk = ClaimedChunkStorage.INSTANCE.getChunk(pos);
        if (chunk != null) {
            FTBUUniverseData.setLoaded(player, pos, false);
            MinecraftForge.EVENT_BUS.post((Event)new ChunkModifiedEvent.Unclaimed(chunk));
            ClaimedChunkStorage.INSTANCE.setChunk(pos, null);
            return true;
        }
        return false;
    }

    public static void unclaimAllChunks(IForgePlayer player, @Nullable Integer dim) {
        for (IClaimedChunk chunk : ClaimedChunkStorage.INSTANCE.getChunks(player)) {
            ChunkDimPos pos = chunk.getPos();
            if (dim != null && dim != pos.dim) continue;
            FTBUUniverseData.setLoaded(player, pos, false);
            MinecraftForge.EVENT_BUS.post((Event)new ChunkModifiedEvent.Unclaimed(chunk));
            ClaimedChunkStorage.INSTANCE.setChunk(pos, null);
        }
    }

    public static boolean setLoaded(IForgePlayer player, ChunkDimPos pos, boolean flag) {
        IClaimedChunk chunk = ClaimedChunkStorage.INSTANCE.getChunk(pos);
        if (chunk == null || flag == chunk.hasUpgrade(ChunkUpgrade.LOADED) || !player.equalsPlayer(chunk.getOwner())) {
            return false;
        }
        if (flag) {
            if (player.getTeam() == null) {
                if (player.isOnline()) {
                    FTBLibIntegration.API.sendNotification((EntityPlayer)player.getPlayer(), FTBUNotifications.NO_TEAM);
                }
                return false;
            }
            if (!FTBUPermissions.allowDimension(player.getProfile(), pos.dim)) {
                return false;
            }
            int max = FTBUtilitiesAPI_Impl.INSTANCE.getRankConfig(player.getProfile(), "ftbu.chunkloader.max_chunks").getInt();
            if (max == 0) {
                return false;
            }
            int loadedChunks = 0;
            for (IClaimedChunk c : ClaimedChunkStorage.INSTANCE.getChunks(player)) {
                if (!c.hasUpgrade(ChunkUpgrade.LOADED) || ++loadedChunks < max) continue;
                return false;
            }
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new ChunkModifiedEvent.Unloaded(chunk));
        }
        chunk.setHasUpgrade(ChunkUpgrade.LOADED, flag);
        LoadedChunkStorage.INSTANCE.checkChunk(chunk, null);
        if (flag) {
            MinecraftForge.EVENT_BUS.post((Event)new ChunkModifiedEvent.Loaded(chunk));
        }
        return true;
    }

    public void onLoaded() {
        ClaimedChunkStorage.INSTANCE.init();
        long startMillis = System.currentTimeMillis();
        Backups.INSTANCE.nextBackup = startMillis + FTBUConfigBackups.backupMillis();
        this.lastRestartMessage = "";
        if (FTBUConfigGeneral.AUTO_RESTART.getBoolean() && FTBUConfigGeneral.RESTART_TIMER.getInt() > 0) {
            this.restartMillis = startMillis + (long)((double)FTBUConfigGeneral.RESTART_TIMER.getInt() * 3600.0 * 1000.0);
            FTBUFinals.LOGGER.info("Server restart in " + LMStringUtils.getTimeString((long)this.restartMillis));
        }
        FTBLibIntegration.API.ticking().add(this);
        LOCAL_BADGES.clear();
    }

    public void onLoadedBeforePlayers() {
    }

    public void onClosed() {
        ClaimedChunkStorage.INSTANCE.clear();
        LoadedChunkStorage.INSTANCE.clear();
        LOCAL_BADGES.clear();
    }

    public NBTBase serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (!this.warps.isEmpty()) {
            NBTTagCompound tag1 = new NBTTagCompound();
            for (Map.Entry<String, BlockDimPos> e : this.warps.entrySet()) {
                tag1.func_74783_a(e.getKey(), e.getValue().toIntArray());
            }
            nbt.func_74782_a("Warps", (NBTBase)tag1);
        }
        nbt.func_74782_a("Chunks", (NBTBase)ClaimedChunkStorage.INSTANCE.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(NBTBase nbt0) {
        NBTTagCompound nbt1;
        NBTTagCompound nbt = (NBTTagCompound)nbt0;
        this.nextChunkloaderUpdate = System.currentTimeMillis() + 10000L;
        this.warps.clear();
        if (nbt.func_74764_b("Warps") && (nbt1 = (NBTTagCompound)nbt.func_74781_a("Warps")) != null && !nbt1.func_82582_d()) {
            for (String s1 : nbt1.func_150296_c()) {
                this.setWarp(s1.toLowerCase(), new BlockDimPos(nbt1.func_74759_k(s1)));
            }
        }
        if (nbt.func_150297_b("Chunks", 10)) {
            ClaimedChunkStorage.INSTANCE.deserializeNBT(nbt.func_74775_l("Chunks"));
        }
        this.nextWebApiUpdate = 0L;
    }

    public void func_73660_a() {
        int secondsLeft;
        String msg;
        long now = System.currentTimeMillis();
        if (this.restartMillis > 0L && !this.lastRestartMessage.equals(msg = LMStringUtils.getTimeString((long)((long)(secondsLeft = (int)((this.restartMillis - System.currentTimeMillis()) / 1000L)) * 1000L)))) {
            this.lastRestartMessage = msg;
            if (secondsLeft <= 0) {
                CmdRestart.restart();
                return;
            }
            if (secondsLeft <= 10 || secondsLeft == 60 || secondsLeft == 300 || secondsLeft == 600 || secondsLeft == 1800) {
                ITextComponent c = FTBULang.TIMER_RESTART.textComponent(new Object[]{msg});
                c.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE);
                BroadcastSender.INSTANCE.func_145747_a(c);
            }
        }
        if (Backups.INSTANCE.nextBackup > 0L && Backups.INSTANCE.nextBackup <= now) {
            MinecraftServer server = LMServerUtils.getServer();
            Backups.INSTANCE.run(server, (ICommandSender)server, "");
        }
        if (this.nextChunkloaderUpdate < now) {
            this.nextChunkloaderUpdate = now + 7200L;
            LoadedChunkStorage.INSTANCE.checkAll();
        }
        if (Backups.INSTANCE.thread != null && Backups.INSTANCE.thread.isDone) {
            Backups.INSTANCE.thread = null;
            Backups.INSTANCE.postBackup();
        }
        if (FTBUConfigWebAPI.ENABLED.getBoolean() && this.nextWebApiUpdate < now) {
            this.nextWebApiUpdate = now + (long)FTBUConfigWebAPI.UPDATE_INTERVAL.getInt() * 60000L;
            FTBUUniverseData.exportWebAPI();
        }
    }

    public static void exportWebAPI() {
        try {
            JsonTable table = new JsonTable();
            table.setTitle("name", "Name");
            table.setTitle("deaths", "Deaths");
            table.setTitle("dph", "Deaths per hour");
            table.setTitle("last_seen", "Last time seen");
            for (IForgePlayer player : FTBLibIntegration.API.getUniverse().getPlayers()) {
                StatisticsManagerServer stats = player.stats();
                JsonTable.TableEntry tableEntry = new JsonTable.TableEntry();
                tableEntry.set("name", (JsonElement)new JsonPrimitive(player.getName()));
                tableEntry.set("deaths", (JsonElement)new JsonPrimitive((Number)stats.func_77444_a(StatList.field_188069_A)));
                tableEntry.set("dph", (JsonElement)new JsonPrimitive((Number)FTBLibStats.getDeathsPerHour((StatisticsManagerServer)stats)));
                tableEntry.set("last_seen", (JsonElement)new JsonPrimitive((Number)(player.isOnline() ? 0L : FTBLibStats.getLastSeen((StatisticsManagerServer)stats, (boolean)false))));
                table.addEntry(tableEntry);
            }
            JsonObject json = new JsonObject();
            json.add("time", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
            json.add("stats", (JsonElement)table.toJson());
            File file = FTBUConfigWebAPI.FILE_LOCATION.getString().isEmpty() ? new File(LMUtils.folderLocal, "ftbu/webapi.json") : new File(FTBUConfigWebAPI.FILE_LOCATION.getString());
            LMJsonUtils.toJson((Gson)LMJsonUtils.GSON, (File)file, (JsonElement)json);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Collection<String> listWarps() {
        if (this.warps.isEmpty()) {
            return Collections.emptySet();
        }
        return this.warps.keySet();
    }

    @Nullable
    public BlockDimPos getWarp(String s) {
        return this.warps.get(s);
    }

    public boolean setWarp(String s, @Nullable BlockDimPos pos) {
        if (pos == null) {
            return this.warps.remove(s) != null;
        }
        return this.warps.put(s, pos.copy()) == null;
    }

    public int warpsSize() {
        return this.warps.size();
    }
}

