/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world.backups;

import com.feed_the_beast.ftbl.lib.BroadcastSender;
import com.feed_the_beast.ftbl.lib.util.LMFileUtils;
import com.feed_the_beast.ftbl.lib.util.LMJsonUtils;
import com.feed_the_beast.ftbl.lib.util.LMServerUtils;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.config.FTBUConfigBackups;
import com.feed_the_beast.ftbu.world.backups.Backup;
import com.feed_the_beast.ftbu.world.backups.ThreadBackup;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;

public enum Backups {
    INSTANCE;

    public final List<Backup> backups = new ArrayList<Backup>();
    public File backupsFolder;
    public long nextBackup = -1L;
    public ThreadBackup thread;

    public void init() {
        this.backupsFolder = FTBUConfigBackups.FOLDER.getString().isEmpty() ? new File(LMUtils.folderMinecraft, "/backups/") : new File(FTBUConfigBackups.FOLDER.getString());
        this.thread = null;
        this.backups.clear();
        JsonElement element = LMJsonUtils.fromJson((File)new File(this.backupsFolder, "backups.json"));
        if (element.isJsonArray()) {
            try {
                for (JsonElement e : element.getAsJsonArray()) {
                    this.backups.add(new Backup(e.getAsJsonObject()));
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        } else if (this.backupsFolder.exists()) {
            String[] files = this.backupsFolder.list();
            int index = 0;
            if (files != null) {
                for (String s : files) {
                    String[] s1 = s.split("-");
                    if (s1.length < 6) continue;
                    int year = Integer.parseInt(s1[0]);
                    int month = Integer.parseInt(s1[1]);
                    int day = Integer.parseInt(s1[2]);
                    int hours = Integer.parseInt(s1[3]);
                    int minutes = Integer.parseInt(s1[4]);
                    int seconds = Integer.parseInt(s1[5].replace(".zip", ""));
                    Calendar c = Calendar.getInstance();
                    c.set(year, month, day, hours, minutes, seconds);
                    if (FTBUConfigBackups.COMPRESSION_LEVEL.getInt() > 0) {
                        s = s + ".zip";
                    }
                    this.backups.add(new Backup(c.getTimeInMillis(), s, ++index, true));
                }
            }
        }
        this.cleanupAndSave();
        FTBUFinals.LOGGER.info("Backups folder - " + this.backupsFolder.getAbsolutePath());
    }

    public boolean run(MinecraftServer server, ICommandSender ics, String customName) {
        boolean auto;
        if (this.thread != null) {
            return false;
        }
        boolean bl = auto = !(ics instanceof EntityPlayerMP);
        if (auto && !FTBUConfigBackups.ENABLED.getBoolean()) {
            return false;
        }
        ITextComponent c = FTBULang.BACKUP_START.textComponent(new Object[]{ics.func_70005_c_()});
        c.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE);
        BroadcastSender.INSTANCE.func_145747_a(c);
        this.nextBackup = System.currentTimeMillis() + FTBUConfigBackups.backupMillis();
        try {
            if (server.func_184103_al() != null) {
                server.func_184103_al().func_72389_g();
            }
            try {
                for (int i = 0; i < server.field_71305_c.length; ++i) {
                    if (server.field_71305_c[i] == null) continue;
                    WorldServer worldserver = server.field_71305_c[i];
                    worldserver.field_73058_d = true;
                    worldserver.func_73044_a(true, null);
                }
            }
            catch (Exception ex1) {
                FTBUFinals.LOGGER.error("World saving failed!");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        File wd = server.func_130014_f_().func_72860_G().func_75765_b();
        if (FTBUConfigBackups.USE_SEPARATE_THREAD.getBoolean()) {
            this.thread = new ThreadBackup(wd, customName);
            this.thread.start();
        } else {
            ThreadBackup.doBackup(wd, customName);
        }
        return true;
    }

    public void cleanupAndSave() {
        JsonArray a = new JsonArray();
        if (!this.backups.isEmpty()) {
            Collections.sort(this.backups, Backup.COMPARATOR);
            int backupsToKeep = FTBUConfigBackups.BACKUPS_TO_KEEP.getInt();
            if (backupsToKeep > 0) {
                int toDelete;
                if (this.backups.size() > backupsToKeep && (toDelete = this.backups.size() - backupsToKeep) > 0) {
                    for (int i = toDelete - 1; i >= 0; --i) {
                        Backup b = this.backups.get(i);
                        FTBUFinals.LOGGER.info("Deleting old backup: " + b.fileID);
                        LMFileUtils.delete((File)b.getFile());
                        this.backups.remove(i);
                    }
                }
                for (int i = this.backups.size() - 1; i >= 0; --i) {
                    if (this.backups.get(i).getFile().exists()) continue;
                    this.backups.remove(i);
                }
            }
            for (Backup t : this.backups) {
                a.add((JsonElement)t.toJsonObject());
            }
        }
        LMJsonUtils.toJson((File)new File(this.backupsFolder, "backups.json"), (JsonElement)a);
    }

    public void postBackup() {
        try {
            MinecraftServer server = LMServerUtils.getServer();
            for (int i = 0; i < server.field_71305_c.length; ++i) {
                if (server.field_71305_c[i] == null) continue;
                WorldServer worldserver = server.field_71305_c[i];
                if (!worldserver.field_73058_d) continue;
                worldserver.field_73058_d = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    int getLastIndex() {
        int i = 0;
        for (Backup b : this.backups) {
            i = Math.max(i, b.index);
        }
        return i;
    }
}

