/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.data.Profiles;
import org.blockartistry.lib.ConfigProcessor;
import org.blockartistry.lib.VersionHelper;

public final class ModOptions {
    private static final String VERSION_A = "3.2.4.0";
    public static final String CATEGORY_ASM = "asm";
    public static final String CONFIG_ENABLE_SOUND_CACHING = "Enable Sound Caching";
    public static final String CONFIG_ENABLE_WEATHER = "Enable Weather Control";
    public static final String CONFIG_ENABLE_RESET_WEATHER_ON_SLEEP = "Enable Weather Reset on Sleep Control";
    public static final String CONFIG_DISABLE_ARROW_CRITICAL_TRAIL = "Disable Arrow Critical Particle Trail";
    public static final String CATEGORY_LOGGING_CONTROL = "logging";
    public static final String CONFIG_ENABLE_ONLINE_VERSION_CHECK = "Enable Online Version Check";
    public static final String CONFIG_ENABLE_DEBUG_LOGGING = "Enable Debug Logging";
    public static final String CONFIG_ENABLE_DEBUG_DIALOG = "Enable Debug Dialog";
    public static final String CONFIG_REPORT_SERVER_STATS = "Report Server Stats";
    public static final String CONFIG_DEBUG_FLAG_MASK = "Debug Flag Mask";
    public static final String CATEGORY_RAIN = "rain";
    public static final String CONFIG_VANILLA_RAIN = "Use Vanilla Algorithms";
    public static final String CONFIG_RAIN_PARTICLE_BASE = "Particle Count Base";
    public static final String CONFIG_ALLOW_DESERT_DUST = "Desert DustJetEffect";
    public static final String CONFIG_RESET_RAIN_ON_SLEEP = "Reset Rain on Sleep";
    public static final String CONFIG_RAIN_ACTIVE_TIME_CONST = "Active duration of rain, constant";
    public static final String CONFIG_RAIN_ACTIVE_TIME_VARIABLE = "Active duration of rain, variable";
    public static final String CONFIG_RAIN_INACTIVE_TIME_CONST = "Inactive duration of rain, constant";
    public static final String CONFIG_RAIN_INACTIVE_TIME_VARIABLE = "Inactive duration of rain, variable";
    public static final String CONFIG_STORM_ACTIVE_TIME_CONST = "Active duration of thunder, constant";
    public static final String CONFIG_STORM_ACTIVE_TIME_VARIABLE = "Active duration of thunder, variable";
    public static final String CONFIG_STORM_INACTIVE_TIME_CONST = "Inactive duration of thunder, constant";
    public static final String CONFIG_STORM_INACTIVE_TIME_VARIABLE = "Inactive duration of thunder, variable";
    public static final String CONFIG_ENABLE_BACKGROUND_THUNDER = "Enable Background Thunder";
    public static final String CONFIG_THUNDER_THRESHOLD = "Rain Intensity for Background Thunder";
    public static final String CONFIG_RAIN_RIPPLE_STYLE = "Style of rain water ripple";
    public static final String CATEGORY_FOG = "fog";
    public static final String CONFIG_ENABLE_FOG_PROCESSING = "Enable Fog Processing";
    public static final String CONFIG_ENABLE_MORNING_FOG = "Morning Fog";
    public static final String CONFIG_MORNING_FOG_CHANCE = "Morning Fog Chance";
    public static final String CONFIG_ENABLE_WEATHER_FOG = "Weather Fog";
    public static final String CONFIG_ENABLE_BEDROCK_FOG = "Bedrock Fog";
    public static final String CONFIG_ALLOW_DESERT_FOG = "Desert Fog";
    public static final String CONFIG_ENABLE_ELEVATION_HAZE = "Elevation Haze";
    public static final String CONFIG_ENABLE_BIOME_FOG = "Biomes Fog";
    public static final String CATEGORY_GENERAL = "general";
    public static final String CONFIG_EXTERNAL_SCRIPTS = "External Configuration Files";
    public static final String CONFIG_MIN_RAIN_STRENGTH = "Default Minimum Rain Strength";
    public static final String CONFIG_MAX_RAIN_STRENGTH = "Default Maximum Rain Strength";
    public static final String CONFIG_FX_RANGE = "Special Effect Range";
    public static final String CONFIG_DISABLE_SUSPEND = "Disable Water Suspend Particles";
    public static final String CONFIG_STARTUP_SOUND_LIST = "Startup Sound List";
    public static final String CONFIG_HIDE_CHAT_NOTICES = "Hide Chat Notices";
    public static final String CATEGORY_AURORA = "aurora";
    public static final String CONFIG_AURORA_ENABLED = "Enabled";
    public static final String CONFIG_AURORA_SHADER = "Use Shaders";
    public static final String CATEGORY_BIOMES = "biomes";
    public static final String CONFIG_BIOME_SEALEVEL = "Overworld Sealevel Override";
    public static final String CONFIG_BIOME_ALIASES = "Biomes Alias";
    public static final String CATEGORY_BLOCK = "block";
    public static final String CATEGORY_BLOCK_EFFECTS = "effects";
    public static final String CONFIG_BLOCK_EFFECT_STEAM = "Enable Steam";
    public static final String CONFIG_BLOCK_EFFECT_FIRE = "Enable FireJetEffect Jets";
    public static final String CONFIG_BLOCK_EFFECT_BUBBLE = "Enable Bubbles";
    public static final String CONFIG_BLOCK_EFFECT_DUST = "Enable DustJetEffect Motes";
    public static final String CONFIG_BLOCK_EFFECT_FOUNTAIN = "Enable FountainJetEffect";
    public static final String CONFIG_BLOCK_EFFECT_FIREFLY = "Enable Fireflies";
    public static final String CONFIG_BLOCK_EFFECT_SPLASH = "Enable Water Splash";
    public static final String CATEGORY_SOUND = "sound";
    public static final String CONFIG_ENABLE_BIOME_SOUNDS = "Enable Biomes Sounds";
    public static final String CONFIG_MASTER_SOUND_FACTOR = "Master Sound Scale Factor";
    public static final String CONFIG_AUTO_CONFIG_CHANNELS = "Autoconfigure Channels";
    public static final String CONFIG_NORMAL_CHANNEL_COUNT = "Number Normal Channels";
    public static final String CONFIG_STREAMING_CHANNEL_COUNT = "Number Streaming Channels";
    public static final String CONFIG_STREAM_BUFFER_SIZE = "Stream Buffer Size";
    public static final String CONFIG_STREAM_BUFFER_COUNT = "Number of Stream Buffers per Channel";
    public static final String CONFIG_MUTE_WHEN_BACKGROUND = "Mute when Background";
    public static final String CONFIG_ENABLE_JUMP_SOUND = "Jump Sound";
    public static final String CONFIG_ENABLE_EQUIP_SOUND = "Equip Sound";
    public static final String CONFIG_SWORD_AS_TOOL_EQUIP_SOUND = "Sword Equip as Tool";
    public static final String CONFIG_ENABLE_CRAFTING_SOUND = "Crafting Sound";
    public static final String CONFIG_FOOTSTEPS_SOUND_FACTOR = "Footsteps Sound Factor";
    public static final String CONFIG_FOOTSTEPS_QUAD = "Footsteps as Quadruped";
    public static final String CONFIG_FOOTSTEPS_CADENCE = "First Person Footstep Cadence";
    public static final String CONFIG_ENABLE_ARMOR_SOUND = "Armor Sound";
    public static final String CONFIG_ENABLE_PUDDLE_SOUND = "Rain Puddle Sound";
    public static final String CONFIG_SOUND_CULL_THRESHOLD = "Sound Culling Threshold";
    public static final String CONFIG_CULLED_SOUNDS = "Culled Sounds";
    public static final String CONFIG_BLOCKED_SOUNDS = "Blocked Sounds";
    public static final String CONFIG_SOUND_VOLUMES = "Sound Volume";
    public static final String CONFIG_THUNDER_VOLUME = "Thunder Volume";
    public static final String CONFIG_ENABLE_BATTLEMUSIC = "Battle Music";
    public static final String CATEGORY_PLAYER = "player";
    public static final String CONFIG_SUPPRESS_POTION_PARTICLES = "Suppress Potion Particles";
    public static final String CONFIG_ENABLE_POPOFFS = "Damage Popoffs";
    public static final String CONFIG_SHOW_CRIT_WORDS = "Show Crit Words";
    public static final String CONFIG_HURT_THRESHOLD = "Hurt Threshold";
    public static final String CONFIG_HUNGER_THRESHOLD = "Hunger Threshold";
    public static final String CONFIG_ENABLE_FOOTPRINTS = "Footprints";
    public static final String CONFIG_FOOTPRINT_STYLE = "Footprint Style";
    public static final String CONFIG_SHOW_BREATH = "Show Frost Breath";
    public static final String CATEGORY_POTION_HUD = "potion hud";
    public static final String CONFIG_POTION_HUD_NONE = "No Potion HUD";
    public static final String CONFIG_POTION_HUD_ENABLE = "Enable";
    public static final String CONFIG_POTION_HUD_TRANSPARENCY = "Transparency";
    public static final String CONFIG_POTION_HUD_LEFT_OFFSET = "Horizontal Offset";
    public static final String CONFIG_POTION_HUD_TOP_OFFSET = "Vertical Offset";
    public static final String CONFIG_POTION_HUD_SCALE = "Display Scale";
    public static final String CONFIG_POTION_HUD_ANCHOR = "HUD Location";
    public static final String CATEGORY_SPEECHBUBBLES = "speechbubbles";
    public static final String CONFIG_OPTION_ENABLE_SPEECHBUBBLES = "Enable SpeechBubbles";
    public static final String CONFIG_OPTION_ENABLE_ENTITY_CHAT = "Enable Entity Chat";
    public static final String CONFIG_OPTION_ENABLE_EMOJIS = "Enable Entity Emojis";
    public static final String CONFIG_OPTION_SPEECHBUBBLE_DURATION = "Display Duration";
    public static final String CONFIG_OPTION_SPEECHBUBBLE_RANGE = "Visibility Range";
    public static final String CATEGORY_EXPLOSIONS = "explosions";
    public static final String CONFIG_ENABLE_EXPLOSIONS = "Enable Explosion Enhancement";
    public static final String CONFIG_ADD_MOB_PARTICLES = "Add Mob Models";
    public static final String CATEGORY_LIGHT_LEVEL = "lightlevel";
    public static final String CONFIG_LL_RANGE = "Block Range";
    public static final String CONFIG_LL_MOB_SPAWN_THRESHOLD = "Mob Spawn Threshold";
    public static final String CONFIG_LL_DISPLAY_MODE = "Display Mode";
    public static final String CONFIG_LL_HIDE_SAFE = "Hide Safe";
    public static final String CONFIG_LL_INDICATE_CAUTION = "Indicate Caution";
    public static final String CONFIG_LL_COLORS = "Color Set";
    public static final String CATEGORY_COMPASS = "compass";
    public static final String CONFIG_COMPASS_ENABLE = "Enable Compass";
    public static final String CONFIG_CLOCK_ENABLE = "Enable Clock";
    public static final String CONFIG_COMPASS_STYLE = "Compass Style";
    public static final String CONFIG_COMPASS_TRANSPARENCY = "Transparency";
    public static final String CONFIG_COMPASS_COORD_FORMAT = "Coord Format";
    public static final String CATEGORY_COMMANDS = "commands";
    public static final String CONFIG_COMMANDS_DS = "/ds";
    public static final String CONFIG_COMMANDS_CALC = "/calc";
    public static final String CONFIG_COMMAND_NAME = "name";
    public static final String CONFIG_COMMAND_ALIAS = "alias";
    public static final String CATEGORY_FEATURES = "features";
    public static final String CONFIG_FEATURES_ALLOW_LLHUD = "Allow Light Level HUD";
    public static final String CONFIG_FEATURES_ALLOW_CHUNKBOARDERS = "Allow Chunk Border HUD";
    public static final String CONFIG_FEATURES_ALLOW_COMPASSCLOCK = "Allow Compass and Clock HUD";
    public static final String CATEGORY_PROFILES = "profiles";

    private ModOptions() {
    }

    private static void setDefault(@Nonnull Configuration config, @Nonnull String cat, @Nonnull String prop, float prevDefault, float newDefault) {
        float cv;
        Property p;
        ConfigCategory cc = config.getCategory(cat);
        if (cc != null && (p = cc.get(prop)) != null && (cv = (float)p.getDouble()) == prevDefault) {
            p.set((double)newDefault);
        }
    }

    public static void load(Configuration config) {
        if (VersionHelper.compareVersions(config.getLoadedConfigVersion(), VERSION_A) < 0) {
            ModOptions.setDefault(config, CATEGORY_SOUND, CONFIG_FOOTSTEPS_SOUND_FACTOR, 0.15f, 0.5f);
        }
        ConfigProcessor.process(config, ModOptions.class);
        if (DSurround.config() != null) {
            Profiles.tickle();
        }
        if (DSurround.config() != null) {
            for (String cat : config.getCategoryNames()) {
                ModOptions.scrubCategory(config.getCategory(cat));
            }
        }
    }

    private static void scrubCategory(ConfigCategory category) {
        ArrayList killList = new ArrayList();
        for (Map.Entry entry : category.entrySet()) {
            if (!StringUtils.isEmpty((CharSequence)((Property)entry.getValue()).getComment())) continue;
            killList.add(entry.getKey());
        }
        for (String kill : killList) {
            category.remove((Object)kill);
        }
    }

    @ConfigProcessor.Category(value="profiles")
    @ConfigProcessor.LangKey(value="dsurround.cfg.profiles.cat.Profiles")
    @ConfigProcessor.Comment(value="Enable/disable application of built in profiles")
    public static class profiles {
        public static String PATH = null;
    }

    @ConfigProcessor.Category(value="features")
    @ConfigProcessor.Comment(value="Controls whether features are available")
    @ConfigProcessor.RestartRequired(server=true, world=true)
    public static class features {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Allow Light Level HUD")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.Comment(value="Allow the Light Level HUD")
        @ConfigProcessor.Hidden
        public static boolean allowLightLevelHUD = true;
        @ConfigProcessor.Option(value="Allow Chunk Border HUD")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.Comment(value="Allow the Chunk Border HUD")
        @ConfigProcessor.Hidden
        public static boolean allowChunkBorderHUD = true;
        @ConfigProcessor.Option(value="Allow Compass and Clock HUD")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.Comment(value="Allow the Compass and Clock HUD")
        @ConfigProcessor.Hidden
        public static boolean allowCompassClockHUD = true;
    }

    @ConfigProcessor.Category(value="commands")
    @ConfigProcessor.LangKey(value="dsurround.cfg.commands.cat.Commands")
    @ConfigProcessor.Comment(value="Options for configuring commands")
    @ConfigProcessor.RestartRequired(server=true, world=true)
    public static class commands {
        public static String PATH = null;

        @ConfigProcessor.Category(value="/calc")
        public static class calc {
            public static String PATH = null;
            @ConfigProcessor.Option(value="name")
            @ConfigProcessor.DefaultValue(value="calc")
            @ConfigProcessor.LangKey(value="dsurround.cfg.commands.Calc.Name")
            @ConfigProcessor.Comment(value="Name of the command")
            public static String commandNameCalc = "calc";
            @ConfigProcessor.Option(value="alias")
            @ConfigProcessor.DefaultValue(value="c math")
            @ConfigProcessor.LangKey(value="dsurround.cfg.commands.Calc.Alias")
            @ConfigProcessor.Comment(value="Alias for the command")
            public static String commandAliasCalc = "c math";
        }

        @ConfigProcessor.Category(value="/ds")
        public static class ds {
            public static String PATH = null;
            @ConfigProcessor.Option(value="name")
            @ConfigProcessor.DefaultValue(value="ds")
            @ConfigProcessor.LangKey(value="dsurround.cfg.commands.DS.Name")
            @ConfigProcessor.Comment(value="Name of the command")
            public static String commandNameDS = "ds";
            @ConfigProcessor.Option(value="alias")
            @ConfigProcessor.DefaultValue(value="dsurround rain")
            @ConfigProcessor.LangKey(value="dsurround.cfg.commands.DS.Alias")
            @ConfigProcessor.Comment(value="Alias for the command")
            public static String commandAliasDS = "dsurround rain";
        }
    }

    @ConfigProcessor.Category(value="compass")
    @ConfigProcessor.LangKey(value="dsurround.cfg.compass.cat.Compass")
    @ConfigProcessor.Comment(value="Options for configuring compass HUD")
    public static class compass {
        public static String PATH = null;
        public static final List<String> SORT = Arrays.asList("Enable Compass", "Compass Style", "Transparency", "Coord Format", "Enable Clock");
        @ConfigProcessor.Option(value="Enable Compass")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.compass.Enable")
        @ConfigProcessor.Comment(value="Enable/disable compass HUD when compass is held")
        public static boolean enableCompass = true;
        @ConfigProcessor.Option(value="Enable Clock")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.compass.ClockEnable")
        @ConfigProcessor.Comment(value="Enable/disable clock HUD when clock is held")
        public static boolean enableClock = true;
        @ConfigProcessor.Option(value="Compass Style")
        @ConfigProcessor.DefaultValue(value="0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.compass.Style")
        @ConfigProcessor.Comment(value="Style of compass bar")
        @ConfigProcessor.RangeInt(min=0, max=6)
        public static int compassStyle = 0;
        @ConfigProcessor.Option(value="Transparency")
        @ConfigProcessor.DefaultValue(value="0.4")
        @ConfigProcessor.LangKey(value="dsurround.cfg.compass.Transparency")
        @ConfigProcessor.Comment(value="Compass transparency")
        @ConfigProcessor.RangeFloat(min=0.0f, max=1.0f)
        public static float compassTransparency = 0.4f;
        @ConfigProcessor.Option(value="Coord Format")
        @ConfigProcessor.DefaultValue(value="x: %1$d, z: %3$d")
        @ConfigProcessor.LangKey(value="dsurround.cfg.compass.Format")
        @ConfigProcessor.Comment(value="Format string for location coordinates")
        public static String compassCoordFormat = "x: %1$d, z: %3$d";
    }

    @ConfigProcessor.Category(value="lightlevel")
    @ConfigProcessor.LangKey(value="dsurround.cfg.lightlevel.cat.LightLevel")
    @ConfigProcessor.Comment(value="Options for configuring Light Level HUD")
    public static class lightlevel {
        public static String PATH = null;
        public static final List<String> SORT = Arrays.asList("Block Range", "Mob Spawn Threshold", "Display Mode", "Hide Safe", "Indicate Caution", "Color Set");
        @ConfigProcessor.Option(value="Block Range")
        @ConfigProcessor.DefaultValue(value="24")
        @ConfigProcessor.LangKey(value="dsurround.cfg.lightlevel.Range")
        @ConfigProcessor.Comment(value="Range from player to analyze light levels")
        @ConfigProcessor.RangeInt(min=16, max=32)
        public static int llBlockRange = 24;
        @ConfigProcessor.Option(value="Mob Spawn Threshold")
        @ConfigProcessor.DefaultValue(value="7")
        @ConfigProcessor.LangKey(value="dsurround.cfg.lightlevel.MobSpawnThreshold")
        @ConfigProcessor.Comment(value="Light level at which mobs can spawn")
        @ConfigProcessor.RangeInt(min=0, max=15)
        public static int llSpawnThreshold = 7;
        @ConfigProcessor.Option(value="Display Mode")
        @ConfigProcessor.DefaultValue(value="0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.lightlevel.DisplayMode")
        @ConfigProcessor.Comment(value="0: Block Light, 1: Block Light + Sky Light")
        @ConfigProcessor.RangeInt(min=0, max=1)
        public static int llDisplayMode = 0;
        @ConfigProcessor.Option(value="Hide Safe")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.lightlevel.HideSafe")
        @ConfigProcessor.Comment(value="Hide light level information for blocks that are considered safe")
        public static boolean llHideSafe = false;
        @ConfigProcessor.Option(value="Indicate Caution")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.lightlevel.IndicateCaution")
        @ConfigProcessor.Comment(value="Indicate current light levels that will change at night which could result in mob spawns")
        public static boolean llIndicateCaution = true;
        @ConfigProcessor.Option(value="Color Set")
        @ConfigProcessor.DefaultValue(value="1")
        @ConfigProcessor.LangKey(value="dsurround.cfg.lightlevel.Colors")
        @ConfigProcessor.Comment(value="Color set: 0 bright, 1 dark")
        @ConfigProcessor.RangeInt(min=0, max=1)
        public static int llColors = 1;
    }

    @ConfigProcessor.Category(value="explosions")
    @ConfigProcessor.LangKey(value="dsurround.cfg.explosions.cat.Explosions")
    @ConfigProcessor.Comment(value="Options for configuring Explosion Enhancement")
    public static class explosions {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Enable Explosion Enhancement")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.explosions.EnableExplosions")
        @ConfigProcessor.Comment(value="Enables/disables explosion enhancement")
        public static boolean enableExplosionEnhancement = false;
        @ConfigProcessor.Option(value="Add Mob Models")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.explosions.AddMobs")
        @ConfigProcessor.Comment(value="Enables/disables addition of mob models in explosion debris")
        public static boolean addMobParticles = false;
    }

    @ConfigProcessor.Category(value="speechbubbles")
    @ConfigProcessor.LangKey(value="dsurround.cfg.speech.cat.Speech")
    @ConfigProcessor.Comment(value="Options for configuring SpeechBubbles")
    public static class speechbubbles {
        public static String PATH = null;
        public static final List<String> SORT = Arrays.asList("Enable SpeechBubbles", "Enable Entity Chat", "Enable Entity Emojis", "Display Duration", "Visibility Range");
        @ConfigProcessor.Option(value="Enable SpeechBubbles")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.speech.EnableSpeechBubbles")
        @ConfigProcessor.Comment(value="Enables/disables speech bubbles above player heads")
        public static boolean enableSpeechBubbles = false;
        @ConfigProcessor.Option(value="Enable Entity Chat")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.speech.EnableEntityChat")
        @ConfigProcessor.Comment(value="Enables/disables entity chat bubbles")
        public static boolean enableEntityChat = false;
        @ConfigProcessor.Option(value="Enable Entity Emojis")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.speech.EnableEntityEmojis")
        @ConfigProcessor.Comment(value="Enables/disables entity emojis")
        public static boolean enableEntityEmojis = false;
        @ConfigProcessor.Option(value="Display Duration")
        @ConfigProcessor.DefaultValue(value="7")
        @ConfigProcessor.LangKey(value="dsurround.cfg.speech.Duration")
        @ConfigProcessor.RangeFloat(min=5.0f, max=15.0f)
        @ConfigProcessor.Comment(value="Number of seconds to display speech before removing")
        public static float speechBubbleDuration = 7.0f;
        @ConfigProcessor.Option(value="Visibility Range")
        @ConfigProcessor.DefaultValue(value="16")
        @ConfigProcessor.LangKey(value="dsurround.cfg.speech.Range")
        @ConfigProcessor.RangeInt(min=16, max=32)
        @ConfigProcessor.Comment(value="Range at which a SpeechBubble is visible.  Filtering occurs server side.")
        public static float speechBubbleRange = 16.0f;
    }

    @ConfigProcessor.Category(value="player")
    @ConfigProcessor.LangKey(value="dsurround.cfg.player.cat.Player")
    @ConfigProcessor.Comment(value="General options for defining sound and effects the player entity")
    public static class player {
        public static String PATH = null;
        public static final List<String> SORT = Arrays.asList("Suppress Potion Particles", "Damage Popoffs", "Show Crit Words", "Footprints", "Footprint Style", "Hurt Threshold", "Hunger Threshold", "Show Frost Breath");
        @ConfigProcessor.Option(value="Suppress Potion Particles")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.player.PotionParticles")
        @ConfigProcessor.Comment(value="Suppress player's potion particles from rendering")
        public static boolean suppressPotionParticles = false;
        @ConfigProcessor.Option(value="Damage Popoffs")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.player.Popoffs")
        @ConfigProcessor.Comment(value="Controls display of damage pop-offs when an entity is damaged")
        public static boolean enableDamagePopoffs = true;
        @ConfigProcessor.Option(value="Show Crit Words")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.player.CritWords")
        @ConfigProcessor.Comment(value="Display random power word on critical hit")
        public static boolean showCritWords = true;
        @ConfigProcessor.Option(value="Footprints")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.player.Footprints")
        @ConfigProcessor.Comment(value="Enable player footprints")
        public static boolean enableFootprints = true;
        @ConfigProcessor.Option(value="Footprint Style")
        @ConfigProcessor.DefaultValue(value="6")
        @ConfigProcessor.LangKey(value="dsurround.cfg.player.FootprintStyle")
        @ConfigProcessor.Comment(value="0: shoe print, 1: square print, 2: horse hoof, 3: bird, 4: paw, 5: solid square, 6: lowres square")
        @ConfigProcessor.RangeInt(min=0, max=6)
        public static int footprintStyle = 6;
        @ConfigProcessor.Option(value="Hurt Threshold")
        @ConfigProcessor.DefaultValue(value="8")
        @ConfigProcessor.LangKey(value="dsurround.cfg.player.HurtThreshold")
        @ConfigProcessor.Comment(value="Amount of health bar remaining to trigger player hurt sound (0 disable)")
        @ConfigProcessor.RangeInt(min=0, max=10)
        public static int playerHurtThreshold = 8;
        @ConfigProcessor.Option(value="Hunger Threshold")
        @ConfigProcessor.DefaultValue(value="8")
        @ConfigProcessor.LangKey(value="dsurround.cfg.player.HungerThreshold")
        @ConfigProcessor.Comment(value="Amount of food bar remaining to trigger player hunger sound (0 disable)")
        @ConfigProcessor.RangeInt(min=0, max=10)
        public static int playerHungerThreshold = 8;
        @ConfigProcessor.Option(value="Show Frost Breath")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.player.ShowBreath")
        @ConfigProcessor.Comment(value="Show player frost breath in cold weather")
        public static boolean showBreath = true;

        @ConfigProcessor.Category(value="potion hud")
        @ConfigProcessor.LangKey(value="dsurround.cfg.player.potionHud.cat.PotionHud")
        @ConfigProcessor.Comment(value="Options for the Potion HUD overlay")
        public static class potionHUD {
            public static String PATH = null;
            public static final List<String> SORT = Arrays.asList("No Potion HUD", "Enable", "Transparency", "Display Scale", "HUD Location", "Vertical Offset", "Horizontal Offset");
            @ConfigProcessor.Option(value="No Potion HUD")
            @ConfigProcessor.DefaultValue(value="false")
            @ConfigProcessor.LangKey(value="dsurround.cfg.player.potionHud.NoHUD")
            @ConfigProcessor.Comment(value="Disables Vanilla and Dynamic Surroundings potion HUD")
            public static boolean potionHudNone = false;
            @ConfigProcessor.Option(value="Enable")
            @ConfigProcessor.DefaultValue(value="true")
            @ConfigProcessor.LangKey(value="dsurround.cfg.player.potionHud.Enable")
            @ConfigProcessor.Comment(value="Enable display of potion icons in display")
            public static boolean potionHudEnabled = true;
            @ConfigProcessor.Option(value="Transparency")
            @ConfigProcessor.DefaultValue(value="0.75")
            @ConfigProcessor.LangKey(value="dsurround.cfg.player.potionHud.Transparency")
            @ConfigProcessor.RangeFloat(min=0.0f, max=1.0f)
            @ConfigProcessor.Comment(value="Transparency factor for icons (higher more solid)")
            public static float potionHudTransparency = 0.75f;
            @ConfigProcessor.Option(value="Horizontal Offset")
            @ConfigProcessor.DefaultValue(value="5")
            @ConfigProcessor.LangKey(value="dsurround.cfg.player.potionHud.LeftOffset")
            @ConfigProcessor.RangeInt(min=0)
            @ConfigProcessor.Comment(value="Offset from left side of screen")
            public static int potionHudLeftOffset = 5;
            @ConfigProcessor.Option(value="Vertical Offset")
            @ConfigProcessor.DefaultValue(value="5")
            @ConfigProcessor.LangKey(value="dsurround.cfg.player.potionHud.TopOffset")
            @ConfigProcessor.RangeInt(min=0)
            @ConfigProcessor.Comment(value="Offset from top of screen")
            public static int potionHudTopOffset = 5;
            @ConfigProcessor.Option(value="Display Scale")
            @ConfigProcessor.DefaultValue(value="0.75")
            @ConfigProcessor.LangKey(value="dsurround.cfg.player.potionHud.Scale")
            @ConfigProcessor.RangeFloat(min=0.0f, max=1.0f)
            @ConfigProcessor.Comment(value="Size scale of icons (lower is smaller)")
            public static float potionHudScale = 0.75f;
            @ConfigProcessor.Option(value="HUD Location")
            @ConfigProcessor.DefaultValue(value="0")
            @ConfigProcessor.LangKey(value="dsurround.cfg.player.potionHud.Location")
            @ConfigProcessor.RangeInt(min=0, max=1)
            @ConfigProcessor.Comment(value="Area of the display the Potion HUD is displayed (0 upper left, 1 upper right)")
            public static int potionHudAnchor = 0;
        }
    }

    @ConfigProcessor.Category(value="sound")
    @ConfigProcessor.LangKey(value="dsurround.cfg.sound.cat.Sound")
    @ConfigProcessor.Comment(value="General options for defining sound effects")
    public static class sound {
        public static String PATH = null;
        public static final List<String> SORT = Arrays.asList("Enable Biomes Sounds", "Master Sound Scale Factor", "Footsteps Sound Factor", "Footsteps as Quadruped", "First Person Footstep Cadence", "Armor Sound", "Rain Puddle Sound", "Jump Sound", "Equip Sound", "Sword Equip as Tool", "Crafting Sound", "Autoconfigure Channels", "Number Normal Channels", "Number Streaming Channels", "Stream Buffer Size", "Number of Stream Buffers per Channel", "Mute when Background", "Thunder Volume", "Blocked Sounds", "Sound Culling Threshold", "Culled Sounds", "Sound Volume", "Battle Music");
        @ConfigProcessor.Option(value="Enable Biomes Sounds")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.BiomeSounds")
        @ConfigProcessor.Comment(value="Enable biome background and spot sounds")
        public static boolean enableBiomeSounds = true;
        @ConfigProcessor.Option(value="Master Sound Scale Factor")
        @ConfigProcessor.DefaultValue(value="1.0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.MasterScale")
        @ConfigProcessor.RangeFloat(min=0.0f, max=1.0f)
        @ConfigProcessor.Comment(value="Master volume scale factor for biome and block sounds")
        public static float masterSoundScaleFactor = 1.0f;
        @ConfigProcessor.Option(value="Autoconfigure Channels")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.AutoConfig")
        @ConfigProcessor.Comment(value="Automatically configure sound channels")
        @ConfigProcessor.RestartRequired(server=true)
        public static boolean autoConfigureChannels = true;
        @ConfigProcessor.Option(value="Number Normal Channels")
        @ConfigProcessor.DefaultValue(value="28")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.NormalChannels")
        @ConfigProcessor.RangeInt(min=28, max=255)
        @ConfigProcessor.Comment(value="Number of normal sound channels to configure in the sound system (manual)")
        @ConfigProcessor.RestartRequired(server=true)
        public static int normalSoundChannelCount = 28;
        @ConfigProcessor.Option(value="Number Streaming Channels")
        @ConfigProcessor.DefaultValue(value="4")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.StreamingChannels")
        @ConfigProcessor.RangeInt(min=4, max=255)
        @ConfigProcessor.Comment(value="Number of streaming sound channels to configure in the sound system (manual)")
        @ConfigProcessor.RestartRequired(server=true)
        public static int streamingSoundChannelCount = 4;
        @ConfigProcessor.Option(value="Stream Buffer Size")
        @ConfigProcessor.DefaultValue(value="0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.StreamBufferSize")
        @ConfigProcessor.RangeInt(min=0)
        @ConfigProcessor.Comment(value="Size of a stream buffer in kilobytes (0: system default - usually 128K bytes)")
        @ConfigProcessor.RestartRequired(server=true)
        public static int streamBufferSize = 0;
        @ConfigProcessor.Option(value="Number of Stream Buffers per Channel")
        @ConfigProcessor.DefaultValue(value="0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.StreamBufferCount")
        @ConfigProcessor.RangeInt(min=0, max=8)
        @ConfigProcessor.Comment(value="Number of stream buffers per channel (0: system default - usually 3 buffers)")
        @ConfigProcessor.RestartRequired(server=true)
        public static int streamBufferCount = 0;
        @ConfigProcessor.Option(value="Mute when Background")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.Mute")
        @ConfigProcessor.Comment(value="Mute sound when Minecraft is in the background")
        public static boolean muteWhenBackground = true;
        @ConfigProcessor.Option(value="Thunder Volume")
        @ConfigProcessor.DefaultValue(value="10000")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.ThunderVolume")
        @ConfigProcessor.Comment(value="Sound Volume of Thunder")
        @ConfigProcessor.RangeFloat(min=15.0f, max=10000.0f)
        public static float thunderVolume = 10000.0f;
        @ConfigProcessor.Option(value="Jump Sound")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.Jump")
        @ConfigProcessor.Comment(value="Enable player Jump sound effect")
        public static boolean enableJumpSound = true;
        @ConfigProcessor.Option(value="Equip Sound")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.Equip")
        @ConfigProcessor.Comment(value="Enable Weapon/Tool Equip sound effect")
        public static boolean enableEquipSound = true;
        @ConfigProcessor.Option(value="Sword Equip as Tool")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.SwordEquipAsTool")
        @ConfigProcessor.Comment(value="Enable Sword Equip sound as Tool")
        public static boolean swordEquipAsTool = false;
        @ConfigProcessor.Option(value="Crafting Sound")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.Craft")
        @ConfigProcessor.Comment(value="Enable Item Crafted sound effect")
        public static boolean enableCraftingSound = true;
        @ConfigProcessor.Option(value="Footsteps Sound Factor")
        @ConfigProcessor.DefaultValue(value="0.35")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.FootstepScale")
        @ConfigProcessor.RangeFloat(min=0.0f, max=1.0f)
        @ConfigProcessor.Comment(value="Volume scale factor for footstep sounds")
        public static float footstepsSoundFactor = 0.35f;
        @ConfigProcessor.Option(value="Footsteps as Quadruped")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.FootstepQuad")
        @ConfigProcessor.Comment(value="Simulate quadruped with Footstep effects (horse)")
        public static boolean foostepsQuadruped = false;
        @ConfigProcessor.Option(value="First Person Footstep Cadence")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.FootstepCadence")
        @ConfigProcessor.Comment(value="true to match first person arm swing; false to match 3rd person leg animation")
        public static boolean firstPersonFootstepCadence = true;
        @ConfigProcessor.Option(value="Armor Sound")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.Armor")
        @ConfigProcessor.Comment(value="Enable/disable armor sounds when moving")
        public static boolean enableArmorSounds = true;
        @ConfigProcessor.Option(value="Rain Puddle Sound")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.Puddle")
        @ConfigProcessor.Comment(value="Enable/disable rain puddle sound when moving in the rain")
        public static boolean enablePuddleSound = true;
        @ConfigProcessor.Option(value="Sound Culling Threshold")
        @ConfigProcessor.DefaultValue(value="20")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.CullInterval")
        @ConfigProcessor.RangeInt(min=0)
        @ConfigProcessor.Comment(value="Ticks between culled sound events (0 to disable culling)")
        public static int soundCullingThreshold = 20;
        @ConfigProcessor.Option(value="Battle Music")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.BattleMusic")
        @ConfigProcessor.Comment(value="Enable/disable Battle Music")
        public static boolean enableBattleMusic = false;
        @ConfigProcessor.Option(value="Culled Sounds")
        @ConfigProcessor.DefaultValue(value="minecraft:block.water.ambient,minecraft:block.lava.ambient,minecraft:entity.sheep.ambient,minecraft:entity.chicken.ambient,minecraft:entity.cow.ambient,minecraft:entity.pig.ambient")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.CulledSounds")
        @ConfigProcessor.Comment(value="Sounds to cull from frequent playing")
        @ConfigProcessor.Hidden
        public static String[] culledSounds = new String[]{"minecraft:block.water.ambient", "minecraft:block.lava.ambient", "minecraft:entity.sheep.ambient", "minecraft:entity.chicken.ambient", "minecraft:entity.cow.ambient", "minecraft:entity.pig.ambient"};
        @ConfigProcessor.Option(value="Blocked Sounds")
        @ConfigProcessor.DefaultValue(value="dsurround:bison")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.BlockedSounds")
        @ConfigProcessor.Comment(value="Sounds to block from playing")
        @ConfigProcessor.Hidden
        public static String[] blockedSounds = new String[]{"dsurround:bison"};
        @ConfigProcessor.Option(value="Sound Volume")
        @ConfigProcessor.DefaultValue(value="")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.SoundVolumes")
        @ConfigProcessor.Comment(value="Individual sound volume scaling factors")
        @ConfigProcessor.Hidden
        public static String[] soundVolumes = new String[0];
    }

    @ConfigProcessor.Category(value="block")
    @ConfigProcessor.LangKey(value="dsurround.cfg.block.cat.Blocks")
    @ConfigProcessor.Comment(value="Options for defining block specific sounds/effects")
    public static class block {
        public static String PATH = null;

        @ConfigProcessor.Category(value="effects")
        @ConfigProcessor.LangKey(value="dsurround.cfg.block.effects.cat.BlockEffects")
        @ConfigProcessor.Comment(value="Options for disabling various block effects")
        public static class effects {
            public static String PATH = null;
            @ConfigProcessor.Option(value="Enable Steam")
            @ConfigProcessor.DefaultValue(value="true")
            @ConfigProcessor.LangKey(value="dsurround.cfg.block.effects.Steam")
            @ConfigProcessor.Comment(value="Enable Steam Jets where lava meets water")
            public static boolean enableSteamJets = true;
            @ConfigProcessor.Option(value="Enable FireJetEffect Jets")
            @ConfigProcessor.DefaultValue(value="true")
            @ConfigProcessor.LangKey(value="dsurround.cfg.block.effects.Fire")
            @ConfigProcessor.Comment(value="Enable FireJetEffect Jets in lava")
            public static boolean enableFireJets = true;
            @ConfigProcessor.Option(value="Enable Bubbles")
            @ConfigProcessor.DefaultValue(value="true")
            @ConfigProcessor.LangKey(value="dsurround.cfg.block.effects.Bubble")
            @ConfigProcessor.Comment(value="Enable BubbleJetEffect Jets under water")
            public static boolean enableBubbleJets = true;
            @ConfigProcessor.Option(value="Enable DustJetEffect Motes")
            @ConfigProcessor.DefaultValue(value="true")
            @ConfigProcessor.LangKey(value="dsurround.cfg.block.effects.Dust")
            @ConfigProcessor.Comment(value="Enable DustJetEffect motes dropping from blocks")
            public static boolean enableDustJets = true;
            @ConfigProcessor.Option(value="Enable FountainJetEffect")
            @ConfigProcessor.DefaultValue(value="true")
            @ConfigProcessor.LangKey(value="dsurround.cfg.block.effects.Fountain")
            @ConfigProcessor.Comment(value="Enable FountainJetEffect jets")
            public static boolean enableFountainJets = true;
            @ConfigProcessor.Option(value="Enable Fireflies")
            @ConfigProcessor.DefaultValue(value="true")
            @ConfigProcessor.LangKey(value="dsurround.cfg.block.effects.Fireflies")
            @ConfigProcessor.Comment(value="Enable Firefly effect around plants")
            public static boolean enableFireflies = true;
            @ConfigProcessor.Option(value="Enable Water Splash")
            @ConfigProcessor.DefaultValue(value="true")
            @ConfigProcessor.LangKey(value="dsurround.cfg.block.effects.Splash")
            @ConfigProcessor.Comment(value="Enable Water Splash effects when water spills down")
            public static boolean enableWaterSplash = true;
        }
    }

    @ConfigProcessor.Category(value="biomes")
    @ConfigProcessor.LangKey(value="dsurround.cfg.biomes.cat.Biomes")
    @ConfigProcessor.Comment(value="Options for controlling biome sound/effects")
    public static class biomes {
        public static String PATH = null;
        public static final List<String> SORT = Arrays.asList("Overworld Sealevel Override", "Biomes Alias");
        @ConfigProcessor.Option(value="Overworld Sealevel Override")
        @ConfigProcessor.DefaultValue(value="0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.biomes.Sealevel")
        @ConfigProcessor.RangeInt(min=0, max=255)
        @ConfigProcessor.Comment(value="Sealevel to set for Overworld (0 use default for World)")
        public static int worldSealevelOverride = 0;
        @ConfigProcessor.Option(value="Biomes Alias")
        @ConfigProcessor.DefaultValue(value="")
        @ConfigProcessor.LangKey(value="dsurround.cfg.biomes.Aliases")
        @ConfigProcessor.Comment(value="Biomes alias list")
        public static String[] biomeAliases = new String[0];
    }

    @ConfigProcessor.Category(value="aurora")
    @ConfigProcessor.LangKey(value="dsurround.cfg.aurora.cat.Aurora")
    @ConfigProcessor.Comment(value="Options that control Aurora behavior and rendering")
    public static class aurora {
        public static String PATH = null;
        public static final List<String> SORT = Arrays.asList("Enabled", "Use Shaders");
        @ConfigProcessor.Option(value="Enabled")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.aurora.EnableAurora")
        @ConfigProcessor.Comment(value="Enable/disable Aurora processing on server/client")
        public static boolean auroraEnable = true;
        @ConfigProcessor.Option(value="Use Shaders")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.aurora.EnableShader")
        @ConfigProcessor.Comment(value="Use shader when rendering aurora")
        @ConfigProcessor.RestartRequired(world=true)
        public static boolean auroraUseShader = true;
    }

    @ConfigProcessor.Category(value="general")
    @ConfigProcessor.LangKey(value="dsurround.cfg.general.cat.General")
    @ConfigProcessor.Comment(value="Miscellaneous settings")
    public static class general {
        public static String PATH = null;
        public static final List<String> SORT = Arrays.asList("Hide Chat Notices", "Disable Water Suspend Particles", "Special Effect Range", "Default Minimum Rain Strength", "Default Maximum Rain Strength", "External Configuration Files", "Startup Sound List");
        @ConfigProcessor.Option(value="Hide Chat Notices")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.general.HideChat")
        @ConfigProcessor.Comment(value="Toggles display of Dynamic Surroundings chat notices")
        public static boolean hideChatNotices = false;
        @ConfigProcessor.Option(value="Disable Water Suspend Particles")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.general.Suspend")
        @ConfigProcessor.Comment(value="Enable/disable water depth particle effect")
        @ConfigProcessor.RestartRequired(server=true)
        public static boolean disableWaterSuspendParticle = false;
        @ConfigProcessor.Option(value="Default Minimum Rain Strength")
        @ConfigProcessor.DefaultValue(value="0.0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.general.MinRainStrength")
        @ConfigProcessor.RangeFloat(min=0.0f, max=1.0f)
        @ConfigProcessor.Comment(value="Default minimum rain strength for a dimension")
        public static float defaultMinRainStrength = 0.0f;
        @ConfigProcessor.Option(value="Default Maximum Rain Strength")
        @ConfigProcessor.DefaultValue(value="1.0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.general.MaxRainStrength")
        @ConfigProcessor.RangeFloat(min=0.0f, max=1.0f)
        @ConfigProcessor.Comment(value="Default maximum rain strength for a dimension")
        public static float defaultMaxRainStrength = 1.0f;
        @ConfigProcessor.Option(value="Special Effect Range")
        @ConfigProcessor.DefaultValue(value="24")
        @ConfigProcessor.LangKey(value="dsurround.cfg.general.FXRange")
        @ConfigProcessor.RangeInt(min=16, max=64)
        @ConfigProcessor.Comment(value="Block radius/range around player for special effect application")
        public static int specialEffectRange = 24;
        @ConfigProcessor.Option(value="External Configuration Files")
        @ConfigProcessor.DefaultValue(value="")
        @ConfigProcessor.LangKey(value="dsurround.cfg.general.ExternalScripts")
        @ConfigProcessor.Comment(value="Configuration files for customization")
        public static String[] externalScriptFiles = new String[0];
        @ConfigProcessor.Option(value="Startup Sound List")
        @ConfigProcessor.DefaultValue(value="minecraft:entity.experience_orb.pickup,minecraft:entity.chicken.egg")
        @ConfigProcessor.LangKey(value="dsurround.cfg.general.StartupSounds")
        @ConfigProcessor.Comment(value="Possible sounds to play when client reaches main game menu")
        public static String[] startupSoundList = new String[]{"minecraft:entity.experience_orb.pickup", "minecraft:entity.chicken.egg"};
    }

    @ConfigProcessor.Category(value="fog")
    @ConfigProcessor.LangKey(value="dsurround.cfg.fog.cat.Fog")
    @ConfigProcessor.Comment(value="Options that control the various fog effects in the client")
    public static class fog {
        public static String PATH = null;
        public static final List<String> SORT = Arrays.asList("Enable Fog Processing", "Morning Fog", "Morning Fog Chance", "Weather Fog", "Bedrock Fog", "Desert Fog", "Biomes Fog", "Elevation Haze");
        @ConfigProcessor.Option(value="Enable Fog Processing")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.Enable")
        @ConfigProcessor.Comment(value="Enable/disable fog processing")
        public static boolean enableFogProcessing = true;
        @ConfigProcessor.Option(value="Morning Fog")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.EnableMorning")
        @ConfigProcessor.Comment(value="Show morning fog that eventually burns off")
        public static boolean enableMorningFog = true;
        @ConfigProcessor.Option(value="Weather Fog")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.EnableWeather")
        @ConfigProcessor.Comment(value="Increase fog based on the strength of rain")
        public static boolean enableWeatherFog = true;
        @ConfigProcessor.Option(value="Bedrock Fog")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.EnableBedrock")
        @ConfigProcessor.Comment(value="Increase fog at bedrock layers")
        public static boolean enableBedrockFog = true;
        @ConfigProcessor.Option(value="Desert Fog")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.DesertFog")
        @ConfigProcessor.Comment(value="Enable/disable desert fog when raining")
        public static boolean allowDesertFog = true;
        @ConfigProcessor.Option(value="Elevation Haze")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.ElevationHaze")
        @ConfigProcessor.Comment(value="Higher the player elevation the more haze that is experienced")
        public static boolean enableElevationHaze = true;
        @ConfigProcessor.Option(value="Biomes Fog")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.BiomeFog")
        @ConfigProcessor.Comment(value="Enable biome specific fog density and color")
        public static boolean enableBiomeFog = true;
        @ConfigProcessor.Option(value="Morning Fog Chance")
        @ConfigProcessor.DefaultValue(value="1")
        @ConfigProcessor.RangeInt(min=1, max=10)
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.MorningFogChance")
        @ConfigProcessor.Comment(value="Chance morning fog will occurs expressed as 1 in N")
        public static int morningFogChance = 1;
    }

    @ConfigProcessor.Category(value="rain")
    @ConfigProcessor.LangKey(value="dsurround.cfg.rain.cat.Rain")
    @ConfigProcessor.Comment(value="Options that control rain effects in the client")
    public static class rain {
        public static String PATH = null;
        public static final List<String> SORT = Arrays.asList("Use Vanilla Algorithms", "Style of rain water ripple", "Desert DustJetEffect", "Reset Rain on Sleep", "Particle Count Base", "Active duration of rain, constant", "Active duration of rain, variable", "Inactive duration of rain, constant", "Inactive duration of rain, variable", "Active duration of thunder, constant", "Active duration of thunder, variable", "Inactive duration of thunder, constant", "Inactive duration of thunder, variable", "Enable Background Thunder", "Rain Intensity for Background Thunder");
        @ConfigProcessor.Option(value="Use Vanilla Algorithms")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.VanillaRain")
        @ConfigProcessor.Comment(value="Let Vanilla handle rain intensity and time windows")
        @ConfigProcessor.RestartRequired
        public static boolean doVanillaRain = false;
        @ConfigProcessor.Option(value="Style of rain water ripple")
        @ConfigProcessor.DefaultValue(value="0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.RippleStyle")
        @ConfigProcessor.RangeInt(min=0, max=2)
        @ConfigProcessor.Comment(value="0: original round, 1: darker round, 2: square")
        public static int rainRippleStyle = 0;
        @ConfigProcessor.Option(value="Particle Count Base")
        @ConfigProcessor.DefaultValue(value="100")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.ParticleCount")
        @ConfigProcessor.RangeInt(min=0, max=500)
        @ConfigProcessor.Comment(value="Base count of rain splash particles to generate per tick")
        public static int particleCountBase = 100;
        @ConfigProcessor.Option(value="Reset Rain on Sleep")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.ResetOnSleep")
        @ConfigProcessor.Comment(value="Reset rain/thunder when all players sleep")
        public static boolean resetRainOnSleep = true;
        @ConfigProcessor.Option(value="Active duration of rain, constant")
        @ConfigProcessor.DefaultValue(value="12000")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.ActiveTimeConst")
        @ConfigProcessor.RangeInt(min=0)
        @ConfigProcessor.Comment(value="Base time rain is active, in ticks")
        public static int rainActiveTimeConst = 12000;
        @ConfigProcessor.Option(value="Active duration of rain, variable")
        @ConfigProcessor.DefaultValue(value="12000")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.ActiveTimeVariable")
        @ConfigProcessor.RangeInt(min=0)
        @ConfigProcessor.Comment(value="Variable amount of ticks rain is active, added to the base")
        public static int rainActiveTimeVariable = 12000;
        @ConfigProcessor.Option(value="Inactive duration of rain, constant")
        @ConfigProcessor.DefaultValue(value="12000")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.InactiveTimeConst")
        @ConfigProcessor.RangeInt(min=0)
        @ConfigProcessor.Comment(value="Base time rain is inactive, in ticks")
        public static int rainInactiveTimeConst = 12000;
        @ConfigProcessor.Option(value="Inactive duration of rain, variable")
        @ConfigProcessor.DefaultValue(value="168000")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.InactiveTimeVariable")
        @ConfigProcessor.RangeInt(min=0)
        @ConfigProcessor.Comment(value="Variable amount of ticks rain is inactive, added to the base")
        public static int rainInactiveTimeVariable = 168000;
        @ConfigProcessor.Option(value="Active duration of thunder, constant")
        @ConfigProcessor.DefaultValue(value="3600")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.StormActiveTimeConst")
        @ConfigProcessor.RangeInt(min=0)
        @ConfigProcessor.Comment(value="Base time storm (thunder) is active, in ticks")
        public static int stormActiveTimeConst = 3600;
        @ConfigProcessor.Option(value="Active duration of thunder, variable")
        @ConfigProcessor.DefaultValue(value="12000")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.StormActiveTimeVariable")
        @ConfigProcessor.RangeInt(min=0)
        @ConfigProcessor.Comment(value="Variable amount of ticks storm (thunder) is active, added to the base")
        public static int stormActiveTimeVariable = 12000;
        @ConfigProcessor.Option(value="Inactive duration of thunder, constant")
        @ConfigProcessor.DefaultValue(value="12000")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.StormInactiveTimeConst")
        @ConfigProcessor.RangeInt(min=0)
        @ConfigProcessor.Comment(value="Base time storm (thunder) is inactive, in ticks")
        public static int stormInactiveTimeConst = 12000;
        @ConfigProcessor.Option(value="Inactive duration of thunder, variable")
        @ConfigProcessor.DefaultValue(value="168000")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.StormInactiveTimeVariable")
        @ConfigProcessor.RangeInt(min=0)
        @ConfigProcessor.Comment(value="Variable amount of ticks storm (thunder) is inactive, added to the base")
        public static int stormInactiveTimeVariable = 12000;
        @ConfigProcessor.Option(value="Enable Background Thunder")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.EnableThunder")
        @ConfigProcessor.Comment(value="Allow background thunder when storming")
        public static boolean allowBackgroundThunder = true;
        @ConfigProcessor.Option(value="Rain Intensity for Background Thunder")
        @ConfigProcessor.DefaultValue(value="0.75")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.ThunderThreshold")
        @ConfigProcessor.RangeFloat(min=0.0f)
        @ConfigProcessor.Comment(value="Minimum rain intensity level for background thunder to occur")
        public static float stormThunderThreshold = 0.75f;
    }

    @ConfigProcessor.Category(value="logging")
    @ConfigProcessor.LangKey(value="dsurround.cfg.logging.cat.Logging")
    @ConfigProcessor.Comment(value="Defines how Dynamic Surroundings logging will behave")
    public static class logging {
        public static String PATH = null;
        public static final List<String> SORT = Arrays.asList("Enable Online Version Check", "Enable Debug Logging", "Report Server Stats", "Debug Flag Mask", "Enable Debug Dialog");
        @ConfigProcessor.Option(value="Enable Debug Logging")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.logging.EnableDebug")
        @ConfigProcessor.Comment(value="Enables/disables debug logging of the mod")
        @ConfigProcessor.RestartRequired
        public static boolean enableDebugLogging = false;
        @ConfigProcessor.Option(value="Enable Online Version Check")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.logging.VersionCheck")
        @ConfigProcessor.Comment(value="Enables/disables display of version check information")
        @ConfigProcessor.RestartRequired
        public static boolean enableVersionChecking = true;
        @ConfigProcessor.Option(value="Enable Debug Dialog")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.logging.DebugDialog")
        @ConfigProcessor.Comment(value="Enables/disables display of debug dialog")
        @ConfigProcessor.RestartRequired
        public static boolean showDebugDialog = false;
        @ConfigProcessor.Option(value="Report Server Stats")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.logging.ServerStats")
        @ConfigProcessor.Comment(value="Enables/disables reporting of server stats")
        public static boolean reportServerStats = false;
        @ConfigProcessor.Option(value="Debug Flag Mask")
        @ConfigProcessor.DefaultValue(value="0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.logging.FlagMask")
        @ConfigProcessor.Comment(value="Bitmask for toggling various debug traces")
        @ConfigProcessor.Hidden
        public static int debugFlagMask = 0;
    }

    @ConfigProcessor.Category(value="asm")
    @ConfigProcessor.LangKey(value="dsurround.cfg.asm.cat.ASM")
    @ConfigProcessor.Comment(value="Controls ASM transforms Dynamic Surroundings performs at startup")
    @ConfigProcessor.RestartRequired(server=true, world=true)
    public static class asm {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Enable Sound Caching")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.asm.EnableSoundCache")
        @ConfigProcessor.Comment(value="Enable ASM transformations to permit sound caching")
        @ConfigProcessor.RestartRequired(server=true)
        public static boolean enableSoundCache = true;
        @ConfigProcessor.Option(value="Enable Weather Control")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.asm.EnableWeather")
        @ConfigProcessor.Comment(value="Enable ASM transformations to permit weather (rain, snow, splash, dust storms, auroras)")
        @ConfigProcessor.RestartRequired(server=true)
        public static boolean enableWeatherASM = true;
        @ConfigProcessor.Option(value="Enable Weather Reset on Sleep Control")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.asm.EnableSleepReset")
        @ConfigProcessor.Comment(value="Enable ASM transformations to allow control of player sleep impact on weather reset")
        @ConfigProcessor.RestartRequired(server=true)
        public static boolean enableResetOnSleepASM = true;
        @ConfigProcessor.Option(value="Disable Arrow Critical Particle Trail")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.asm.DisableArrow")
        @ConfigProcessor.Comment(value="Disable particle trail left by an arrow when it flies")
        @ConfigProcessor.RestartRequired(server=true)
        public static boolean disableArrowParticleTrail = true;
    }

    public static class Trace {
        public static final int TRUE_SOUND_VOLUME = 1;
        public static final int TRACE_VANILLA_SOUNDS = 2;
    }
}

