/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.asm;

import java.util.ListIterator;
import org.blockartistry.DynSurround.asm.Transformer;
import org.blockartistry.lib.asm.Transmorgrifier;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class PatchSoundHandler
extends Transmorgrifier {
    public PatchSoundHandler() {
        super("net.minecraft.client.audio.SoundHandler");
    }

    @Override
    public int classWriterFlags() {
        return 1;
    }

    @Override
    public String name() {
        return "SoundManager Replace";
    }

    @Override
    public boolean transmorgrify(ClassNode cn) {
        String name = "<init>";
        String sig = "(Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/client/settings/GameSettings;)V";
        String managerToReplace = "net/minecraft/client/audio/SoundManager";
        String newManager = "org/blockartistry/DynSurround/client/sound/SoundManagerReplacement";
        boolean modified = false;
        MethodNode m = this.findCTOR(cn, "(Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/client/settings/GameSettings;)V");
        if (m != null) {
            this.logMethod(Transformer.log(), m, "Found!");
            ListIterator itr = m.instructions.iterator();
            boolean foundNew = false;
            while (itr.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)itr.next();
                if (node.getOpcode() == 187) {
                    TypeInsnNode theNew = (TypeInsnNode)node;
                    if (!"net/minecraft/client/audio/SoundManager".equals(theNew.desc)) continue;
                    m.instructions.set(node, (AbstractInsnNode)new TypeInsnNode(187, "org/blockartistry/DynSurround/client/sound/SoundManagerReplacement"));
                    modified = true;
                    foundNew = true;
                    continue;
                }
                if (node.getOpcode() != 183) continue;
                MethodInsnNode theInvoke = (MethodInsnNode)node;
                if (!"net/minecraft/client/audio/SoundManager".equals(theInvoke.owner) || !foundNew) continue;
                Transformer.log().info("{}.{}{}", new Object[]{theInvoke.owner, theInvoke.name, theInvoke.desc});
                m.instructions.set(node, (AbstractInsnNode)new MethodInsnNode(183, "org/blockartistry/DynSurround/client/sound/SoundManagerReplacement", theInvoke.name, theInvoke.desc, false));
                modified = true;
                foundNew = false;
            }
        } else {
            Transformer.log().error("Unable to locate method {}{}", new Object[]{"<init>", "(Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/client/settings/GameSettings;)V"});
        }
        if (!modified) {
            Transformer.log().info("Unable to patch [{}]!", new Object[]{this.getClassName()});
        }
        return modified;
    }
}

