/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.asm;

import net.minecraftforge.fml.common.Loader;
import org.blockartistry.DynSurround.asm.Transformer;
import org.blockartistry.lib.asm.Transmorgrifier;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class SoundCrashFixLibrary
extends Transmorgrifier {
    public SoundCrashFixLibrary() {
        super("paulscode.sound.Library");
    }

    @Override
    public boolean isEnabled() {
        return !Loader.isModLoaded((String)"ambientsounds");
    }

    @Override
    public String name() {
        return "removeSource";
    }

    @Override
    public boolean transmorgrify(ClassNode cn) {
        String name = "removeSource";
        String sig = "(Ljava/lang/String;)V";
        MethodNode m = this.findMethod(cn, "(Ljava/lang/String;)V", "removeSource");
        if (m != null) {
            for (AbstractInsnNode insn : m.instructions) {
                if (!(insn instanceof MethodInsnNode) || !((MethodInsnNode)insn).owner.equals("paulscode/sound/Source") || !((MethodInsnNode)insn).name.equals("cleanup")) continue;
                m.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "org/blockartistry/DynSurround/client/sound/fix/SoundFixMethods", "cleanupSource", "(Lpaulscode/sound/Source;)V", false));
                m.instructions.remove(insn);
                return true;
            }
        } else {
            Transformer.log().error("Unable to locate method {}{}", new Object[]{"removeSource", "(Ljava/lang/String;)V"});
        }
        Transformer.log().info("Unable to patch [{}]!", new Object[]{this.getClassName()});
        return false;
    }
}

