/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.aurora;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.aurora.AuroraBand;
import org.blockartistry.DynSurround.client.aurora.AuroraColor;
import org.blockartistry.DynSurround.client.aurora.AuroraGeometry;
import org.blockartistry.DynSurround.client.aurora.AuroraLifeTracker;
import org.blockartistry.DynSurround.client.aurora.IAurora;
import org.blockartistry.DynSurround.client.aurora.Node;
import org.blockartistry.lib.Color;
import org.blockartistry.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public final class AuroraClassic
implements IAurora {
    protected final Random random;
    protected final AuroraBand[] bands;
    protected final Color baseColor;
    protected final Color fadeColor;
    protected final AuroraLifeTracker tracker = new AuroraLifeTracker(512, 1);

    public AuroraClassic(long seed) {
        this.random = new XorShiftRandom(seed);
        this.bands = new AuroraBand[this.random.nextInt(3) + 1];
        AuroraColor pair = AuroraColor.get(this.random);
        this.baseColor = pair.baseColor;
        this.fadeColor = pair.fadeColor;
        AuroraGeometry geo = AuroraGeometry.get(this.random);
        this.bands[0] = new AuroraBand(this.random, geo);
        if (this.bands.length > 1) {
            for (int i = 1; i < this.bands.length; ++i) {
                this.bands[i] = this.bands[0].copy(geo.bandOffset * i);
            }
        }
    }

    @Override
    public boolean isAlive() {
        return this.tracker.isAlive();
    }

    @Override
    public void setFading(boolean flag) {
        this.tracker.setFading(flag);
    }

    @Override
    public boolean isDying() {
        return this.tracker.isFading();
    }

    @Override
    public boolean isComplete() {
        return !this.isAlive();
    }

    @Override
    public void update() {
        this.tracker.update();
        for (int i = 0; i < this.bands.length; ++i) {
            this.bands[i].update();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<CLASSIC> ");
        builder.append("bands: ").append(this.bands.length);
        builder.append(", base: ").append(this.baseColor.toString());
        builder.append(", fade: ").append(this.fadeColor.toString());
        builder.append(", alpha: ").append(this.getAlpha());
        if (this.tracker.isFading()) {
            builder.append(", FADING");
        }
        return builder.toString();
    }

    @Nonnull
    protected Color getBaseColor() {
        return this.baseColor;
    }

    @Nonnull
    protected Color getFadeColor() {
        return this.fadeColor;
    }

    protected int getAlpha() {
        return (int)(this.tracker.ageRatio() * (float)this.bands[0].getAlphaLimit());
    }

    protected float getAlphaf() {
        return (float)this.getAlpha() / 255.0f;
    }

    protected int getZOffset() {
        return 150;
    }

    @Override
    public void render(float partialTick) {
        float alpha = this.getAlphaf();
        if (alpha <= 0.0f) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer renderer = tess.func_178180_c();
        double tranY = 64.0;
        double tranX = mc.field_71439_g.field_70165_t - (mc.field_71439_g.field_70142_S + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70142_S) * (double)partialTick);
        double tranZ = mc.field_71439_g.field_70161_v - (double)this.getZOffset() - (mc.field_71439_g.field_70136_U + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70136_U) * (double)partialTick);
        Color base = this.getBaseColor();
        Color fade = this.getFadeColor();
        double zero = 0.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179137_b((double)tranX, (double)64.0, (double)tranZ);
        GlStateManager.func_179139_a((double)0.5, (double)8.0, (double)0.5);
        GlStateManager.func_179090_x();
        GlStateManager.func_179106_n();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179118_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        renderer.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        for (int b = 0; b < this.bands.length; ++b) {
            this.bands[b].translate(partialTick);
            Node[] array = this.bands[b].getNodeList();
            for (int i = 0; i < array.length - 1; ++i) {
                double posY2;
                double tetZ2;
                double tetX2;
                double posZ2;
                double posX2;
                Node node = array[i];
                double posY = node.getModdedY();
                double posX = node.tetX;
                double posZ = node.tetZ;
                double tetX = node.tetX2;
                double tetZ = node.tetZ2;
                if (i < array.length - 2) {
                    Node nodePlus = array[i + 1];
                    posX2 = nodePlus.tetX;
                    posZ2 = nodePlus.tetZ;
                    tetX2 = nodePlus.tetX2;
                    tetZ2 = nodePlus.tetZ2;
                    posY2 = nodePlus.getModdedY();
                } else {
                    posX2 = tetX2 = (double)node.posX;
                    posZ2 = tetZ2 = (double)node.getModdedZ();
                    posY2 = 0.0;
                }
                renderer.func_181662_b(posX, 0.0, posZ).func_181666_a(base.red, base.green, base.blue, alpha).func_181675_d();
                renderer.func_181662_b(posX, posY, posZ).func_181666_a(fade.red, fade.green, fade.blue, 0.0f).func_181675_d();
                renderer.func_181662_b(posX2, posY2, posZ2).func_181666_a(fade.red, fade.green, fade.blue, 0.0f).func_181675_d();
                renderer.func_181662_b(posX2, posY2, posZ2).func_181666_a(fade.red, fade.green, fade.blue, 0.0f).func_181675_d();
                renderer.func_181662_b(posX2, 0.0, posZ2).func_181666_a(base.red, base.green, base.blue, alpha).func_181675_d();
                renderer.func_181662_b(posX, 0.0, posZ).func_181666_a(base.red, base.green, base.blue, alpha).func_181675_d();
                renderer.func_181662_b(posX, 0.0, posZ).func_181666_a(base.red, base.green, base.blue, alpha).func_181675_d();
                renderer.func_181662_b(posX2, 0.0, posZ2).func_181666_a(base.red, base.green, base.blue, alpha).func_181675_d();
                renderer.func_181662_b(tetX2, 0.0, tetZ2).func_181666_a(base.red, base.green, base.blue, alpha).func_181675_d();
                renderer.func_181662_b(tetX2, 0.0, tetZ2).func_181666_a(base.red, base.green, base.blue, alpha).func_181675_d();
                renderer.func_181662_b(tetX, 0.0, tetZ).func_181666_a(base.red, base.green, base.blue, alpha).func_181675_d();
                renderer.func_181662_b(posX, 0.0, posZ).func_181666_a(base.red, base.green, base.blue, alpha).func_181675_d();
                renderer.func_181662_b(tetX, 0.0, tetZ).func_181666_a(base.red, base.green, base.blue, alpha).func_181675_d();
                renderer.func_181662_b(tetX, posY, tetZ).func_181666_a(fade.red, fade.green, fade.blue, 0.0f).func_181675_d();
                renderer.func_181662_b(tetX2, posY2, tetZ2).func_181666_a(fade.red, fade.green, fade.blue, 0.0f).func_181675_d();
                renderer.func_181662_b(tetX2, posY2, tetZ2).func_181666_a(fade.red, fade.green, fade.blue, 0.0f).func_181675_d();
                renderer.func_181662_b(tetX2, 0.0, tetZ2).func_181666_a(base.red, base.green, base.blue, alpha).func_181675_d();
                renderer.func_181662_b(tetX, 0.0, tetZ).func_181666_a(base.red, base.green, base.blue, alpha).func_181675_d();
            }
        }
        tess.func_78381_a();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179127_m();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }
}

