/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.aurora;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.aurora.AuroraLifeTracker;
import org.blockartistry.DynSurround.client.aurora.AuroraUtils;
import org.blockartistry.DynSurround.client.aurora.IAurora;
import org.blockartistry.DynSurround.client.shader.Shaders;
import org.blockartistry.lib.Color;
import org.blockartistry.lib.gfx.shaders.ShaderException;
import org.blockartistry.lib.gfx.shaders.ShaderProgram;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AuroraShader
implements IAurora {
    protected ShaderProgram program;
    protected ShaderProgram.IShaderUseCallback callback;
    protected AuroraLifeTracker tracker = new AuroraLifeTracker(512, 1);

    public AuroraShader() {
        this.program = Shaders.AURORA;
        this.callback = new ShaderProgram.IShaderUseCallback(){

            @Override
            public void call(ShaderProgram shader) throws ShaderException {
                shader.set("time", AuroraUtils.getTimeSeconds() * 0.75f);
                shader.set("resolution", AuroraShader.this.getAuroraWidth(), AuroraShader.this.getAuroraHeight());
                shader.set("topColor", Color.AURORA_RED);
                shader.set("middleColor", Color.AURORA_GREEN);
                shader.set("bottomColor", Color.AURORA_BLUE);
                shader.set("alpha", AuroraShader.this.tracker.ageRatio());
            }
        };
    }

    protected int getZOffset() {
        return (AuroraUtils.getChunkRenderDistance() + 1) * 16;
    }

    protected int getAuroraWidth() {
        int chunks = Math.min(AuroraUtils.getChunkRenderDistance() - 1, 8);
        return chunks * 16 * 5;
    }

    protected int getAuroraHeight() {
        return 200;
    }

    @Override
    public boolean isAlive() {
        return this.tracker.isAlive();
    }

    @Override
    public void setFading(boolean flag) {
        this.tracker.setFading(flag);
    }

    @Override
    public boolean isDying() {
        return this.tracker.isFading();
    }

    @Override
    public void update() {
        this.tracker.update();
    }

    @Override
    public boolean isComplete() {
        return !this.tracker.isAlive();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<SHADER> ");
        builder.append("alpha: ").append((int)(this.tracker.ageRatio() * 255.0f));
        if (!this.tracker.isAlive()) {
            builder.append(", DEAD");
        } else if (this.tracker.isFading()) {
            builder.append(", FADING");
        }
        return builder.toString();
    }

    @Override
    public void render(float partialTick) {
        if (this.program == null) {
            return;
        }
        try {
            int width = this.getAuroraWidth();
            int height = this.getAuroraHeight();
            int xOffset = -(width / 2);
            int yOffset = 20;
            Minecraft mc = Minecraft.func_71410_x();
            double tranY = (double)AuroraUtils.getSeaLevel() - (mc.field_71439_g.field_70137_T + (mc.field_71439_g.field_70163_u - mc.field_71439_g.field_70137_T) * (double)partialTick);
            double tranX = mc.field_71439_g.field_70165_t - (mc.field_71439_g.field_70142_S + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70142_S) * (double)partialTick);
            double tranZ = mc.field_71439_g.field_70161_v - (double)this.getZOffset() - (mc.field_71439_g.field_70136_U + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70136_U) * (double)partialTick);
            GlStateManager.func_179094_E();
            GL11.glPushAttrib((int)1048575);
            GlStateManager.func_179137_b((double)(tranX + (double)xOffset), (double)(tranY + 20.0), (double)tranZ);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            this.program.use(this.callback);
            VertexBuffer renderer = Tessellator.func_178181_a().func_178180_c();
            GL11.glFrontFace((int)2304);
            renderer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
            renderer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            renderer.func_181662_b(0.0, (double)height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            renderer.func_181662_b((double)width, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            renderer.func_181662_b((double)width, (double)height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GL11.glFrontFace((int)2305);
            this.program.unUse();
            GlStateManager.func_179084_k();
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.program = null;
        }
    }
}

