/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.aurora;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.aurora.AuroraBand;
import org.blockartistry.DynSurround.client.aurora.AuroraColor;
import org.blockartistry.DynSurround.client.aurora.AuroraGeometry;
import org.blockartistry.DynSurround.client.aurora.AuroraLifeTracker;
import org.blockartistry.DynSurround.client.aurora.AuroraUtils;
import org.blockartistry.DynSurround.client.aurora.IAurora;
import org.blockartistry.DynSurround.client.aurora.Node;
import org.blockartistry.DynSurround.client.shader.Shaders;
import org.blockartistry.lib.Color;
import org.blockartistry.lib.gfx.OpenGlState;
import org.blockartistry.lib.gfx.OpenGlUtil;
import org.blockartistry.lib.gfx.shaders.ShaderException;
import org.blockartistry.lib.gfx.shaders.ShaderProgram;
import org.blockartistry.lib.math.MathStuff;
import org.blockartistry.lib.random.XorShiftRandom;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AuroraShaderBand
implements IAurora {
    protected ShaderProgram program;
    protected ShaderProgram.IShaderUseCallback callback;
    protected final Color baseColor;
    protected final Color fadeColor;
    protected final Color middleColor;
    protected AuroraLifeTracker tracker = new AuroraLifeTracker(512, 1);
    protected final Random random;
    protected final AuroraBand[] bands;
    protected final float auroraWidth;
    protected final float panelTexWidth;

    public AuroraShaderBand(long seed) {
        this.random = new XorShiftRandom(seed * 2L);
        this.bands = new AuroraBand[this.random.nextInt(3) + 1];
        AuroraColor colors = AuroraColor.get(this.random);
        this.baseColor = colors.baseColor;
        this.fadeColor = colors.fadeColor;
        this.middleColor = colors.middleColor;
        this.program = Shaders.AURORA;
        this.callback = new ShaderProgram.IShaderUseCallback(){

            @Override
            public void call(ShaderProgram shader) throws ShaderException {
                shader.set("time", AuroraUtils.getTimeSeconds() * 0.75f);
                shader.set("resolution", AuroraShaderBand.this.getAuroraWidth(), AuroraShaderBand.this.getAuroraHeight());
                shader.set("topColor", AuroraShaderBand.this.fadeColor);
                shader.set("middleColor", AuroraShaderBand.this.middleColor);
                shader.set("bottomColor", AuroraShaderBand.this.baseColor);
                shader.set("alpha", AuroraShaderBand.this.getAlpha());
            }
        };
        AuroraGeometry geo = AuroraGeometry.get(this.random);
        this.bands[0] = new AuroraBand(this.random, geo, true, true);
        if (this.bands.length > 1) {
            for (int i = 1; i < this.bands.length; ++i) {
                this.bands[i] = this.bands[0].copy(geo.bandOffset * i);
            }
        }
        this.auroraWidth = (float)this.bands[0].getNodeList().length * this.bands[0].getNodeWidth();
        this.panelTexWidth = this.bands[0].getNodeWidth() / this.auroraWidth;
    }

    protected float getAlpha() {
        return MathStuff.clamp((float)this.bands[0].getAlphaLimit() / 255.0f * this.tracker.ageRatio() * 2.0f, 0.0f, 1.0f);
    }

    protected float getZOffset() {
        return 150.0f;
    }

    protected float getAuroraWidth() {
        return this.auroraWidth;
    }

    protected float getAuroraHeight() {
        return 18.0f;
    }

    @Override
    public boolean isAlive() {
        return this.tracker.isAlive();
    }

    @Override
    public void setFading(boolean flag) {
        this.tracker.setFading(flag);
    }

    @Override
    public boolean isDying() {
        return this.tracker.isFading();
    }

    @Override
    public void update() {
        this.tracker.update();
    }

    @Override
    public boolean isComplete() {
        return !this.tracker.isAlive();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<SHADER> ");
        builder.append(" base: ").append(this.baseColor.toString());
        builder.append(", mid: ").append(this.middleColor.toString());
        builder.append(", fade: ").append(this.fadeColor.toString());
        builder.append(", alpha: ").append((int)(this.getAlpha() * 255.0f));
        if (!this.tracker.isAlive()) {
            builder.append(", DEAD");
        } else if (this.tracker.isFading()) {
            builder.append(", FADING");
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(float partialTick) {
        if (this.program == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer renderer = tess.func_178180_c();
        double tranY = 44.0;
        double tranX = mc.field_71439_g.field_70165_t - (mc.field_71439_g.field_70142_S + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70142_S) * (double)partialTick);
        double tranZ = mc.field_71439_g.field_70161_v - (double)this.getZOffset() - (mc.field_71439_g.field_70136_U + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70136_U) * (double)partialTick);
        OpenGlState glState = OpenGlState.push();
        GlStateManager.func_179137_b((double)tranX, (double)44.0, (double)tranZ);
        GlStateManager.func_179139_a((double)0.5, (double)10.0, (double)0.5);
        GlStateManager.func_179140_f();
        OpenGlUtil.setAuroraBlend();
        GL11.glFrontFace((int)2304);
        try {
            this.program.use(this.callback);
            for (int b = 0; b < this.bands.length; ++b) {
                this.bands[b].translate(partialTick);
                renderer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
                Node[] array = this.bands[b].getNodeList();
                for (int i = 0; i < array.length - 1; ++i) {
                    double posY2;
                    double posZ2;
                    double posX2;
                    float v1 = 0.0f;
                    float v2 = 1.0f;
                    float u1 = (float)i * this.panelTexWidth;
                    float u2 = u1 + this.panelTexWidth;
                    Node node = array[i];
                    double posY = node.getModdedY();
                    double posX = node.tetX;
                    double posZ = node.tetZ;
                    double zero = 0.0;
                    if (i < array.length - 2) {
                        Node nodePlus = array[i + 1];
                        posX2 = nodePlus.tetX;
                        posZ2 = nodePlus.tetZ;
                        posY2 = nodePlus.getModdedY();
                    } else {
                        posX2 = node.posX;
                        posZ2 = node.getModdedZ();
                        posY2 = 0.0;
                    }
                    renderer.func_181662_b(posX, 0.0, posZ).func_187315_a((double)u1, 0.0).func_181675_d();
                    renderer.func_181662_b(posX, posY, posZ).func_187315_a((double)u1, 1.0).func_181675_d();
                    renderer.func_181662_b(posX2, 0.0, posZ2).func_187315_a((double)u2, 0.0).func_181675_d();
                    renderer.func_181662_b(posX2, posY2, posZ2).func_187315_a((double)u2, 1.0).func_181675_d();
                }
                tess.func_78381_a();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.program = null;
        }
        finally {
            try {
                if (this.program != null) {
                    this.program.unUse();
                }
            }
            catch (Throwable throwable) {}
        }
        GL11.glFrontFace((int)2305);
        OpenGlState.pop(glState);
    }
}

