/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.implem;

import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.client.footsteps.implem.BasicAcoustic;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;

@SideOnly(value=Side.CLIENT)
public class AcousticsManager {
    private final HashMap<String, IAcoustic> acoustics = new HashMap();
    public static final IAcoustic[] EMPTY = new IAcoustic[0];
    public static final IAcoustic[] NOT_EMITTER = new IAcoustic[]{new BasicAcoustic("NOT_EMITTER")};
    public static final IAcoustic[] MESSY_GROUND = new IAcoustic[]{new BasicAcoustic("MESSY_GROUND")};
    public static IAcoustic[] SWIM;
    public static IAcoustic[] JUMP;
    public static IAcoustic[] SPLASH;

    public void addAcoustic(@Nonnull IAcoustic acoustic) {
        this.acoustics.put(acoustic.getAcousticName(), acoustic);
    }

    @Nullable
    public IAcoustic getAcoustic(@Nonnull String name) {
        return this.acoustics.get(name);
    }

    @Nonnull
    public IAcoustic[] compileAcoustics(@Nonnull String acousticName) {
        if (acousticName.equals("NOT_EMITTER")) {
            return NOT_EMITTER;
        }
        if (acousticName.equals("MESSY_GROUND")) {
            return MESSY_GROUND;
        }
        IAcoustic[] result = (IAcoustic[])Arrays.stream(acousticName.split(",")).map(fragment -> {
            IAcoustic a = this.acoustics.get(fragment);
            if (a == null) {
                DSurround.log().warn("Acoustic '%s' not found!", fragment);
            }
            return a;
        }).filter(a -> a != null).toArray(IAcoustic[]::new);
        return result.length == 0 ? EMPTY : result;
    }
}

