/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.implem;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.footsteps.interfaces.EventType;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IOptions;
import org.blockartistry.DynSurround.client.footsteps.interfaces.ISoundPlayer;

@SideOnly(value=Side.CLIENT)
public class BasicAcoustic
implements IAcoustic {
    protected String acousticName;
    protected SoundEvent sound;
    protected float volMin = 1.0f;
    protected float volMax = 1.0f;
    protected float pitchMin = 1.0f;
    protected float pitchMax = 1.0f;
    protected IOptions outputOptions;

    public BasicAcoustic() {
        this("Unnamed");
    }

    public BasicAcoustic(@Nonnull String name) {
        this.acousticName = name;
    }

    @Override
    @Nonnull
    public String getAcousticName() {
        return this.acousticName;
    }

    @Override
    public void playSound(@Nonnull ISoundPlayer player2, @Nonnull EntityLivingBase location, @Nonnull EventType event, @Nullable IOptions inputOptions) {
        if (this.sound == null) {
            return;
        }
        float volume = this.generateVolume(player2.getRNG());
        float pitch = this.generatePitch(player2.getRNG());
        if (inputOptions != null) {
            if (inputOptions.getGlidingVolume() > 0.0f) {
                volume = this.volMin + (this.volMax - this.volMin) * inputOptions.getGlidingVolume();
            }
            if (inputOptions.getGlidingPitch() > 0.0f) {
                pitch = this.pitchMin + (this.pitchMax - this.pitchMin) * inputOptions.getGlidingPitch();
            }
            volume *= inputOptions.getVolumeScale();
            pitch *= inputOptions.getPitchScale();
        }
        player2.playSound(location, this.sound, volume, pitch, this.outputOptions);
    }

    private float generateVolume(@Nonnull Random rng) {
        return this.randAB(rng, this.volMin, this.volMax);
    }

    private float generatePitch(@Nonnull Random rng) {
        return this.randAB(rng, this.pitchMin, this.pitchMax);
    }

    private float randAB(@Nonnull Random rng, float a, float b) {
        if (a >= b) {
            return a;
        }
        return a + rng.nextFloat() * (b - a);
    }

    public void setSound(@Nonnull SoundEvent sound2) {
        this.sound = sound2;
    }

    public void setVolMin(float volMin) {
        this.volMin = volMin;
    }

    public void setVolMax(float volMax) {
        this.volMax = volMax;
    }

    public void setPitchMin(float pitchMin) {
        this.pitchMin = pitchMin;
    }

    public void setPitchMax(float pitchMax) {
        this.pitchMax = pitchMax;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getAcousticName()).append('[');
        if (this.sound != null) {
            builder.append(this.sound.func_187503_a());
        } else {
            builder.append("<NO SOUND>");
        }
        builder.append(']');
        return builder.toString();
    }
}

