/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.implem;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.footsteps.implem.AcousticsManager;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.DynSurround.registry.BlockInfo;

@SideOnly(value=Side.CLIENT)
public class BlockAcousticMap {
    public static final IAcoustic[] NO_ACOUSTICS = new IAcoustic[0];
    private final IAcousticResolver resolver;
    private final BlockInfo.BlockInfoMutable key = new BlockInfo.BlockInfoMutable();
    private Map<BlockInfo, IAcoustic[]> data = new HashMap<BlockInfo, IAcoustic[]>();
    private Map<IBlockState, IAcoustic[]> cache = new IdentityHashMap<IBlockState, IAcoustic[]>();
    private Map<IBlockState, IAcoustic[]> specialCache = new IdentityHashMap<IBlockState, IAcoustic[]>();

    public BlockAcousticMap() {
        this(null);
    }

    public BlockAcousticMap(@Nullable IAcousticResolver resolver) {
        this.resolver = resolver;
        this.data.put(new BlockInfo(Blocks.field_150350_a), AcousticsManager.NOT_EMITTER);
    }

    @Nullable
    public IAcoustic[] getBlockAcoustics(@Nonnull IBlockState state) {
        IAcoustic[] result = this.cache.get(state);
        if (result == null) {
            result = this.data.get(this.key.set(state));
            if (result == null && this.key.hasSubTypes()) {
                result = this.data.get(this.key.asGeneric());
            }
            if (result == null && this.resolver != null) {
                result = this.resolver.resolve(state);
            }
            if (result == null) {
                result = NO_ACOUSTICS;
            }
            this.cache.put(state, result);
        }
        return result == NO_ACOUSTICS ? null : result;
    }

    @Nullable
    public IAcoustic[] getBlockAcousticsWithSpecial(@Nonnull IBlockState state) {
        IAcoustic[] result = this.specialCache.get(state);
        if (result == null) {
            result = this.data.get(this.key.set(state));
            if (result == null) {
                if (this.key.hasSubTypes()) {
                    result = this.data.get(this.key.asGeneric());
                } else if (this.key.hasSpecialMeta()) {
                    result = this.data.get(this.key.asSpecial());
                }
            }
            if (result == null) {
                result = NO_ACOUSTICS;
            }
            this.specialCache.put(state, result);
        }
        return result == NO_ACOUSTICS ? null : result;
    }

    public void put(@Nonnull BlockInfo info, IAcoustic[] acoustics) {
        this.data.put(info, acoustics);
    }

    public void clear() {
        this.data = new HashMap<BlockInfo, IAcoustic[]>(this.data.size());
        this.cache = new IdentityHashMap<IBlockState, IAcoustic[]>(this.cache.size());
        this.specialCache = new IdentityHashMap<IBlockState, IAcoustic[]>(this.specialCache.size());
    }

    public void freeze() {
        this.data = new ImmutableMap.Builder().putAll(this.data).build();
    }

    public static interface IAcousticResolver {
        public IAcoustic[] resolve(@Nonnull IBlockState var1);
    }
}

