/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.implem;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.footsteps.implem.AcousticsManager;
import org.blockartistry.DynSurround.client.footsteps.implem.BlockAcousticMap;
import org.blockartistry.DynSurround.client.footsteps.implem.Substrate;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.DynSurround.facade.FacadeHelper;
import org.blockartistry.DynSurround.registry.BlockInfo;
import org.blockartistry.lib.BlockNameUtil;
import org.blockartistry.lib.MCHelper;

@SideOnly(value=Side.CLIENT)
public class BlockMap {
    private final AcousticsManager acousticsManager;
    private final BlockAcousticMap metaMap;
    private Map<Substrate, BlockAcousticMap> substrateMap = new EnumMap<Substrate, BlockAcousticMap>(Substrate.class);
    private static final THashMap<String, List<MacroEntry>> macros = new THashMap();

    public BlockMap(@Nonnull AcousticsManager manager) {
        this.acousticsManager = manager;
        this.metaMap = new BlockAcousticMap(bs -> this.resolve(bs));
    }

    @Nullable
    public IAcoustic[] resolve(@Nonnull IBlockState state) {
        return ClientRegistry.FOOTSTEPS.resolvePrimitive(state);
    }

    public boolean hasAcoustics(@Nonnull IBlockState state) {
        IAcoustic[] a = this.metaMap.getBlockAcoustics(state);
        return a != null && a != BlockAcousticMap.NO_ACOUSTICS;
    }

    @Nullable
    public IAcoustic[] getBlockAcoustics(@Nonnull World world, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
        IBlockState trueState = FacadeHelper.resolveState(state, world, pos, EnumFacing.UP);
        return this.metaMap.getBlockAcoustics(trueState);
    }

    @Nullable
    public IAcoustic[] getBlockSubstrateAcoustics(@Nonnull World world, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Substrate substrate) {
        IBlockState trueState = FacadeHelper.resolveState(state, world, pos, EnumFacing.UP);
        BlockAcousticMap sub = this.substrateMap.get((Object)substrate);
        return sub != null ? sub.getBlockAcousticsWithSpecial(trueState) : null;
    }

    private void put(@Nonnull Block block2, int meta, @Nonnull String substrate, @Nonnull String value) {
        Substrate s = Substrate.get(substrate);
        IAcoustic[] acoustics = this.acousticsManager.compileAcoustics(value);
        if (s == null) {
            this.metaMap.put(new BlockInfo(block2, meta), acoustics);
        } else {
            BlockAcousticMap sub = this.substrateMap.get((Object)s);
            if (sub == null) {
                sub = new BlockAcousticMap();
                this.substrateMap.put(s, sub);
            }
            sub.put(new BlockInfo(block2, meta), acoustics);
        }
    }

    private void expand(@Nonnull Block block2, @Nonnull String value) {
        List macro = (List)macros.get((Object)value);
        if (macro != null) {
            for (MacroEntry entry : macro) {
                int trueMeta = MCHelper.hasVariants(block2) ? entry.meta : -100;
                this.put(block2, trueMeta, entry.substrate, entry.value);
            }
        } else {
            DSurround.log().debug("Unknown macro '%s'", value);
        }
    }

    public void register(@Nonnull String key, @Nonnull String value) {
        BlockNameUtil.NameResult result = BlockNameUtil.parseBlockName(key);
        if (result != null) {
            String blockName = result.getBlockName();
            Block block2 = MCHelper.getBlockByName(blockName);
            if (block2 == null) {
                DSurround.log().debug("Unable to locate block for blockMap '%s'", blockName);
            } else if (block2 == Blocks.field_150350_a) {
                DSurround.log().warn("Attempt to insert AIR into blockMap '%s'", blockName);
            } else if (value.startsWith("#")) {
                this.expand(block2, value);
            } else {
                int meta = result.isGeneric() ? -1 : (result.noMetadataSpecified() ? (MCHelper.hasVariants(block2) ? -1 : -100) : result.getMetadata());
                String substrate = result.getExtras();
                this.put(block2, meta, substrate, value);
            }
        } else {
            DSurround.log().warn("Malformed key in blockMap '%s'", key);
        }
    }

    @Nonnull
    private static String combine(@Nonnull IAcoustic[] acoustics) {
        StringBuilder builder = new StringBuilder();
        boolean addComma = false;
        for (IAcoustic a : acoustics) {
            if (addComma) {
                builder.append(",");
            } else {
                addComma = true;
            }
            builder.append(a.getAcousticName());
        }
        return builder.toString();
    }

    public void collectData(@Nonnull World world, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull List<String> data) {
        IAcoustic[] temp = this.getBlockAcoustics(world, state, pos);
        if (temp != null) {
            data.add(BlockMap.combine(temp));
        }
        for (Map.Entry<Substrate, BlockAcousticMap> e : this.substrateMap.entrySet()) {
            IAcoustic[] acoustics = e.getValue().getBlockAcousticsWithSpecial(state);
            if (acoustics == null) continue;
            data.add((Object)((Object)e.getKey()) + ":" + BlockMap.combine(acoustics));
        }
    }

    public void clear() {
        this.metaMap.clear();
        this.substrateMap = new EnumMap<Substrate, BlockAcousticMap>(Substrate.class);
        this.metaMap.put(new BlockInfo(Blocks.field_150350_a), AcousticsManager.NOT_EMITTER);
    }

    public void freeze() {
        this.metaMap.freeze();
    }

    static {
        ArrayList<MacroEntry> entries = new ArrayList<MacroEntry>();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(new MacroEntry("messy", "MESSY_GROUND"));
        entries.add(new MacroEntry("foliage", "straw"));
        macros.put((Object)"#sapling", entries);
        macros.put((Object)"#reed", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "leaves"));
        entries.add(new MacroEntry("messy", "MESSY_GROUND"));
        entries.add(new MacroEntry("foliage", "brush"));
        macros.put((Object)"#plant", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "leaves"));
        entries.add(new MacroEntry("messy", "MESSY_GROUND"));
        entries.add(new MacroEntry("foliage", "brush_straw_transition"));
        macros.put((Object)"#bush", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(new MacroEntry("messy", "MESSY_GROUND"));
        entries.add(new MacroEntry(0, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(1, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(2, "foliage", "brush"));
        entries.add(new MacroEntry(3, "foliage", "brush"));
        entries.add(new MacroEntry(4, "foliage", "brush_straw_transition"));
        entries.add(new MacroEntry(5, "foliage", "brush_straw_transition"));
        entries.add(new MacroEntry(6, "foliage", "straw"));
        entries.add(new MacroEntry(7, "foliage", "straw"));
        macros.put((Object)"#wheat", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(new MacroEntry("messy", "MESSY_GROUND"));
        entries.add(new MacroEntry(0, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(1, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(2, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(3, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(4, "foliage", "brush"));
        entries.add(new MacroEntry(5, "foliage", "brush"));
        entries.add(new MacroEntry(6, "foliage", "brush"));
        entries.add(new MacroEntry(7, "foliage", "brush"));
        macros.put((Object)"#crop", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(new MacroEntry("messy", "MESSY_GROUND"));
        entries.add(new MacroEntry(0, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(1, "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry(2, "foliage", "brush"));
        entries.add(new MacroEntry(3, "foliage", "brush"));
        macros.put((Object)"#beets", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(new MacroEntry("bigger", "bluntwood"));
        macros.put((Object)"#fence", entries);
    }

    private static class MacroEntry {
        public final int meta;
        public final String substrate;
        public final String value;

        public MacroEntry(@Nonnull String substrate, @Nonnull String value) {
            this(-1, substrate, value);
        }

        public MacroEntry(int meta, @Nonnull String substrate, @Nonnull String value) {
            this.meta = meta;
            this.substrate = substrate;
            this.value = value;
        }
    }
}

