/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.implem;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.footsteps.interfaces.EventType;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IOptions;
import org.blockartistry.DynSurround.client.footsteps.interfaces.ISoundPlayer;

@SideOnly(value=Side.CLIENT)
public class EventSelectorAcoustics
implements IAcoustic {
    private final String name;
    private final Map<EventType, IAcoustic> pairs = new EnumMap<EventType, IAcoustic>(EventType.class);

    public EventSelectorAcoustics(@Nonnull String acousticName) {
        this.name = acousticName;
    }

    @Override
    public String getAcousticName() {
        return this.name;
    }

    @Override
    public void playSound(@Nonnull ISoundPlayer player2, @Nonnull EntityLivingBase location, @Nonnull EventType event, @Nullable IOptions inputOptions) {
        IAcoustic acoustic = this.pairs.get((Object)event);
        if (acoustic != null) {
            acoustic.playSound(player2, location, event, inputOptions);
        } else if (event.canTransition()) {
            this.playSound(player2, location, event.getTransitionDestination(), inputOptions);
        }
    }

    public void setAcousticPair(@Nonnull EventType type, @Nonnull IAcoustic acoustic) {
        this.pairs.put(type, acoustic);
    }

    public String toString() {
        return this.getAcousticName();
    }
}

