/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.implem;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.client.footsteps.implem.AcousticsManager;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.DynSurround.client.footsteps.util.ConfigProperty;

@SideOnly(value=Side.CLIENT)
public class PrimitiveMap {
    private final AcousticsManager acousticsManager;
    private final HashMap<String, IAcoustic[]> primitiveMap = new HashMap();

    public PrimitiveMap(@Nonnull AcousticsManager manager) {
        this.acousticsManager = manager;
    }

    @Nullable
    public IAcoustic[] getPrimitiveMap(@Nonnull String primitive) {
        return this.primitiveMap.get(primitive);
    }

    @Nullable
    public IAcoustic[] getPrimitiveMapSubstrate(@Nonnull String primitive, @Nonnull String substrate) {
        return this.primitiveMap.get(primitive + "@" + substrate);
    }

    public void register(@Nonnull String key, @Nonnull String value) {
        this.primitiveMap.put(key, this.acousticsManager.compileAcoustics(value));
    }

    public void setup(@Nonnull ConfigProperty props) {
        Map<String, String> properties = props.getAllProperties();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            try {
                this.register(entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                DSurround.log().info("Error making registration %s: %s", entry.getKey(), e.getMessage());
            }
        }
    }
}

