/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.system;

import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.footsteps.implem.AcousticsManager;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.lib.MCHelper;
import org.blockartistry.lib.MyUtils;

@SideOnly(value=Side.CLIENT)
public class Association {
    private final IBlockState state;
    private final BlockPos pos;
    private IAcoustic[] data;

    public Association() {
        this(AcousticsManager.EMPTY);
    }

    public Association(@Nonnull IAcoustic[] association) {
        this(null, null, association);
    }

    public Association(@Nonnull IBlockState state, @Nonnull BlockPos pos) {
        this(state, pos, AcousticsManager.EMPTY);
    }

    public Association(@Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull IAcoustic[] association) {
        this.state = state;
        this.pos = pos;
        this.data = association == null ? AcousticsManager.EMPTY : association;
    }

    @Nonnull
    public IAcoustic[] getData() {
        return this.data;
    }

    @Nonnull
    public boolean getNoAssociation() {
        return this.data.length == 0;
    }

    public boolean isLiquid() {
        return this.state != null && this.state.func_185904_a().func_76224_d();
    }

    public SoundType getSoundType() {
        return this.state != null ? MCHelper.getSoundType(this.state) : null;
    }

    public void add(@Nonnull IAcoustic acoustics) {
        this.data = MyUtils.append(this.data, acoustics);
    }

    public void add(@Nonnull IAcoustic[] acoustics) {
        this.data = MyUtils.concatenate(this.data, acoustics);
    }

    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isNotEmitter() {
        return this.data == AcousticsManager.NOT_EMITTER;
    }
}

