/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.system;

import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.footsteps.implem.AcousticsManager;
import org.blockartistry.DynSurround.client.footsteps.implem.BlockMap;
import org.blockartistry.DynSurround.client.footsteps.implem.ConfigOptions;
import org.blockartistry.DynSurround.client.footsteps.implem.Substrate;
import org.blockartistry.DynSurround.client.footsteps.interfaces.EventType;
import org.blockartistry.DynSurround.client.footsteps.interfaces.FootprintStyle;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.DynSurround.client.footsteps.system.Association;
import org.blockartistry.DynSurround.client.footsteps.system.Footprint;
import org.blockartistry.DynSurround.client.footsteps.system.SoundPlayer;
import org.blockartistry.DynSurround.client.footsteps.system.accents.FootstepAccents;
import org.blockartistry.DynSurround.client.fx.ParticleCollections;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.facade.FacadeHelper;
import org.blockartistry.DynSurround.registry.Variator;
import org.blockartistry.lib.MyUtils;
import org.blockartistry.lib.TimeUtils;
import org.blockartistry.lib.WorldUtils;
import org.blockartistry.lib.collections.ObjectArray;
import org.blockartistry.lib.compat.EntityLivingBaseUtil;
import org.blockartistry.lib.compat.EntityUtil;
import org.blockartistry.lib.math.MathStuff;
import org.blockartistry.lib.random.XorShiftRandom;
import org.blockartistry.lib.sound.SoundUtils;

@SideOnly(value=Side.CLIENT)
public class Generator {
    protected static final Random RANDOM = XorShiftRandom.current();
    protected static final IBlockState AIR_STATE = Blocks.field_150350_a.func_176223_P();
    protected static final Consumer<Footprint> GENERATE_PRINT = print -> {
        Vec3d loc = print.getStepLocation();
        World world = print.getEntity().func_130014_f_();
        ParticleCollections.addFootprint(print.getStyle(), world, loc.field_72450_a, loc.field_72448_b, loc.field_72449_c, print.getRotation(), print.getScale(), print.isRightFoot());
    };
    protected final Variator VAR;
    protected final BlockMap blockMap;
    protected float dmwBase;
    protected float dwmYChange;
    protected double yPosition;
    protected boolean didJump;
    protected boolean isFlying;
    protected float fallDistance;
    protected float lastReference;
    protected boolean isImmobile;
    protected long timeImmobile;
    protected boolean isRightFoot;
    protected boolean isOnLadder;
    protected double xMovec;
    protected double zMovec;
    protected boolean scalStat;
    protected boolean stepThisFrame;
    protected boolean isMessyFoliage;
    protected long brushesTime;
    protected double distanceWalkedOnStepModified;
    protected int pedometer;
    protected final ObjectArray<Footprint> footprints = new ObjectArray();
    protected final SoundPlayer soundPlayer;

    public Generator(@Nonnull Variator var) {
        this.VAR = var;
        this.blockMap = ClientRegistry.FOOTSTEPS.getBlockMap();
        this.soundPlayer = new SoundPlayer(this.VAR);
    }

    public int getPedometer() {
        return this.pedometer;
    }

    public void generateFootsteps(@Nonnull EntityLivingBase entity) {
        if (entity.func_184218_aH()) {
            return;
        }
        this.didJump = false;
        this.stepThisFrame = false;
        this.isOnLadder = entity.func_70617_f_();
        this.simulateFootsteps(entity);
        this.simulateAirborne(entity);
        this.simulateBrushes(entity);
        this.soundPlayer.think();
        if (this.footprints.size() > 0) {
            this.footprints.forEach(GENERATE_PRINT);
            this.footprints.clear();
        }
        if (this.stepThisFrame) {
            ++this.pedometer;
        }
        if (this.didJump && ModOptions.sound.enableJumpSound && this.VAR.PLAY_JUMP && !entity.func_70093_af()) {
            this.soundPlayer.playAcoustic(entity, AcousticsManager.JUMP, EventType.JUMP, null);
        }
        if (ModOptions.sound.footstepsSoundFactor > 0.0f) {
            EntityUtil.setNextStepDistance((Entity)entity, Integer.MAX_VALUE);
        } else {
            int dist = EntityUtil.getNextStepDistance((Entity)entity);
            if (dist == Integer.MAX_VALUE) {
                EntityUtil.setNextStepDistance((Entity)entity, 0);
            }
        }
    }

    protected boolean stoppedImmobile(float reference) {
        long current = TimeUtils.currentTimeMillis();
        float diff = this.lastReference - reference;
        this.lastReference = reference;
        if (!this.isImmobile && diff == 0.0f) {
            this.timeImmobile = current;
            this.isImmobile = true;
        } else if (this.isImmobile && diff != 0.0f) {
            this.isImmobile = false;
            return current - this.timeImmobile > (long)this.VAR.IMMOBILE_DURATION;
        }
        return false;
    }

    protected void updateWalkedOnStep(@Nonnull EntityLivingBase entity) {
        double dX = entity.field_70165_t - entity.field_70169_q;
        double dY = entity.field_70163_u - entity.field_70167_r;
        double dZ = entity.field_70161_v - entity.field_70166_s;
        this.distanceWalkedOnStepModified += Math.sqrt(dX * dX + dY * dY + dZ * dZ) * (double)0.6f;
    }

    protected void simulateFootsteps(@Nonnull EntityLivingBase entity) {
        double movZ;
        double movX;
        double scal;
        this.updateWalkedOnStep(entity);
        float distanceReference = (float)this.distanceWalkedOnStepModified;
        if (this.dmwBase > distanceReference) {
            this.dmwBase = 0.0f;
            this.dwmYChange = 0.0f;
        }
        if (this.scalStat != (scal = (movX = entity.field_70159_w) * this.xMovec + (movZ = entity.field_70179_y) * this.zMovec) < (double)0.001f) {
            boolean bl = this.scalStat = !this.scalStat;
            if (this.scalStat && this.VAR.PLAY_WANDER && !this.hasSpecialStoppingConditions(entity)) {
                this.playSinglefoot(entity, 0.0, EventType.WANDER, this.isRightFoot);
            }
        }
        this.xMovec = movX;
        this.zMovec = movZ;
        if (entity.field_70122_E || entity.func_70090_H() || entity.func_70617_f_()) {
            EventType event = null;
            float dwm = distanceReference - this.dmwBase;
            boolean immobile = this.stoppedImmobile(distanceReference);
            if (immobile && !entity.func_70617_f_()) {
                dwm = 0.0f;
                this.dmwBase = distanceReference;
            }
            float distance = 0.0f;
            if (entity.func_70617_f_() && !entity.field_70122_E) {
                distance = this.VAR.STRIDE_LADDER;
            } else if (!entity.func_70090_H() && MathStuff.abs(this.yPosition - entity.field_70163_u) > 0.4) {
                if (this.yPosition < entity.field_70163_u) {
                    distance = this.VAR.STRIDE_STAIR;
                    event = this.speedDisambiguator(entity, EventType.UP, EventType.UP_RUN);
                } else if (!entity.func_70093_af()) {
                    distance = -1.0f;
                    event = this.speedDisambiguator(entity, EventType.DOWN, EventType.DOWN_RUN);
                }
                this.dwmYChange = distanceReference;
            } else {
                distance = this.VAR.STRIDE;
            }
            if (event == null) {
                event = this.speedDisambiguator(entity, EventType.WALK, EventType.RUN);
            }
            if (dwm > (distance = this.reevaluateDistance(event, distance))) {
                this.produceStep(entity, event, 0.0);
                this.stepped(entity, event);
                this.dmwBase = distanceReference;
            }
        }
        if (entity.field_70122_E) {
            this.yPosition = entity.field_70163_u;
        }
    }

    protected void stepped(@Nonnull EntityLivingBase entity, @Nonnull EventType event) {
    }

    protected float reevaluateDistance(@Nonnull EventType event, float distance) {
        return distance;
    }

    protected void produceStep(@Nonnull EntityLivingBase entity, @Nonnull EventType event) {
        this.produceStep(entity, event, 0.0);
    }

    protected void produceStep(@Nonnull EntityLivingBase entity, @Nullable EventType event, double verticalOffsetAsMinus) {
        if (!this.playSpecialStoppingConditions(entity)) {
            if (event == null) {
                event = this.speedDisambiguator(entity, EventType.WALK, EventType.RUN);
            }
            this.playSinglefoot(entity, verticalOffsetAsMinus, event, this.isRightFoot);
            this.isRightFoot = !this.isRightFoot;
        }
        this.stepThisFrame = true;
    }

    protected void simulateAirborne(@Nonnull EntityLivingBase entity) {
        if ((entity.field_70122_E || entity.func_70617_f_()) == this.isFlying) {
            this.isFlying = !this.isFlying;
            this.simulateJumpingLanding(entity);
        }
        if (this.isFlying) {
            this.fallDistance = entity.field_70143_R;
        }
    }

    protected void simulateJumpingLanding(@Nonnull EntityLivingBase entity) {
        if (this.hasSpecialStoppingConditions(entity)) {
            return;
        }
        if (this.isFlying && EntityLivingBaseUtil.isJumping(entity)) {
            if (this.VAR.EVENT_ON_JUMP && entity.field_70181_x > 0.0) {
                this.didJump = true;
                double speed = entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y;
                if (speed < (double)this.VAR.SPEED_TO_JUMP_AS_MULTIFOOT) {
                    this.playMultifoot(entity, 0.4, EventType.JUMP);
                } else {
                    this.playSinglefoot(entity, 0.4, EventType.JUMP, this.isRightFoot);
                }
            }
        } else if (!this.isFlying) {
            if (this.fallDistance > this.VAR.LAND_HARD_DISTANCE_MIN) {
                this.playMultifoot(entity, 0.0, EventType.LAND);
            } else if (!this.stepThisFrame && !entity.func_70093_af()) {
                this.playSinglefoot(entity, 0.0, this.speedDisambiguator(entity, EventType.CLIMB, EventType.CLIMB_RUN), this.isRightFoot);
                this.isRightFoot = !this.isRightFoot;
            }
        }
    }

    protected EventType speedDisambiguator(@Nonnull EntityLivingBase entity, @Nonnull EventType walk, @Nonnull EventType run) {
        double velocity = entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y;
        return velocity > (double)this.VAR.SPEED_TO_RUN ? run : walk;
    }

    protected void simulateBrushes(@Nonnull EntityLivingBase entity) {
        long current = TimeUtils.currentTimeMillis();
        if (this.brushesTime > current) {
            return;
        }
        this.brushesTime = current + 100L;
        if (this.proceedWithStep(entity)) {
            if (entity.field_70159_w == 0.0 && entity.field_70179_y == 0.0) {
                return;
            }
            int yy = MathStuff.floor(entity.field_70163_u - 0.1 - entity.func_70033_W() - (entity.field_70122_E ? 0.0 : 0.25));
            Association assos = this.findAssociationMessyFoliage(entity.func_130014_f_(), new BlockPos(entity.field_70165_t, (double)yy, entity.field_70161_v));
            if (assos != null) {
                if (!this.isMessyFoliage) {
                    this.isMessyFoliage = true;
                    this.playAssociation(entity, assos, EventType.WALK);
                }
            } else {
                this.isMessyFoliage = false;
            }
        }
    }

    protected boolean proceedWithStep(@Nonnull EntityLivingBase entity) {
        return !entity.func_70093_af();
    }

    protected void playSinglefoot(@Nonnull EntityLivingBase entity, double verticalOffsetAsMinus, @Nonnull EventType eventType, boolean foot) {
        if (this.proceedWithStep(entity)) {
            Association assos = this.findAssociationForPlayer(entity, verticalOffsetAsMinus, foot);
            this.playAssociation(entity, assos, eventType);
        }
    }

    protected void playMultifoot(@Nonnull EntityLivingBase entity, double verticalOffsetAsMinus, EventType eventType) {
        if (this.proceedWithStep(entity)) {
            Association leftFoot = this.findAssociationForPlayer(entity, verticalOffsetAsMinus, false);
            Association rightFoot = this.findAssociationForPlayer(entity, verticalOffsetAsMinus, true);
            this.playAssociation(entity, leftFoot, eventType);
            this.playAssociation(entity, rightFoot, eventType);
        }
    }

    protected void playAssociation(@Nonnull EntityLivingBase entity, @Nullable Association assos, @Nonnull EventType eventType) {
        if (assos != null && !assos.isNotEmitter()) {
            this.soundPlayer.playAcoustic(entity, assos, eventType);
        }
    }

    protected boolean hasFootstepImprint(@Nonnull World world, @Nullable IBlockState state, @Nonnull BlockPos pos) {
        if (state != null) {
            IBlockState footstepState = FacadeHelper.resolveState(state, world, pos, EnumFacing.UP);
            return ClientRegistry.FOOTSTEPS.hasFootprint(footstepState);
        }
        return false;
    }

    @Nullable
    protected Vec3d footstepPosition(@Nonnull World world, @Nonnull BlockPos pos, double xx, double zz) {
        IBlockState state = WorldUtils.getBlockState(world, pos);
        if (this.hasFootstepImprint(world, state, pos)) {
            double posY = (double)pos.func_177956_o() + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72337_e;
            return new Vec3d(xx, posY, zz);
        }
        return null;
    }

    protected boolean shouldProducePrint(@Nonnull Entity entity) {
        return ModOptions.player.enableFootprints && this.VAR.HAS_FOOTPRINT && !entity.func_98034_c(EnvironStateHandler.EnvironState.getPlayer());
    }

    @Nonnull
    protected Association findAssociationForPlayer(@Nonnull EntityLivingBase entity, double verticalOffsetAsMinus, boolean isRightFoot) {
        Vec3d printPos;
        float rotDegrees = MathStuff.wrapDegrees(entity.field_70177_z);
        double rot = MathStuff.toRadians(rotDegrees);
        float feetDistanceToCenter = isRightFoot ? -this.VAR.DISTANCE_TO_CENTER : this.VAR.DISTANCE_TO_CENTER;
        double xx = entity.field_70165_t + MathStuff.cos(rot) * (double)feetDistanceToCenter;
        double zz = entity.field_70161_v + MathStuff.sin(rot) * (double)feetDistanceToCenter;
        double minY = entity.func_174813_aQ().field_72338_b;
        BlockPos pos = new BlockPos(xx, minY - 0.1 - verticalOffsetAsMinus, zz);
        Association result = this.findAssociationForLocation(entity, pos);
        if (SoundUtils.canBeHeard(entity, EnvironStateHandler.EnvironState.getPlayerPosition())) {
            result = this.addSoundOverlay(entity, result);
        }
        if (result != null && result.getPos() != null && this.shouldProducePrint((Entity)entity) && (printPos = this.footstepPosition(entity.func_130014_f_(), result.getPos(), xx, zz)) != null) {
            FootprintStyle style = this.VAR.FOOTPRINT_STYLE;
            if (entity instanceof EntityPlayer) {
                style = FootprintStyle.getStyle(ModOptions.player.footprintStyle);
            }
            Footprint print = Footprint.produce(style, entity, printPos, rotDegrees, this.VAR.FOOTPRINT_SCALE, isRightFoot);
            this.footprints.add(print);
        }
        return result;
    }

    @Nonnull
    protected Association findAssociationForLocation(@Nonnull EntityLivingBase entity, @Nonnull BlockPos pos) {
        Association worked;
        World world = entity.func_130014_f_();
        if (entity.func_70090_H()) {
            DSurround.log().debug("WARNING!!! Playing a sound while in the water! This is supposed to be halted by the stopping conditions!!", new Object[0]);
        }
        if ((worked = this.findAssociationForBlock(world, pos)) == null) {
            double xdang = (entity.field_70165_t - (double)pos.func_177958_n()) * 2.0 - 1.0;
            double zdang = (entity.field_70161_v - (double)pos.func_177952_p()) * 2.0 - 1.0;
            if (Math.max(MathStuff.abs(xdang), MathStuff.abs(zdang)) > (double)this.VAR.DISTANCE_TO_CENTER) {
                boolean isXdangMax;
                boolean bl = isXdangMax = MathStuff.abs(xdang) > MathStuff.abs(zdang);
                worked = isXdangMax ? this.findAssociationForBlock(world, xdang > 0.0 ? pos.func_177974_f() : pos.func_177976_e()) : this.findAssociationForBlock(world, zdang > 0.0 ? pos.func_177968_d() : pos.func_177978_c());
                if (worked == null) {
                    worked = isXdangMax ? this.findAssociationForBlock(world, zdang > 0.0 ? pos.func_177968_d() : pos.func_177978_c()) : this.findAssociationForBlock(world, xdang > 0.0 ? pos.func_177974_f() : pos.func_177976_e());
                }
            }
        }
        return worked;
    }

    @Nonnull
    protected Association findAssociationForBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        IBlockState in = WorldUtils.getBlockState(world, pos);
        BlockPos tPos = pos.func_177984_a();
        IBlockState above = WorldUtils.getBlockState(world, tPos);
        IAcoustic[] association = null;
        if (above != AIR_STATE) {
            association = this.blockMap.getBlockSubstrateAcoustics(world, above, tPos, Substrate.CARPET);
        }
        if (association == null || association == AcousticsManager.NOT_EMITTER) {
            IAcoustic[] foliage;
            IBlockState below;
            if (in == AIR_STATE && (association = this.blockMap.getBlockSubstrateAcoustics(world, below = WorldUtils.getBlockState(world, tPos = pos.func_177977_b()), tPos, Substrate.FENCE)) != null) {
                pos = tPos;
                in = below;
            }
            if (association == null) {
                association = this.blockMap.getBlockAcoustics(world, in, pos);
            }
            if (association != null && association != AcousticsManager.NOT_EMITTER && above != AIR_STATE && (foliage = this.blockMap.getBlockSubstrateAcoustics(world, above, pos.func_177984_a(), Substrate.FOLIAGE)) != null && foliage != AcousticsManager.NOT_EMITTER) {
                association = MyUtils.concatenate(association, foliage);
            }
        } else {
            pos = tPos;
            in = above;
        }
        if (association != null) {
            if (association == AcousticsManager.NOT_EMITTER) {
                return null;
            }
            return new Association(in, pos, association);
        }
        return new Association(in, pos);
    }

    protected boolean playSpecialStoppingConditions(@Nonnull EntityLivingBase entity) {
        if (entity.func_70090_H()) {
            if (this.proceedWithStep(entity)) {
                float volume = (float)MathStuff.sqrt(entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y) * 1.25f;
                ConfigOptions options = new ConfigOptions();
                options.setGlidingVolume(volume > 1.0f ? 1.0f : volume);
                this.soundPlayer.playAcoustic(entity, AcousticsManager.SWIM, entity.func_70055_a(Material.field_151586_h) ? EventType.SWIM : EventType.WALK, options);
            }
            return true;
        }
        return false;
    }

    protected boolean hasSpecialStoppingConditions(@Nonnull EntityLivingBase entity) {
        return entity.func_70090_H();
    }

    @Nonnull
    protected Association findAssociationMessyFoliage(@Nonnull World world, @Nonnull BlockPos pos) {
        BlockPos up = pos.func_177984_a();
        IBlockState above = WorldUtils.getBlockState(world, up);
        if (above == AIR_STATE) {
            return null;
        }
        IAcoustic[] association = null;
        boolean found = false;
        IAcoustic[] foliage = this.blockMap.getBlockSubstrateAcoustics(world, above, up, Substrate.FOLIAGE);
        if (foliage != null && foliage != AcousticsManager.NOT_EMITTER) {
            association = foliage;
            IAcoustic[] isMessy = this.blockMap.getBlockSubstrateAcoustics(world, above, up, Substrate.MESSY);
            if (isMessy != null && isMessy == AcousticsManager.MESSY_GROUND) {
                found = true;
            }
        }
        if (found && association != null) {
            return association == AcousticsManager.NOT_EMITTER ? null : new Association(association);
        }
        return null;
    }

    @Nullable
    protected Association addSoundOverlay(@Nonnull EntityLivingBase entity, @Nullable Association assoc) {
        if (entity.field_70122_E) {
            ObjectArray<IAcoustic> accents = new ObjectArray<IAcoustic>();
            BlockPos pos = assoc != null ? assoc.getPos() : null;
            FootstepAccents.provide(entity, pos, accents);
            if (accents.size() > 0) {
                Association a = assoc == null ? new Association() : assoc;
                accents.forEvery(acoustic -> a.add((IAcoustic)acoustic));
                return a;
            }
        }
        return assoc;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("didJump: ").append(Boolean.toString(this.didJump)).append(' ');
        builder.append("isOnLadder: ").append(Boolean.toString(this.isOnLadder)).append(' ');
        builder.append("isFlying: ").append(Boolean.toString(this.isFlying)).append(' ');
        builder.append("isImmobile: ").append(Boolean.toString(this.isImmobile)).append(' ');
        builder.append("isMessy: ").append(Boolean.toString(this.isMessyFoliage));
        return builder.toString();
    }
}

