/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.system.accents;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.footsteps.implem.AcousticsManager;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IFootstepAccentProvider;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.weather.Weather;
import org.blockartistry.DynSurround.registry.BiomeInfo;
import org.blockartistry.lib.WorldUtils;
import org.blockartistry.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public class RainSplashAccent
implements IFootstepAccentProvider {
    @Override
    @Nonnull
    public String getName() {
        return "Rain Splash Accent";
    }

    @Override
    @Nonnull
    public ObjectArray<IAcoustic> provide(@Nonnull EntityLivingBase entity, @Nullable BlockPos blockPos, @Nonnull ObjectArray<IAcoustic> in) {
        if (ModOptions.sound.enablePuddleSound && Weather.isRaining() && EnvironStateHandler.EnvironState.isPlayer((Entity)entity)) {
            BiomeInfo biome;
            BlockPos.MutableBlockPos pos;
            if (blockPos != null) {
                pos = new BlockPos.MutableBlockPos(blockPos);
                pos.func_189536_c(EnumFacing.UP);
            } else {
                pos = new BlockPos.MutableBlockPos();
                pos.func_189535_a((Entity)entity);
            }
            int precipHeight = ClientRegistry.SEASON.getPrecipitationHeight(entity.func_130014_f_(), (BlockPos)pos).func_177956_o();
            if (precipHeight == pos.func_177956_o() && (biome = ClientRegistry.BIOME.get(WorldUtils.getBiome(entity.func_130014_f_(), (BlockPos)pos))).hasWeatherEffect() && !biome.getHasDust()) {
                pos.func_181079_c(pos.func_177958_n(), precipHeight, pos.func_177952_p());
                boolean canSnow = ClientRegistry.SEASON.canWaterFreeze(entity.func_130014_f_(), (BlockPos)pos);
                if (!canSnow) {
                    in.addAll((IAcoustic[])AcousticsManager.SPLASH);
                }
            }
        }
        return in;
    }
}

