/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.footsteps.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.client.footsteps.util.PropertyMissingException;
import org.blockartistry.DynSurround.client.footsteps.util.PropertyTypeException;
import org.blockartistry.lib.JsonUtils;

@SideOnly(value=Side.CLIENT)
public class ConfigProperty {
    private Map<String, String> properties = new HashMap<String, String>();

    public String getString(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        return this.properties.get(name);
    }

    public boolean getBoolean(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Boolean.parseBoolean(this.properties.get(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException();
        }
    }

    public int getInteger(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Integer.parseInt(this.properties.get(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException();
        }
    }

    public float getFloat(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Float.parseFloat(this.properties.get(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException();
        }
    }

    public long getLong(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Long.parseLong(this.properties.get(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException();
        }
    }

    public double getDouble(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Double.parseDouble(this.properties.get(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException();
        }
    }

    public void setProperty(String name, Object o) {
        this.properties.put(name, o.toString());
    }

    public Map<String, String> getAllProperties() {
        return this.properties;
    }

    public static ConfigProperty fromStream(InputStream stream) {
        ConfigProperty props = new ConfigProperty();
        ConfigProperty.loadStream(props, stream);
        return props;
    }

    public static boolean loadStream(ConfigProperty properties, InputStream stream) {
        if (stream == null) {
            return false;
        }
        try {
            properties.properties = (Map)JsonUtils.load(stream, properties.properties.getClass());
        }
        catch (Throwable t) {
            DSurround.log().error("Unable to load properties", t);
        }
        return true;
    }
}

