/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.fx.particle.ParticleAsset;
import org.blockartistry.DynSurround.client.fx.particle.ParticleBlock;
import org.blockartistry.DynSurround.client.fx.particle.ParticleEntity;
import org.blockartistry.DynSurround.client.fx.particle.ParticleItemStack;
import org.blockartistry.lib.gfx.ParticleHelper;
import org.blockartistry.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public final class ExplosionHelper {
    private static final Assets OVERWORLD = new Assets().setBlocks(new Block[]{Blocks.field_150346_d, Blocks.field_150347_e, Blocks.field_150351_n, Blocks.field_150354_m, Blocks.field_150345_g}).setStacks(new ItemStack(Items.field_151145_ak), new ItemStack(Items.field_151118_aC), new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151055_y), new ItemStack(Items.field_151044_h)).setMobs("Pig", "Sheep", "Chicken", "Cow", "Villager", "Wolf", "Ozelot");
    private static final Assets NETHER = new Assets().setBlocks(Blocks.field_150424_aL, Blocks.field_150425_aM, Blocks.field_150351_n, Blocks.field_189877_df).setStacks(new ItemStack(Items.field_151075_bm), new ItemStack(Items.field_151114_aO), new ItemStack(Items.field_151074_bl), new ItemStack(Items.field_151072_bj)).setMobs("LavaSlime", "PigZombie", "Blaze");
    private static final Assets END = new Assets().setBlocks(Blocks.field_150377_bs, Blocks.field_150343_Z).setStacks(new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151079_bi)).setMobs("Enderman", "Endermite");

    private ExplosionHelper() {
    }

    private static Assets getAssets(@Nonnull World world) {
        switch (world.field_73011_w.func_186058_p()) {
            case NETHER: {
                return NETHER;
            }
            case THE_END: {
                return END;
            }
        }
        return OVERWORLD;
    }

    private static ParticleAsset getParticle(@Nonnull World world, double x, double y, double z) {
        Random rand = XorShiftRandom.current();
        Assets assets = ExplosionHelper.getAssets(world);
        float motionX = rand.nextFloat() * 10.0f - 5.0f;
        float motionZ = rand.nextFloat() * 10.0f - 5.0f;
        float motionY = rand.nextFloat() * 6.0f + 6.0f;
        int choice = rand.nextInt(20);
        if (choice < 3 && ModOptions.explosions.addMobParticles) {
            String mob = assets.getMob(rand);
            if (StringUtils.isEmpty((CharSequence)mob)) {
                return null;
            }
            ParticleEntity pe = new ParticleEntity(mob, world, x, y, z, motionX, motionY, motionZ);
            pe.setScale(1.0f);
            pe.func_187114_a(75);
            pe.setPitchRate(18.0f + rand.nextFloat() * 18.0f);
            pe.setYawRate(18.0f + rand.nextFloat() * 18.0f);
            pe.setGravity(0.25f);
            return pe;
        }
        if (choice < 8) {
            ItemStack stack = assets.getStack(rand);
            if (stack == null) {
                return null;
            }
            ParticleItemStack s = new ParticleItemStack(stack, world, x, y, z, motionX, motionY, motionZ);
            s.setScale(0.5f);
            s.func_187114_a(75);
            s.setPitchRate(18.0f + rand.nextFloat() * 18.0f);
            s.setYawRate(18.0f + rand.nextFloat() * 18.0f);
            s.setGravity(0.25f);
            return s;
        }
        Block block2 = assets.getBlock(rand);
        if (block2 == null) {
            return null;
        }
        ParticleBlock p = new ParticleBlock(block2, world, x, y, z, motionX, motionY, motionZ);
        p.setScale(0.05f + 0.1f * rand.nextFloat());
        p.func_187114_a(75);
        p.setPitchRate(18.0f + rand.nextFloat() * 18.0f);
        p.setYawRate(18.0f + rand.nextFloat() * 18.0f);
        p.setGravity(0.25f);
        return p;
    }

    public static void doExplosion(@Nonnull World world, double x, double y, double z) {
        for (int i = 0; i < 4; ++i) {
            ParticleAsset particle = ExplosionHelper.getParticle(world, x, y, z);
            if (particle == null) continue;
            ParticleHelper.addParticle(particle);
        }
    }

    private static class Assets {
        public Block[] blocks;
        public ItemStack[] stacks;
        public String[] mobs;

        private Assets() {
        }

        public Assets setBlocks(Block ... b) {
            this.blocks = b;
            return this;
        }

        public Assets setStacks(ItemStack ... s) {
            this.stacks = s;
            return this;
        }

        public Assets setMobs(String ... m) {
            this.mobs = m;
            return this;
        }

        public Block getBlock(Random rand) {
            return this.blocks != null && this.blocks.length > 0 ? this.blocks[rand.nextInt(this.blocks.length)] : null;
        }

        public ItemStack getStack(Random rand) {
            return this.stacks != null && this.stacks.length > 0 ? this.stacks[rand.nextInt(this.stacks.length)] : null;
        }

        public String getMob(Random rand) {
            return this.mobs != null && this.mobs.length > 0 ? this.mobs[rand.nextInt(this.mobs.length)] : null;
        }
    }
}

