/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle;

import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDrip;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.fx.ParticleCollections;
import org.blockartistry.DynSurround.client.fx.particle.ParticleSteamCloud;
import org.blockartistry.DynSurround.client.handlers.SoundEffectHandler;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.client.sound.Sounds;
import org.blockartistry.lib.WorldUtils;
import org.blockartistry.lib.gfx.ParticleHelper;

@SideOnly(value=Side.CLIENT)
public class ParticleDripOverride
extends ParticleDrip {
    private boolean firstTime = true;
    private final Material materialType;

    protected ParticleDripOverride(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, Material materialType) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, materialType);
        this.materialType = materialType;
    }

    private boolean doSteamHiss(@Nonnull IBlockState state) {
        Material blockMaterial = state.func_185904_a();
        if (this.materialType == Material.field_151587_i && blockMaterial == Material.field_151586_h) {
            return true;
        }
        return this.materialType == Material.field_151586_h && blockMaterial == Material.field_151587_i;
    }

    public void func_189213_a() {
        BlockPos pos;
        super.func_189213_a();
        if (this.func_187113_k()) {
            if (this.field_187127_g < 1.0) {
                this.func_187112_i();
            } else if (this.firstTime) {
                this.firstTime = false;
                pos = new BlockPos.MutableBlockPos();
                pos.func_189532_c(this.field_187126_f, this.field_187127_g, this.field_187128_h);
                if (!WorldUtils.isAirBlock(this.field_187122_b, pos)) {
                    this.func_187112_i();
                } else {
                    pos.func_189532_c(this.field_187126_f, this.field_187127_g + 0.3, this.field_187128_h);
                    int y = pos.func_177956_o();
                    IBlockState state = this.field_187122_b.func_180495_p(pos);
                    if (!WorldUtils.isAirBlock(state) && !WorldUtils.isLeaves(state)) {
                        do {
                            pos.func_189534_c(EnumFacing.DOWN, 1);
                            state = this.field_187122_b.func_180495_p(pos);
                        } while (pos.func_177956_o() > 0 && WorldUtils.isAirBlock(state));
                        if (pos.func_177956_o() < 1) {
                            return;
                        }
                        int delay = 40 + (y - pos.func_177956_o()) * 2;
                        pos.func_189534_c(EnumFacing.UP, 1);
                        SoundEffect effect = state.func_185904_a().func_76220_a() ? Sounds.WATER_DROP : (this.doSteamHiss(state) ? Sounds.STEAM_HISS : (this.materialType == Material.field_151586_h ? Sounds.WATER_DRIP : Sounds.WATER_DROP));
                        SoundEffectHandler.INSTANCE.playSoundAt(pos, effect, delay);
                    }
                }
            }
        }
        if (WorldUtils.isFullWaterBlock(this.field_187122_b, pos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h)) && ParticleCollections.addWaterRipple(this.field_187122_b, this.field_187126_f, pos.func_177956_o() + 1, this.field_187128_h) != null && this.materialType == Material.field_151587_i) {
            ParticleHelper.addParticle((Particle)new ParticleSteamCloud(this.field_187122_b, this.field_187126_f, pos.func_177956_o() + 1, this.field_187128_h, 0.01));
        }
    }

    public static void register() {
        Minecraft.func_71410_x().field_71452_i.func_178929_a(EnumParticleTypes.DRIP_WATER.func_179348_c(), (IParticleFactory)new WaterFactory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(EnumParticleTypes.DRIP_LAVA.func_179348_c(), (IParticleFactory)new LavaFactory());
    }

    public static class WaterFactory
    implements IParticleFactory {
        public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
            return new ParticleDripOverride(worldIn, xCoordIn, yCoordIn, zCoordIn, Material.field_151586_h);
        }
    }

    public static class LavaFactory
    implements IParticleFactory {
        public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
            return new ParticleDripOverride(worldIn, xCoordIn, yCoordIn, zCoordIn, Material.field_151587_i);
        }
    }
}

