/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle.mote;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.api.entity.EmojiType;
import org.blockartistry.DynSurround.api.entity.EntityCapability;
import org.blockartistry.DynSurround.api.entity.IEmojiData;
import org.blockartistry.DynSurround.client.fx.particle.mote.MoteMotionBase;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class MoteEmoji
extends MoteMotionBase {
    private static final float ORBITAL_PERIOD = 2.0f;
    private static final float ORBITAL_TICK = 9.0f;
    private static final int HOLD_TICK_COUNT = 40;
    private final WeakReference<Entity> subject;
    private final IEmojiData emoji;
    private boolean shouldRender;
    private int holdTicks;
    private float period;
    private float radius;
    protected float scale;
    protected float texU1;
    protected float texU2;
    protected float texV1;
    protected float texV2;

    public MoteEmoji(@Nonnull Entity entity) {
        super(entity.func_130014_f_(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        double newY = entity.field_70163_u + (double)entity.field_70131_O - (entity.func_70093_af() ? 0.25 : 0.0);
        this.prevX = this.posX = entity.field_70165_t;
        this.prevY = this.posY = newY;
        this.prevZ = this.posZ = entity.field_70161_v;
        this.position.func_189532_c(this.posX, this.posY, this.posZ);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.gravity = 0.0;
        this.subject = new WeakReference<Entity>(entity);
        this.scale = 1.0f;
        this.alpha = 0.99f;
        this.radius = entity.field_70130_N / 2.0f + 0.25f;
        this.period = RANDOM.nextFloat() * 360.0f;
        this.maxAge = Integer.MAX_VALUE;
        this.scale = 0.125f;
        this.emoji = (IEmojiData)entity.getCapability(EntityCapability.EMOJI, null);
    }

    protected boolean shouldExpire() {
        if (!this.isAlive() || this.subject.isEnqueued()) {
            return true;
        }
        Entity entity = (Entity)this.subject.get();
        return !entity.func_70089_S() || entity.func_98034_c(EnvironStateHandler.EnvironState.getPlayer());
    }

    protected boolean shouldRender() {
        if (!this.isAlive) {
            return false;
        }
        EntityPlayer player2 = EnvironStateHandler.EnvironState.getPlayer();
        double distSq = ModOptions.speechbubbles.speechBubbleRange * ModOptions.speechbubbles.speechBubbleRange;
        return player2.func_70092_e(this.posX, this.posY, this.posZ) <= distSq;
    }

    @Override
    public void update() {
        if (this.shouldExpire()) {
            this.isAlive = false;
            return;
        }
        this.prevX = this.posX;
        this.prevY = this.posY;
        this.prevZ = this.posZ;
        Entity entity = (Entity)this.subject.get();
        this.posX = entity.field_70165_t;
        this.posY = entity.field_70163_u + (double)entity.field_70131_O - (entity.func_70093_af() ? 0.25 : 0.0);
        this.posZ = entity.field_70161_v;
        this.position.func_189532_c(this.posX, this.posY, this.posZ);
        this.period = MathStuff.wrapDegrees(this.period + 9.0f);
        if (this.emoji.getEmojiType() == EmojiType.NONE) {
            ++this.holdTicks;
            if (this.holdTicks >= 40) {
                this.isAlive = false;
            }
            return;
        }
        int textureIdx = this.emoji.getEmojiType().ordinal() - 1;
        int texX = textureIdx % 4;
        int texY = textureIdx / 4;
        this.texU1 = (float)texX * 0.25f;
        this.texU2 = this.texU1 + 0.25f;
        this.texV1 = (float)texY * 0.25f;
        this.texV2 = this.texV1 + 0.25f;
        this.holdTicks = 0;
        this.shouldRender = this.shouldRender();
    }

    @Override
    public void renderParticle(VertexBuffer buffer, Entity entityIn, float partialTicks, float edgeLRdirectionX, float edgeUDdirectionY, float edgeLRdirectionZ, float edgeUDdirectionX, float edgeUDdirectionZ) {
        if (!this.shouldRender) {
            return;
        }
        float x = this.renderX(partialTicks);
        float y = this.renderY(partialTicks);
        float z = this.renderZ(partialTicks);
        float degrees = MathStuff.wrapDegrees(this.period + 9.0f * partialTicks);
        float cosine = MathStuff.cos(MathStuff.toRadians(degrees));
        float sine = MathStuff.sin(MathStuff.toRadians(degrees));
        x = cosine * this.radius + x;
        z = sine * this.radius + z;
        y = cosine * 0.25f + y;
        this.drawVertex(buffer, x - edgeLRdirectionX * this.scale - edgeUDdirectionX * this.scale, y - edgeUDdirectionY * this.scale, z - edgeLRdirectionZ * this.scale - edgeUDdirectionZ * this.scale, this.texU2, this.texV2);
        this.drawVertex(buffer, x - edgeLRdirectionX * this.scale + edgeUDdirectionX * this.scale, y + edgeUDdirectionY * this.scale, z - edgeLRdirectionZ * this.scale + edgeUDdirectionZ * this.scale, this.texU2, this.texV1);
        this.drawVertex(buffer, x + edgeLRdirectionX * this.scale + edgeUDdirectionX * this.scale, y + edgeUDdirectionY * this.scale, z + edgeLRdirectionZ * this.scale + edgeUDdirectionZ * this.scale, this.texU1, this.texV1);
        this.drawVertex(buffer, x + edgeLRdirectionX * this.scale - edgeUDdirectionX * this.scale, y - edgeUDdirectionY * this.scale, z + edgeLRdirectionZ * this.scale - edgeUDdirectionZ * this.scale, this.texU1, this.texV2);
    }
}

