/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle.mote;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.fx.particle.mote.IParticleMote;
import org.blockartistry.lib.WorldUtils;
import org.blockartistry.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public abstract class MoteParticle
implements IParticleMote {
    protected static final Random RANDOM = XorShiftRandom.current();
    protected static final RenderManager RENDERER = Minecraft.func_71410_x().func_175598_ae();
    protected final World world;
    protected boolean isAlive = true;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected final BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos();
    protected int slX16;
    protected int blX16;
    protected float red;
    protected float green;
    protected float blue;
    protected float alpha;

    public MoteParticle(@Nonnull World world, double x, double y, double z) {
        this.world = world;
        this.setPosition(x, y, z);
        this.configureColor();
    }

    public void setPosition(double posX, double posY, double posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.position.func_189532_c(posX, posY, posZ);
    }

    public void configureColor() {
        this.alpha = 1.0f;
        this.blue = 1.0f;
        this.green = 1.0f;
        this.red = 1.0f;
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    protected void kill() {
        this.isAlive = false;
    }

    @Override
    public void onUpdate() {
        if (!WorldUtils.isChunkAvailable(this.world, (BlockPos)this.position)) {
            this.kill();
        }
        if (!this.isAlive()) {
            return;
        }
        this.update();
        if (this.isAlive()) {
            this.updateBrightness();
        }
    }

    protected void update() {
    }

    public void updateBrightness() {
        int combinedLight = this.getBrightnessForRender(0.0f);
        this.slX16 = combinedLight >> 16 & 0xFFFF;
        this.blX16 = combinedLight & 0xFFFF;
    }

    protected final double interpX() {
        return MoteParticle.RENDERER.field_78730_l;
    }

    protected final double interpY() {
        return MoteParticle.RENDERER.field_78731_m;
    }

    protected final double interpZ() {
        return MoteParticle.RENDERER.field_78728_n;
    }

    protected float renderX(float partialTicks) {
        return (float)(this.posX - this.interpX());
    }

    protected float renderY(float partialTicks) {
        return (float)(this.posY - this.interpY());
    }

    protected float renderZ(float partialTicks) {
        return (float)(this.posZ - this.interpZ());
    }

    protected void applyColor(@Nonnull VertexBuffer buffer) {
        buffer.func_181666_a(this.red, this.green, this.blue, this.alpha);
    }

    protected void applyLightmap(@Nonnull VertexBuffer buffer) {
        buffer.func_187314_a(this.slX16, this.blX16);
    }

    protected void drawVertex(VertexBuffer buffer, double x, double y, double z, double u, double v) {
        buffer.func_181662_b(x, y, z).func_187315_a(u, v);
        this.applyColor(buffer);
        this.applyLightmap(buffer);
        buffer.func_181675_d();
    }

    @Override
    public abstract void renderParticle(VertexBuffer var1, Entity var2, float var3, float var4, float var5, float var6, float var7, float var8);

    public int getBrightnessForRender(float partialTicks) {
        return this.world.func_175626_b((BlockPos)this.position, 0);
    }
}

