/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle.mote;

import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.fx.particle.mote.MoteAgeable;
import org.blockartistry.lib.BiomeUtils;
import org.blockartistry.lib.Color;

@SideOnly(value=Side.CLIENT)
public class MoteWaterRipple
extends MoteAgeable {
    private static final float TEX_SIZE_HALF = 0.5f;
    protected final float growthRate;
    protected float scale;
    protected float scaledWidth;

    public MoteWaterRipple(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.maxAge = 12 + RANDOM.nextInt(8);
        this.scale = this.growthRate = (float)this.maxAge / 500.0f;
        this.scaledWidth = this.scale * 0.5f;
        this.posY -= 0.2;
        Color waterColor = BiomeUtils.getColorForLiquid(world, (BlockPos)this.position);
        this.red = waterColor.red;
        this.green = waterColor.green;
        this.blue = waterColor.blue;
    }

    @Override
    public void update() {
        this.scale += this.growthRate;
        this.scaledWidth = this.scale * 0.5f;
        this.alpha = (float)(this.maxAge - this.age) / (float)(this.maxAge + 3);
    }

    @Override
    public void renderParticle(VertexBuffer buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float x = this.renderX(partialTicks);
        float y = this.renderY(partialTicks);
        float z = this.renderZ(partialTicks);
        this.drawVertex(buffer, -this.scaledWidth + x, y, this.scaledWidth + z, 0.0, 1.0);
        this.drawVertex(buffer, this.scaledWidth + x, y, this.scaledWidth + z, 1.0, 1.0);
        this.drawVertex(buffer, this.scaledWidth + x, y, -this.scaledWidth + z, 1.0, 0.0);
        this.drawVertex(buffer, -this.scaledWidth + x, y, -this.scaledWidth + z, 0.0, 0.0);
    }
}

