/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle.mote;

import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.fx.particle.mote.MoteMotionBase;
import org.blockartistry.lib.BiomeUtils;
import org.blockartistry.lib.Color;

@SideOnly(value=Side.CLIENT)
public class MoteWaterSpray
extends MoteMotionBase {
    protected float scale;
    protected final float texU1;
    protected final float texU2;
    protected final float texV1;
    protected final float texV2;
    protected final float f4;

    public MoteWaterSpray(World world, double x, double y, double z, double dX, double dY, double dZ) {
        super(world, x, y, z, dX, dY, dZ);
        this.maxAge = (int)(8.0 / (RANDOM.nextDouble() * 0.8 + 0.2));
        this.scale = (RANDOM.nextFloat() * 0.5f + 0.5f) * 2.0f;
        int textureIdx = RANDOM.nextInt(4);
        int texX = textureIdx % 2;
        int texY = textureIdx / 2;
        this.texU1 = (float)texX * 0.5f;
        this.texU2 = this.texU1 + 0.5f;
        this.texV1 = (float)texY * 0.5f;
        this.texV2 = this.texV1 + 0.5f;
        this.f4 = 0.07f * this.scale;
    }

    @Override
    public void configureColor() {
        Color waterColor = BiomeUtils.getColorForLiquid(this.world, (BlockPos)this.position);
        this.red = waterColor.red;
        this.green = waterColor.green;
        this.blue = waterColor.blue;
        this.alpha = 1.0f;
    }

    @Override
    public void renderParticle(VertexBuffer buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float x = this.renderX(partialTicks);
        float y = this.renderY(partialTicks);
        float z = this.renderZ(partialTicks);
        this.drawVertex(buffer, x + (-rotationX * this.f4 - rotationXY * this.f4), y + -rotationZ * this.f4, z + (-rotationYZ * this.f4 - rotationXZ * this.f4), this.texU2, this.texV2);
        this.drawVertex(buffer, x + (-rotationX * this.f4 + rotationXY * this.f4), y + rotationZ * this.f4, z + (-rotationYZ * this.f4 + rotationXZ * this.f4), this.texU2, this.texV1);
        this.drawVertex(buffer, x + (rotationX * this.f4 + rotationXY * this.f4), y + rotationZ * this.f4, z + (rotationYZ * this.f4 + rotationXZ * this.f4), this.texU1, this.texV1);
        this.drawVertex(buffer, x + (rotationX * this.f4 - rotationXY * this.f4), y + -rotationZ * this.f4, z + (rotationYZ * this.f4 - rotationXZ * this.f4), this.texU1, this.texV2);
    }
}

