/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle.mote;

import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.fx.particle.mote.ParticleCollection;
import org.blockartistry.lib.gfx.OpenGlUtil;

@SideOnly(value=Side.CLIENT)
public class ParticleCollectionRipples
extends ParticleCollection {
    public static final ParticleCollection.ICollectionFactory FACTORY = (world, texture) -> new ParticleCollectionRipples(world, texture);

    public ParticleCollectionRipples(@Nonnull World world, @Nonnull ResourceLocation tex) {
        super(world, tex);
    }

    @Override
    protected void bindTexture(@Nonnull ResourceLocation resource) {
        ResourceLocation res = Style.getStyle(ModOptions.rain.rainRippleStyle).getTexture();
        super.bindTexture(res);
    }

    @Override
    protected void preRender() {
        super.preRender();
        GlStateManager.func_179126_j();
        OpenGlUtil.setStandardBlend();
        GlStateManager.func_179132_a((boolean)false);
    }

    public static enum Style {
        ORIGINAL("textures/particles/ripple.png"),
        CIRCLE("textures/particles/ripple1.png"),
        SQUARE("textures/particles/ripple2.png");

        private final ResourceLocation resource;

        private Style(String texture) {
            this.resource = new ResourceLocation("dsurround", texture);
        }

        @Nonnull
        public ResourceLocation getTexture() {
            return this.resource;
        }

        @Nonnull
        public static Style getStyle(int v) {
            if (v >= Style.values().length) {
                return CIRCLE;
            }
            return Style.values()[v];
        }
    }
}

