/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle.system;

import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.fx.particle.system.ParticleSystem;

@SideOnly(value=Side.CLIENT)
public abstract class ParticleJet
extends ParticleSystem {
    private static final int MAX_STRENGTH_FOR_COUNT = 7;
    protected final int jetStrength;
    protected final int updateFrequency;
    protected final int particleMaxAge;
    protected int particleAge;

    public ParticleJet(int strength, World world, double x, double y, double z) {
        this(0, strength, world, x, y, z, 3);
    }

    public ParticleJet(int layer, int strength, World world, double x, double y, double z, int freq) {
        super(world, x, y, z);
        this.jetStrength = strength;
        this.updateFrequency = freq;
        this.particleMaxAge = (RANDOM.nextInt(strength) + 2) * 20;
        int str = Math.min(strength, 7);
        this.setParticleLimit(str * str * 5);
    }

    protected abstract void spawnJetParticle();

    @Override
    public boolean shouldDie() {
        return this.particleAge >= this.particleMaxAge;
    }

    @Override
    public void think() {
        if (this.particleAge % this.updateFrequency == 0) {
            this.spawnJetParticle();
        }
        ++this.particleAge;
    }
}

