/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.fx.particle.system;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.fx.particle.ParticleMoteAdapter;
import org.blockartistry.DynSurround.client.fx.particle.mote.IParticleMote;
import org.blockartistry.lib.collections.ObjectArray;
import org.blockartistry.lib.gfx.ParticleHelper;
import org.blockartistry.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public abstract class ParticleSystem {
    protected static final Random RANDOM = XorShiftRandom.current();
    protected static final GameSettings SETTINGS = Minecraft.func_71410_x().field_71474_y;
    protected static final int ALLOCATION_SIZE = 8;
    protected final World world;
    protected final double posX;
    protected final double posY;
    protected final double posZ;
    protected final BlockPos position;
    protected ObjectArray<IParticleMote> myParticles = new ObjectArray(8);
    protected int particleLimit;
    private boolean isAlive = true;

    protected ParticleSystem(World worldIn, double posXIn, double posYIn, double posZIn) {
        this.world = worldIn;
        this.posX = posXIn;
        this.posY = posYIn;
        this.posZ = posZIn;
        this.position = new BlockPos(posXIn, posYIn, posZIn);
        this.setParticleLimit(6);
    }

    @Nonnull
    public BlockPos getPos() {
        return this.position;
    }

    public void setParticleLimit(int limit) {
        this.particleLimit = limit;
    }

    public int getCurrentParticleCount() {
        return this.myParticles.size();
    }

    public int getParticleLimit() {
        switch (ParticleSystem.SETTINGS.field_74362_aa) {
            case 2: {
                return 0;
            }
            case 0: {
                return this.particleLimit;
            }
        }
        return this.particleLimit / 2;
    }

    public boolean hasSpace() {
        return this.getCurrentParticleCount() < this.getParticleLimit();
    }

    public void addParticle(@Nonnull Particle particle) {
        if (this.hasSpace()) {
            this.myParticles.add(new ParticleMoteAdapter(particle));
            ParticleHelper.addParticle(particle);
        }
    }

    public void addParticle(@Nonnull IParticleMote particle) {
        if (this.hasSpace()) {
            this.myParticles.add(particle);
        }
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void setExpired() {
        this.isAlive = false;
        this.cleanUp();
    }

    public boolean shouldDie() {
        return false;
    }

    protected void cleanUp() {
        this.myParticles = null;
    }

    public void onUpdate() {
        if (this.shouldDie()) {
            this.setExpired();
            return;
        }
        this.think();
        if (this.isAlive()) {
            this.myParticles.removeIf(IParticleMote.IS_DEAD);
            this.soundUpdate();
        }
    }

    protected void soundUpdate() {
    }

    public abstract void think();
}

