/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.gui.CheckBoxButton;
import org.blockartistry.DynSurround.client.gui.GuiConstants;
import org.blockartistry.DynSurround.client.gui.PlaySoundButton;
import org.blockartistry.DynSurround.registry.SoundMetadata;
import org.blockartistry.lib.ForgeUtils;

@SideOnly(value=Side.CLIENT)
public class SoundConfigEntry
extends GuiConfigEntries.NumberSliderEntry {
    private static final int ID_CULLED = 10000;
    private static final int ID_BLOCKED = 10001;
    private static final int ID_PLAY = 10002;
    private final CheckBoxButton cull;
    private final CheckBoxButton block;
    private final PlaySoundButton play;
    private final HoverChecker cullHover;
    private final HoverChecker blockHover;
    private final HoverChecker playHover;
    private final HoverChecker sliderHover;
    private final IConfigElement realConfig;

    public SoundConfigEntry(@Nonnull GuiConfig owningScreen, @Nonnull GuiConfigEntries owningEntryList, @Nonnull IConfigElement configElement) {
        super(owningScreen, owningEntryList, (IConfigElement)new ConfigElementSliderAdapter(configElement));
        String soundName = configElement.getName();
        String parms = (String)configElement.get();
        boolean culled = parms.contains("cull");
        boolean blocked = parms.contains("block");
        this.cull = new CheckBoxButton(10000, GuiConstants.TEXT_CULL, culled, false);
        this.block = new CheckBoxButton(10001, GuiConstants.TEXT_BLOCK, blocked, false);
        this.play = new PlaySoundButton(10002, soundName);
        this.cullHover = new HoverChecker((GuiButton)this.cull, 800);
        this.blockHover = new HoverChecker((GuiButton)this.block, 800);
        this.playHover = new HoverChecker((GuiButton)this.play, 800);
        this.sliderHover = new HoverChecker(null, 800);
        ArrayList text = Lists.newArrayList();
        ResourceLocation soundResource = new ResourceLocation(soundName);
        text.add(TextFormatting.GREEN + ForgeUtils.getModName(soundResource));
        text.add(TextFormatting.GOLD + soundName);
        SoundMetadata data = ClientRegistry.SOUND.getSoundMetadata(soundResource);
        if (data != null) {
            List<String> credits;
            boolean spaceAdded = false;
            String title = data.getTitle();
            if (!StringUtils.isEmpty((CharSequence)title)) {
                spaceAdded = true;
                text.add("");
                text.add(TextFormatting.YELLOW + title);
            }
            if ((credits = data.getCredits()) != null && credits.size() > 0) {
                if (!spaceAdded) {
                    text.add("");
                }
                for (String s : credits) {
                    text.add(s);
                }
            }
        }
        this.toolTip = ImmutableList.copyOf((Collection)text);
        this.realConfig = configElement;
    }

    public void drawToolTip(int mouseX, int mouseY) {
        boolean canHover;
        super.drawToolTip(mouseX, mouseY);
        boolean bl = canHover = mouseY < this.owningScreen.entryList.field_148154_c && mouseY > this.owningScreen.entryList.field_148153_b;
        if (this.cullHover.checkHover(mouseX, mouseY, canHover)) {
            this.owningScreen.drawToolTip(this.toolTip, mouseX, mouseY);
        }
        if (this.blockHover.checkHover(mouseX, mouseY, canHover)) {
            this.owningScreen.drawToolTip(this.toolTip, mouseX, mouseY);
        }
        if (this.playHover.checkHover(mouseX, mouseY, canHover)) {
            this.owningScreen.drawToolTip(this.toolTip, mouseX, mouseY);
        }
    }

    public void func_180790_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
        this.owningEntryList.controlWidth -= 205;
        super.func_180790_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected);
        this.owningEntryList.controlWidth += 205;
        this.sliderHover.updateBounds(y, y + slotHeight, x, this.owningEntryList.scrollBarX - 196);
        int buttonWidth = 68;
        this.play.field_146128_h = this.owningEntryList.scrollBarX - 115;
        this.play.field_146129_i = y;
        this.play.field_146124_l = this.enabled();
        this.play.func_146112_a(this.mc, mouseX, mouseY);
        this.cull.field_146128_h = this.owningEntryList.scrollBarX - 115 - 68;
        this.cull.field_146129_i = y;
        this.cull.field_146124_l = this.enabled();
        this.cull.func_146112_a(this.mc, mouseX, mouseY);
        this.block.field_146128_h = this.owningEntryList.scrollBarX - 115 - 136;
        this.block.field_146129_i = y;
        this.block.field_146124_l = this.enabled();
        this.block.func_146112_a(this.mc, mouseX, mouseY);
    }

    public boolean isDefault() {
        return super.isDefault() && this.cull.isDefault() && this.block.isDefault();
    }

    public boolean isChanged() {
        return super.isChanged() || this.cull.isChanged() || this.block.isChanged();
    }

    public void undoChanges() {
        super.undoChanges();
        this.cull.undoChanges();
        this.block.undoChanges();
    }

    public void setToDefault() {
        super.setToDefault();
        this.cull.setToDefault();
        this.block.setToDefault();
    }

    public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        if (this.cull.func_146116_c(this.mc, x, y)) {
            this.cull.toggleState();
        } else if (this.block.func_146116_c(this.mc, x, y)) {
            this.block.toggleState();
        } else if (this.play.func_146116_c(this.mc, x, y)) {
            float volume = (float)((Integer)this.getCurrentValue()).intValue() / 100.0f;
            this.play.playSound(this.mc, volume);
        } else {
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }
        return true;
    }

    public void onGuiClosed() {
        this.play.stopSound();
    }

    public boolean saveConfigElement() {
        if (this.enabled() && this.isChanged()) {
            int volume;
            StringBuilder builder = new StringBuilder();
            if (this.cull.getValue()) {
                builder.append("cull").append(' ');
            }
            if (this.block.getValue()) {
                builder.append("block").append(' ');
            }
            if ((volume = ((GuiSlider)this.btnValue).getValueInt()) != 100) {
                builder.append(volume);
            }
            this.realConfig.set((Object)builder.toString().trim());
            return this.realConfig.requiresMcRestart();
        }
        return false;
    }

    private static class ConfigElementSliderAdapter
    implements IConfigElement {
        private final IConfigElement element;
        private int initialValue;

        public ConfigElementSliderAdapter(@Nonnull IConfigElement element) {
            this.element = element;
            String n = ((String)element.get()).replace("cull", "").replace("block", "").trim();
            this.initialValue = StringUtils.isEmpty((CharSequence)n) ? 100 : Integer.parseInt(n);
        }

        public boolean isProperty() {
            return true;
        }

        public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
            return this.element.getConfigEntryClass();
        }

        public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
            return this.element.getArrayEntryClass();
        }

        public String getName() {
            return this.element.getName();
        }

        public String getQualifiedName() {
            return this.element.getQualifiedName();
        }

        public String getLanguageKey() {
            return this.element.getQualifiedName();
        }

        public String getComment() {
            return this.element.getQualifiedName();
        }

        public List<IConfigElement> getChildElements() {
            return this.element.getChildElements();
        }

        public ConfigGuiType getType() {
            return ConfigGuiType.INTEGER;
        }

        public boolean isList() {
            return false;
        }

        public boolean isListLengthFixed() {
            return true;
        }

        public int getMaxListLength() {
            return this.element.getMaxListLength();
        }

        public boolean isDefault() {
            return this.initialValue == 100;
        }

        public Object getDefault() {
            return 100;
        }

        public Object[] getDefaults() {
            return new Object[]{100};
        }

        public void setToDefault() {
            this.element.setToDefault();
        }

        public boolean requiresWorldRestart() {
            return false;
        }

        public boolean showInGui() {
            return this.element.showInGui();
        }

        public boolean requiresMcRestart() {
            return false;
        }

        public Object get() {
            return this.initialValue;
        }

        public Object[] getList() {
            return new Object[]{this.initialValue};
        }

        public void set(Object value) {
            this.initialValue = Integer.parseInt((String)value);
        }

        public void set(Object[] aVal) {
            this.set(aVal[0]);
        }

        public String[] getValidValues() {
            return this.element.getValidValues();
        }

        public Object getMinValue() {
            return 0;
        }

        public Object getMaxValue() {
            return 400;
        }

        public Pattern getValidationPattern() {
            return this.element.getValidationPattern();
        }
    }
}

