/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers;

import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.handlers.AreaSurveyHandler;
import org.blockartistry.DynSurround.client.handlers.EffectHandlerBase;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.handlers.SoundEffectHandler;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.registry.BiomeInfo;

@SideOnly(value=Side.CLIENT)
public class AreaSoundEffectHandler
extends EffectHandlerBase {
    public static final int SCAN_INTERVAL = 4;

    private boolean doBiomeSounds() {
        return EnvironStateHandler.EnvironState.isPlayerUnderground() || !EnvironStateHandler.EnvironState.isPlayerInside();
    }

    private void getBiomeSounds(@Nonnull TObjectFloatHashMap<SoundEffect> result) {
        AreaSurveyHandler.getBiomes().forEachEntry((biome, w) -> {
            ArrayList<SoundEffect> bs = new ArrayList<SoundEffect>();
            biome.findSoundMatches(bs);
            bs.forEach(fx -> result.adjustOrPutValue(fx, (float)w, (float)w));
            return true;
        });
        float area = AreaSurveyHandler.getBiomeArea();
        result.transformValues(v -> 0.1f + 0.9f * (v / area));
    }

    public AreaSoundEffectHandler() {
        super("Area Sound Effects");
    }

    @Override
    public boolean doTick(int tick) {
        return ModOptions.sound.enableBiomeSounds && tick % 4 == 0 && EnvironStateHandler.EnvironState.getWorld().func_175667_e(EnvironStateHandler.EnvironState.getPlayerPosition());
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        SoundEffect sound2;
        BiomeInfo playerBiome;
        SoundEffect sound3;
        TObjectFloatHashMap sounds = new TObjectFloatHashMap(10, 0.5f, -1.0f);
        if (this.doBiomeSounds()) {
            this.getBiomeSounds((TObjectFloatHashMap<SoundEffect>)sounds);
        }
        ArrayList<SoundEffect> playerSounds = new ArrayList<SoundEffect>();
        ClientRegistry.BIOME.PLAYER_INFO.findSoundMatches(playerSounds);
        if (ModOptions.sound.enableBattleMusic) {
            ClientRegistry.BIOME.BATTLE_MUSIC_INFO.findSoundMatches(playerSounds);
        }
        if (EnvironStateHandler.EnvironState.inVillage()) {
            ClientRegistry.BIOME.VILLAGE_INFO.findSoundMatches(playerSounds);
        }
        playerSounds.forEach(fx -> sounds.put(fx, 1.0f));
        SoundEffectHandler.INSTANCE.queueAmbientSounds((TObjectFloatHashMap<SoundEffect>)sounds);
        if (this.doBiomeSounds() && (sound3 = (playerBiome = EnvironStateHandler.EnvironState.getPlayerBiome()).getSpotSound(this.RANDOM)) != null) {
            SoundEffectHandler.INSTANCE.playSoundAtPlayer(player2, sound3);
        }
        if ((sound2 = ClientRegistry.BIOME.PLAYER_INFO.getSpotSound(this.RANDOM)) != null) {
            SoundEffectHandler.INSTANCE.playSoundAtPlayer(player2, sound2);
        }
    }
}

