/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers;

import gnu.trove.map.custom_hash.TObjectIntCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.handlers.EffectHandlerBase;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.handlers.scanners.AlwaysOnBlockEffectScanner;
import org.blockartistry.DynSurround.client.handlers.scanners.RandomBlockEffectScanner;
import org.blockartistry.DynSurround.registry.BiomeInfo;
import org.blockartistry.lib.BlockStateProvider;
import org.blockartistry.lib.WorldUtils;
import org.blockartistry.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public final class AreaSurveyHandler
extends EffectHandlerBase {
    private static final int BIOME_SURVEY_RANGE = 20;
    private static final int INSIDE_SURVEY_RANGE = 3;
    private static final Cell[] cells;
    private static final float TOTAL_POINTS;
    private static final int SURVEY_INTERVAL = 2;
    private static int biomeArea;
    private static final TObjectIntCustomHashMap<BiomeInfo> weights;
    private static final BlockPos.MutableBlockPos mutable;
    private static BiomeInfo surveyedBiome;
    private static int surveyedDimension;
    private static BlockPos surveyedPosition;
    private static final float INSIDE_THRESHOLD = 0.6306818f;
    private static float ceilingCoverageRatio;
    private static boolean reallyInside;
    protected final RandomBlockEffectScanner effects = new RandomBlockEffectScanner(ModOptions.general.specialEffectRange);
    protected final AlwaysOnBlockEffectScanner alwaysOn = new AlwaysOnBlockEffectScanner(ModOptions.general.specialEffectRange);

    public static int getBiomeArea() {
        return biomeArea;
    }

    public static boolean isReallyInside() {
        return reallyInside;
    }

    public static TObjectIntCustomHashMap<BiomeInfo> getBiomes() {
        return weights;
    }

    private static void doCeilingCoverageRatio() {
        BlockPos pos = EnvironStateHandler.EnvironState.getPlayerPosition();
        float score = 0.0f;
        for (int i = 0; i < cells.length; ++i) {
            score += cells[i].score(pos);
        }
        ceilingCoverageRatio = 1.0f - score / TOTAL_POINTS;
        reallyInside = ceilingCoverageRatio > 0.6306818f;
    }

    public AreaSurveyHandler() {
        super("Area Survey");
    }

    private void doSurvey() {
        biomeArea = 0;
        weights.clear();
        if (EnvironStateHandler.EnvironState.getPlayerBiome().isFake()) {
            biomeArea = 1;
            weights.put((Object)EnvironStateHandler.EnvironState.getPlayerBiome(), 1);
        } else {
            World world = EnvironStateHandler.EnvironState.getWorld();
            BlockStateProvider provider = WorldUtils.getDefaultBlockStateProvider().setWorld(world);
            for (int dX = -20; dX <= 20; ++dX) {
                for (int dZ = -20; dZ <= 20; ++dZ) {
                    ++biomeArea;
                    mutable.func_181079_c(surveyedPosition.func_177958_n() + dX, surveyedPosition.func_177956_o(), surveyedPosition.func_177952_p() + dZ);
                    BiomeInfo biome = ClientRegistry.BIOME.get(provider.getBiome((BlockPos)mutable));
                    weights.adjustOrPutValue((Object)biome, 1, 1);
                }
            }
        }
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        this.effects.func_73660_a();
        this.alwaysOn.func_73660_a();
        BlockPos position = EnvironStateHandler.EnvironState.getPlayerPosition();
        if (surveyedBiome != EnvironStateHandler.EnvironState.getPlayerBiome() || surveyedDimension != EnvironStateHandler.EnvironState.getDimensionId() || surveyedPosition.compareTo((Vec3i)position) != 0) {
            surveyedBiome = EnvironStateHandler.EnvironState.getPlayerBiome();
            surveyedDimension = EnvironStateHandler.EnvironState.getDimensionId();
            surveyedPosition = position;
            this.doSurvey();
        }
        if (EnvironStateHandler.EnvironState.getTickCounter() % 2 == 0) {
            AreaSurveyHandler.doCeilingCoverageRatio();
        }
    }

    @Override
    public void onConnect() {
        weights.clear();
        MinecraftForge.EVENT_BUS.register((Object)this.alwaysOn);
    }

    @Override
    public void onDisconnect() {
        MinecraftForge.EVENT_BUS.unregister((Object)this.alwaysOn);
    }

    static {
        weights = new TObjectIntCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE);
        mutable = new BlockPos.MutableBlockPos();
        surveyedBiome = null;
        surveyedDimension = 0;
        surveyedPosition = BlockPos.field_177992_a;
        ceilingCoverageRatio = 0.0f;
        reallyInside = false;
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                cellList.add(new Cell(new Vec3i(x, 0, z), 3));
            }
        }
        Collections.sort(cellList);
        cells = cellList.toArray(new Cell[0]);
        float totalPoints = 0.0f;
        for (Cell c : cellList) {
            totalPoints += c.potentialPoints();
        }
        TOTAL_POINTS = totalPoints;
    }

    private static final class Cell
    implements Comparable<Cell> {
        private final Vec3i offset;
        private final float points;
        private final BlockPos.MutableBlockPos working;

        public Cell(@Nonnull Vec3i offset, int range) {
            this.offset = offset;
            float xV = range - MathStuff.abs(offset.func_177958_n()) + 1;
            float zV = range - MathStuff.abs(offset.func_177952_p()) + 1;
            float candidate = Math.min(xV, zV);
            this.points = candidate * candidate;
            this.working = new BlockPos.MutableBlockPos();
        }

        public float potentialPoints() {
            return this.points;
        }

        public float score(@Nonnull BlockPos playerPos) {
            this.working.func_181079_c(playerPos.func_177958_n() + this.offset.func_177958_n(), playerPos.func_177956_o() + this.offset.func_177956_o(), playerPos.func_177952_p() + this.offset.func_177952_p());
            int y = WorldUtils.getTopSolidOrLiquidBlock(EnvironStateHandler.EnvironState.getWorld(), (BlockPos)this.working).func_177956_o();
            return y - playerPos.func_177956_o() < 3 ? this.points : 0.0f;
        }

        @Override
        public int compareTo(@Nonnull Cell cell) {
            return -Float.compare(this.potentialPoints(), cell.potentialPoints());
        }

        @Nonnull
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.offset.toString());
            builder.append(" points: ").append(this.points);
            return builder.toString();
        }
    }
}

