/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.aurora.AuroraEngineClassic;
import org.blockartistry.DynSurround.client.aurora.AuroraEngineShader;
import org.blockartistry.DynSurround.client.aurora.AuroraUtils;
import org.blockartistry.DynSurround.client.aurora.IAurora;
import org.blockartistry.DynSurround.client.aurora.IAuroraEngine;
import org.blockartistry.DynSurround.client.handlers.DiagnosticHandler;
import org.blockartistry.DynSurround.client.handlers.EffectHandlerBase;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.shader.Shaders;
import org.blockartistry.DynSurround.event.DiagnosticEvent;
import org.blockartistry.lib.DiurnalUtils;
import org.blockartistry.lib.math.TimerEMA;

@SideOnly(value=Side.CLIENT)
public final class AuroraEffectHandler
extends EffectHandlerBase {
    private final IAuroraEngine auroraEngine;
    private IAurora current;
    private int dimensionId;
    private final TimerEMA timer = new TimerEMA("Aurora Render");
    private long nanos;

    public AuroraEffectHandler() {
        super("Aurora Effect");
        this.auroraEngine = ModOptions.aurora.auroraUseShader && Shaders.areShadersSupported() ? new AuroraEngineShader() : new AuroraEngineClassic();
    }

    @Override
    public void onConnect() {
        this.current = null;
        DiagnosticHandler.INSTANCE.addTimer(this.timer);
    }

    @Override
    public void onDisconnect() {
        this.current = null;
    }

    private boolean spawnAurora(@Nonnull World world) {
        if (!ModOptions.aurora.auroraEnable) {
            return false;
        }
        if (this.current != null || Minecraft.func_71410_x().field_71474_y.field_151451_c < 6 || DiurnalUtils.isAuroraInvisible(world)) {
            return false;
        }
        return AuroraUtils.hasAuroras() && EnvironStateHandler.EnvironState.getPlayerBiome().getHasAurora();
    }

    private boolean canAuroraStay(@Nonnull World world) {
        if (!ModOptions.aurora.auroraEnable) {
            return false;
        }
        return Minecraft.func_71410_x().field_71474_y.field_151451_c < 6 || DiurnalUtils.isAuroraVisible(world) && EnvironStateHandler.EnvironState.getPlayerBiome().getHasAurora();
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        if (this.current != null) {
            if (this.current.isComplete() || this.dimensionId != EnvironStateHandler.EnvironState.getDimensionId() || !ModOptions.aurora.auroraEnable) {
                this.current = null;
            } else {
                this.current.update();
                boolean isDying = this.current.isDying();
                boolean canStay = this.canAuroraStay(player2.func_130014_f_());
                if (isDying && canStay) {
                    DSurround.log().debug("Unfading aurora...", new Object[0]);
                    this.current.setFading(false);
                } else if (!isDying && !canStay) {
                    DSurround.log().debug("Aurora fade...", new Object[0]);
                    this.current.setFading(true);
                }
            }
        }
        if (this.spawnAurora(player2.func_130014_f_())) {
            this.current = this.auroraEngine.produce(AuroraUtils.getSeed());
            DSurround.log().debug("New aurora [%s]", this.current.toString());
        }
        this.dimensionId = EnvironStateHandler.EnvironState.getDimensionId();
        this.timer.update(this.nanos);
        this.nanos = 0L;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void doRender(@Nonnull RenderWorldLastEvent event) {
        long start = System.nanoTime();
        if (this.current != null) {
            this.current.render(event.getPartialTicks());
        }
        this.nanos += System.nanoTime() - start;
    }

    @SubscribeEvent
    public void diagnostic(@Nonnull DiagnosticEvent.Gather event) {
        event.output.add("Aurora: " + (this.current == null ? "NONE" : this.current.toString()));
    }
}

