/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers;

import com.google.common.collect.ImmutableList;
import gnu.trove.procedure.TIntDoubleProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.handlers.EffectHandlerBase;
import org.blockartistry.DynSurround.client.swing.DiagnosticPanel;
import org.blockartistry.DynSurround.event.DiagnosticEvent;
import org.blockartistry.DynSurround.event.ServerDataEvent;
import org.blockartistry.lib.math.MathStuff;
import org.blockartistry.lib.math.TimerEMA;

@SideOnly(value=Side.CLIENT)
public class DiagnosticHandler
extends EffectHandlerBase {
    public static DiagnosticHandler INSTANCE;
    private List<String> diagnostics = ImmutableList.of();
    private List<String> serverDataReport = ImmutableList.of();
    private List<TimerEMA> timers = new ArrayList<TimerEMA>();
    private TimerEMA clientTick = new TimerEMA("Client Tick");
    private TimerEMA lastTick = new TimerEMA("Last Tick");
    private long timeMark;
    private long lastTickMark = -1L;
    private float tps = 0.0f;

    public DiagnosticHandler() {
        super("Diagnostics");
        INSTANCE = this;
    }

    public void addTimer(@Nonnull TimerEMA timer) {
        this.timers.add(timer);
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P && ModOptions.logging.enableDebugLogging) {
            DiagnosticEvent.Gather gather = new DiagnosticEvent.Gather(player2.func_130014_f_(), player2);
            MinecraftForge.EVENT_BUS.post((Event)gather);
            this.diagnostics = gather.output;
        } else {
            this.diagnostics = null;
        }
        if (ModOptions.logging.showDebugDialog) {
            DiagnosticPanel.refresh();
        }
    }

    @Override
    public void onConnect() {
        this.diagnostics = null;
        this.serverDataReport = null;
        if (ModOptions.logging.showDebugDialog) {
            DiagnosticPanel.create();
        }
    }

    @Override
    public void onDisconnect() {
        this.diagnostics = null;
        this.serverDataReport = null;
        INSTANCE = null;
        if (ModOptions.logging.showDebugDialog) {
            DiagnosticPanel.destroy();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void tickStart(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.timeMark = System.nanoTime();
            if (this.lastTickMark != -1L) {
                this.lastTick.update(this.timeMark - this.lastTickMark);
                this.tps = MathStuff.clamp((float)(50.0 / this.lastTick.getMSecs() * 20.0), 0.0f, 20.0f);
            }
            this.lastTickMark = this.timeMark;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void tickEnd(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.clientTick.update(System.nanoTime() - this.timeMark);
        }
    }

    @SubscribeEvent
    public void onGatherText(@Nonnull RenderGameOverlayEvent.Text event) {
        if (this.diagnostics != null && !this.diagnostics.isEmpty()) {
            event.getLeft().add("");
            event.getLeft().addAll(this.diagnostics);
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            event.getRight().add(" ");
            event.getRight().add(TextFormatting.LIGHT_PURPLE + this.clientTick.toString());
            event.getRight().add(TextFormatting.LIGHT_PURPLE + this.lastTick.toString());
            event.getRight().add(TextFormatting.LIGHT_PURPLE + String.format("TPS:%7.3fms", Float.valueOf(this.tps)));
            for (TimerEMA timer : this.timers) {
                event.getRight().add(TextFormatting.AQUA + timer.toString());
            }
            if (this.serverDataReport != null) {
                event.getRight().add(" ");
                event.getRight().addAll(this.serverDataReport);
            }
        }
    }

    @Nonnull
    private static TextFormatting getTpsFormatPrefix(int tps) {
        if (tps <= 10) {
            return TextFormatting.RED;
        }
        if (tps <= 15) {
            return TextFormatting.YELLOW;
        }
        return TextFormatting.GREEN;
    }

    @SubscribeEvent
    public void serverDataEvent(ServerDataEvent event) {
        final ArrayList<String> data = new ArrayList<String>();
        int diff = event.total - event.free;
        data.add(TextFormatting.GOLD + "Server Information");
        data.add(String.format("Mem: %d%% %03d/%3dMB", diff * 100 / event.max, diff, event.max));
        data.add(String.format("Allocated: %d%% %3dMB", event.total * 100 / event.max, event.total));
        int tps = (int)Math.min(1000.0 / event.meanTickTime, 20.0);
        data.add(String.format("Ticktime Overall:%s %5.3fms (%d TPS)", DiagnosticHandler.getTpsFormatPrefix(tps), event.meanTickTime, tps));
        event.dimTps.forEachEntry(new TIntDoubleProcedure(){

            public boolean execute(int a, double b) {
                String dimName = DimensionManager.getProviderType((int)a).func_186065_b();
                int tps = (int)Math.min(1000.0 / b, 20.0);
                data.add(String.format("%s (%d):%s %7.3fms (%d TPS)", dimName, a, DiagnosticHandler.getTpsFormatPrefix(tps), b, tps));
                return true;
            }
        });
        Collections.sort(data.subList(4, data.size()));
        this.serverDataReport = data;
    }
}

