/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers;

import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.handlers.AreaSoundEffectHandler;
import org.blockartistry.DynSurround.client.handlers.AreaSurveyHandler;
import org.blockartistry.DynSurround.client.handlers.AuroraEffectHandler;
import org.blockartistry.DynSurround.client.handlers.DiagnosticHandler;
import org.blockartistry.DynSurround.client.handlers.EffectHandlerBase;
import org.blockartistry.DynSurround.client.handlers.EntityEmojiHandler;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.handlers.EnvironmentEffectHandler;
import org.blockartistry.DynSurround.client.handlers.FxHandler;
import org.blockartistry.DynSurround.client.handlers.ParticleSystemHandler;
import org.blockartistry.DynSurround.client.handlers.SoundEffectHandler;
import org.blockartistry.DynSurround.client.handlers.SpeechBubbleHandler;
import org.blockartistry.DynSurround.client.handlers.WeatherHandler;
import org.blockartistry.lib.collections.ObjectArray;
import org.blockartistry.lib.compat.EntityLivingBaseUtil;
import org.blockartistry.lib.math.TimerEMA;

@SideOnly(value=Side.CLIENT)
public class EffectManager {
    private static EffectManager INSTANCE = null;
    private final ObjectArray<EffectHandlerBase> effectHandlers = new ObjectArray();
    private TimerEMA computeTime;

    private EffectManager() {
    }

    private void init() {
        this.effectHandlers.add(new EnvironStateHandler());
        this.effectHandlers.add(new AreaSurveyHandler());
        this.effectHandlers.add(new EnvironmentEffectHandler());
        this.effectHandlers.add(new ParticleSystemHandler());
        this.effectHandlers.add(new AreaSoundEffectHandler());
        this.effectHandlers.add(new EntityEmojiHandler());
        this.effectHandlers.add(new AuroraEffectHandler());
        this.effectHandlers.add(new SpeechBubbleHandler());
        this.effectHandlers.add(new WeatherHandler());
        this.effectHandlers.add(new FxHandler());
        this.effectHandlers.add(SoundEffectHandler.INSTANCE);
        this.effectHandlers.add(new DiagnosticHandler());
        for (EffectHandlerBase h : this.effectHandlers) {
            h.connect0();
        }
        this.computeTime = new TimerEMA("Processing");
        DiagnosticHandler.INSTANCE.addTimer(this.computeTime);
    }

    private void fini() {
        for (EffectHandlerBase h : this.effectHandlers) {
            h.disconnect0();
        }
        this.effectHandlers.clear();
        this.computeTime = null;
    }

    public static void register() {
        INSTANCE = new EffectManager();
        INSTANCE.init();
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public static void unregister() {
        if (INSTANCE != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCE);
            INSTANCE.fini();
            INSTANCE = null;
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER || event.phase == TickEvent.Phase.END || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (event.player == null || event.player.func_130014_f_() == null) {
            return;
        }
        if (event.player != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        long start = System.nanoTime();
        if (ModOptions.player.suppressPotionParticles) {
            event.player.func_184212_Q().func_187227_b(EntityLivingBaseUtil.getHideParticles(), (Object)true);
        }
        int tick = EnvironStateHandler.EnvironState.getTickCounter();
        for (int i = 0; i < this.effectHandlers.size(); ++i) {
            EffectHandlerBase handler = this.effectHandlers.get(i);
            long mark = System.nanoTime();
            if (handler.doTick(tick)) {
                handler.process(event.player);
            }
            handler.updateTimer(System.nanoTime() - mark);
        }
        this.computeTime.update(System.nanoTime() - start);
    }
}

