/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.api.events.EnvironmentEvent;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.handlers.AreaSurveyHandler;
import org.blockartistry.DynSurround.client.handlers.EffectHandlerBase;
import org.blockartistry.DynSurround.client.handlers.scanners.BattleScanner;
import org.blockartistry.DynSurround.client.weather.Weather;
import org.blockartistry.DynSurround.event.DiagnosticEvent;
import org.blockartistry.DynSurround.expression.ExpressionEngine;
import org.blockartistry.DynSurround.registry.ArmorClass;
import org.blockartistry.DynSurround.registry.BiomeInfo;
import org.blockartistry.DynSurround.registry.BiomeRegistry;
import org.blockartistry.DynSurround.registry.DimensionInfo;
import org.blockartistry.DynSurround.registry.DimensionRegistry;
import org.blockartistry.DynSurround.registry.SeasonRegistry;
import org.blockartistry.DynSurround.registry.SeasonType;
import org.blockartistry.DynSurround.registry.TemperatureRating;
import org.blockartistry.lib.MinecraftClock;

@SideOnly(value=Side.CLIENT)
public class EnvironStateHandler
extends EffectHandlerBase {
    private static final String[] scripts = new String[]{"'Dim: ' + player.dimension + '/' + player.dimensionName", "'Biome: ' + biome.name + ' (' + biome.id + '); Temp ' + biome.temperature + '/' + biome.temperatureValue + ' rainfall: ' + biome.rainfall", "'Weather: ' + IF(weather.isRaining,'rainfall: ' + weather.rainfall,'not raining') + IF(weather.isThundering,' thundering','') + ' Temp: ' + weather.temperature + '/' + weather.temperatureValue + ' ' + IF(weather.temperatureValue < 0.2, '(breath)', '')", "'Season: ' + season  + IF(isNight,' night',' day') + IF(player.isInside,' inside',' outside')", "'Player: Temp ' + player.temperature + '; health ' + player.health + '/' + player.maxHealth + '; food ' + player.food.level + '; saturation ' + player.food.saturation + IF(player.isHurt,' isHurt','') + IF(player.isHungry,' isHungry','') + ' pos: (' + player.X + ',' + player.Y + ',' + player.Z + ') light: ' + player.lightLevel", "'Village: ' + player.inVillage"};

    public EnvironStateHandler() {
        super("State Handler");
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        EnvironState.tick(player2.func_130014_f_(), player2);
        Weather.update();
        ExpressionEngine.instance().update();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityJoin(@Nonnull EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerSP) {
            EnvironState.tick(event.getWorld(), (EntityPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onEnvironmentEvent(@Nonnull EnvironmentEvent event) {
        EnvironState.inVillage = event.inVillage;
    }

    @Override
    public void onConnect() {
        EnvironState.reset();
        ExpressionEngine.instance();
    }

    @Override
    public void onDisconnect() {
        EnvironState.reset();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void diagnostics(DiagnosticEvent.Gather event) {
        event.output.add(TextFormatting.GREEN + "Minecraft Date: " + EnvironState.getClock().toString());
        for (String s : scripts) {
            String result = ExpressionEngine.instance().eval(s).toString();
            event.output.add(TextFormatting.YELLOW + result);
        }
        List<String> badScripts = ExpressionEngine.instance().getNaughtyList();
        for (String s : badScripts) {
            event.output.add("BAD SCRIPT: " + s);
        }
    }

    public static class EnvironState {
        private static String biomeName;
        private static BiomeInfo playerBiome;
        private static BiomeInfo truePlayerBiome;
        private static SeasonType season;
        private static int dimensionId;
        private static String dimensionName;
        private static DimensionInfo dimInfo;
        private static BlockPos playerPosition;
        private static EntityPlayer player;
        private static World world;
        private static boolean freezing;
        private static boolean humid;
        private static boolean dry;
        private static TemperatureRating playerTemperature;
        private static TemperatureRating biomeTemperature;
        private static boolean inside;
        private static ArmorClass armorClass;
        private static ArmorClass footArmorClass;
        private static boolean inVillage;
        private static boolean isUnderground;
        private static boolean isInSpace;
        private static boolean isInClouds;
        private static int lightLevel;
        private static int tickCounter;
        private static MinecraftClock clock;
        private static BattleScanner battle;

        private static BlockPos getPlayerPos() {
            return new BlockPos(EnvironState.player.field_70165_t, EnvironState.player.func_174813_aQ().field_72338_b, EnvironState.player.field_70161_v);
        }

        private static void reset() {
            BiomeInfo WTF = ClientRegistry.BIOME.WTF_INFO;
            biomeName = "";
            playerBiome = WTF;
            truePlayerBiome = WTF;
            season = SeasonType.NONE;
            dimensionId = 0;
            dimensionName = "";
            dimInfo = DimensionInfo.NONE;
            playerPosition = BlockPos.field_177992_a;
            player = null;
            world = null;
            freezing = false;
            humid = false;
            dry = false;
            playerTemperature = TemperatureRating.MILD;
            biomeTemperature = TemperatureRating.MILD;
            inside = false;
            armorClass = ArmorClass.NONE;
            footArmorClass = ArmorClass.NONE;
            inVillage = false;
            isUnderground = false;
            isInSpace = false;
            isInClouds = false;
            lightLevel = 0;
            tickCounter = 0;
            clock = new MinecraftClock();
            battle = new BattleScanner();
        }

        private static void tick(World world, EntityPlayer player2) {
            BiomeRegistry biomes2 = ClientRegistry.BIOME;
            SeasonRegistry seasons = ClientRegistry.SEASON;
            DimensionRegistry dimensions = ClientRegistry.DIMENSION;
            player = player2;
            EnvironState.world = player2.func_130014_f_();
            dimInfo = dimensions.getData(player2.func_130014_f_());
            clock.update(EnvironState.world);
            playerBiome = ClientRegistry.BIOME.getPlayerBiome(player2, false);
            biomeName = playerBiome.getBiomeName();
            season = seasons.getSeasonType(world);
            dimensionId = world.field_73011_w.getDimension();
            dimensionName = world.field_73011_w.func_186058_p().func_186065_b();
            playerPosition = EnvironState.getPlayerPos();
            inside = AreaSurveyHandler.isReallyInside();
            truePlayerBiome = ClientRegistry.BIOME.getPlayerBiome(player2, true);
            freezing = truePlayerBiome.getFloatTemperature(playerPosition) < 0.15f;
            playerTemperature = seasons.getPlayerTemperature(world);
            biomeTemperature = seasons.getBiomeTemperature(world, EnvironState.getPlayerPosition());
            humid = truePlayerBiome.isHighHumidity();
            dry = truePlayerBiome.getRainfall() < 0.2f;
            armorClass = ArmorClass.effectiveArmorClass((EntityLivingBase)player2);
            footArmorClass = ArmorClass.footArmorClass((EntityLivingBase)player2);
            isUnderground = playerBiome == biomes2.UNDERGROUND_INFO;
            isInSpace = playerBiome == biomes2.OUTERSPACE_INFO;
            isInClouds = playerBiome == biomes2.CLOUDS_INFO;
            BlockPos pos = EnvironState.getPlayerPosition();
            int blockLight = world.func_175642_b(EnumSkyBlock.BLOCK, pos);
            int skyLight = world.func_175642_b(EnumSkyBlock.SKY, pos) - world.func_72967_a(1.0f);
            lightLevel = Math.max(blockLight, skyLight);
            if (ModOptions.sound.enableBattleMusic) {
                battle.func_73660_a();
            } else {
                battle.reset();
            }
            if (!Minecraft.func_71410_x().func_147113_T()) {
                ++tickCounter;
            }
        }

        public static MinecraftClock getClock() {
            return clock;
        }

        public static BattleScanner getBattleScanner() {
            return battle;
        }

        public static DimensionInfo getDimensionInfo() {
            return dimInfo;
        }

        public static BiomeInfo getPlayerBiome() {
            return playerBiome;
        }

        public static BiomeInfo getTruePlayerBiome() {
            return truePlayerBiome;
        }

        public static String getBiomeName() {
            return biomeName;
        }

        public static SeasonType getSeason() {
            return season;
        }

        public static TemperatureRating getPlayerTemperature() {
            return playerTemperature;
        }

        public static TemperatureRating getBiomeTemperature() {
            return biomeTemperature;
        }

        public static int getDimensionId() {
            return dimensionId;
        }

        public static String getDimensionName() {
            return dimensionName;
        }

        public static EntityPlayer getPlayer() {
            return player;
        }

        public static World getWorld() {
            return world;
        }

        public static BlockPos getPlayerPosition() {
            return playerPosition;
        }

        public static boolean isPlayer(Entity entity) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer ep = (EntityPlayer)entity;
                return player == null || ep.func_110124_au().equals(player.func_110124_au());
            }
            return false;
        }

        public static boolean isPlayer(UUID id) {
            return player == null || player.func_110124_au().equals(id);
        }

        public static boolean isPlayer(int id) {
            return player == null || player.func_145782_y() == id;
        }

        public static boolean isCreative() {
            return player != null && EnvironState.player.field_71075_bZ.field_75098_d;
        }

        public static boolean isPlayerHurt() {
            return player != null && ModOptions.player.playerHurtThreshold != 0 && !EnvironState.isCreative() && player.func_110143_aJ() <= (float)ModOptions.player.playerHurtThreshold;
        }

        public static boolean isPlayerHungry() {
            return player != null && ModOptions.player.playerHungerThreshold != 0 && !EnvironState.isCreative() && player.func_71024_bL().func_75116_a() <= ModOptions.player.playerHungerThreshold;
        }

        public static boolean isPlayerBurning() {
            return player != null && player.func_70027_ad();
        }

        public static boolean isPlayerSuffocating() {
            return player != null && player.func_70086_ai() <= 0;
        }

        public static boolean isPlayerFlying() {
            return player != null && EnvironState.player.field_71075_bZ.field_75100_b;
        }

        public static boolean isPlayerSprinting() {
            return player != null && player.func_70051_ag();
        }

        public static boolean isPlayerInLava() {
            return player != null && player.func_180799_ab();
        }

        public static boolean isPlayerInvisible() {
            return player != null && player.func_82150_aj();
        }

        public static boolean isPlayerBlind() {
            return player != null && player.func_70644_a(MobEffects.field_76440_q);
        }

        public static boolean isPlayerInWater() {
            return player != null && player.func_70090_H();
        }

        public static boolean isPlayerRiding() {
            return player != null && player.func_184218_aH();
        }

        public static boolean isPlayerOnGround() {
            return player != null && EnvironState.player.field_70122_E;
        }

        public static boolean isPlayerMoving() {
            return player != null && EnvironState.player.field_70140_Q != EnvironState.player.field_70141_P;
        }

        public static boolean isPlayerSneaking() {
            return player != null && player.func_70093_af();
        }

        public static boolean isPlayerInside() {
            return inside;
        }

        public static boolean isPlayerUnderground() {
            return isUnderground;
        }

        public static boolean isPlayerInSpace() {
            return isInSpace;
        }

        public static boolean isPlayerInClouds() {
            return isInClouds;
        }

        public static boolean isFreezing() {
            return freezing;
        }

        public static boolean isHumid() {
            return humid;
        }

        public static boolean isDry() {
            return dry;
        }

        public static ArmorClass getPlayerArmorClass() {
            return armorClass;
        }

        public static ArmorClass getPlayerFootArmorClass() {
            return footArmorClass;
        }

        public static boolean inVillage() {
            return inVillage;
        }

        public static int getLightLevel() {
            return lightLevel;
        }

        public static int getTickCounter() {
            return tickCounter;
        }

        public static float getPartialTick() {
            return Minecraft.func_71410_x().func_184121_ak();
        }

        public static double distanceToPlayer(double x, double y, double z) {
            return player != null ? player.func_70092_e(x, y, z) : 0.0;
        }

        static {
            playerBiome = null;
            truePlayerBiome = null;
            dimInfo = DimensionInfo.NONE;
            clock = new MinecraftClock();
            battle = new BattleScanner();
        }
    }
}

