/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.handlers.DiagnosticHandler;
import org.blockartistry.DynSurround.client.handlers.EffectHandlerBase;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.handlers.SoundEffectHandler;
import org.blockartistry.DynSurround.client.handlers.effects.CraftingSoundEffect;
import org.blockartistry.DynSurround.client.handlers.effects.EntityBowSoundEffect;
import org.blockartistry.DynSurround.client.handlers.effects.EntityChatEffect;
import org.blockartistry.DynSurround.client.handlers.effects.EntityFootprintEffect;
import org.blockartistry.DynSurround.client.handlers.effects.EntityHealthPopoffEffect;
import org.blockartistry.DynSurround.client.handlers.effects.EntitySwingEffect;
import org.blockartistry.DynSurround.client.handlers.effects.FrostBreathEffect;
import org.blockartistry.DynSurround.client.handlers.effects.PlayerToolBarSoundEffect;
import org.blockartistry.DynSurround.client.handlers.effects.VillagerChatEffect;
import org.blockartistry.DynSurround.event.DiagnosticEvent;
import org.blockartistry.DynSurround.event.ReloadEvent;
import org.blockartistry.lib.effects.EntityEffectHandler;
import org.blockartistry.lib.effects.EntityEffectLibrary;
import org.blockartistry.lib.effects.EventEffectLibrary;
import org.blockartistry.lib.effects.IParticleHelper;
import org.blockartistry.lib.effects.ISoundHelper;
import org.blockartistry.lib.gfx.ParticleHelper;
import org.blockartistry.lib.math.TimerEMA;
import org.blockartistry.lib.sound.BasicSound;

@SideOnly(value=Side.CLIENT)
public class FxHandler
extends EffectHandlerBase {
    private static final IParticleHelper PARTICLE_HELPER = p -> ParticleHelper.addParticle(p);
    private static final ISoundHelper SOUND_HELPER = new ISoundHelper(){

        @Override
        public String playSound(@Nonnull BasicSound<?> sound2) {
            return SoundEffectHandler.INSTANCE.playSound(sound2);
        }

        @Override
        public void stopSound(@Nonnull String id) {
            SoundEffectHandler.INSTANCE.stopSound(id);
        }
    };
    private static final Predicate<EntityEffectHandler> HANDLER_UPDATE_REMOVE = handler -> {
        handler.update();
        return !handler.isAlive();
    };
    private static final EntityEffectLibrary library = new EntityEffectLibrary(PARTICLE_HELPER, SOUND_HELPER);
    public static FxHandler INSTANCE;
    private final Map<UUID, EntityEffectHandler> handlers = new HashMap<UUID, EntityEffectHandler>(256);
    private final EventEffectLibrary eventLibrary = new EventEffectLibrary(PARTICLE_HELPER, SOUND_HELPER);
    private TimerEMA compute = new TimerEMA("FxHandler Updates");
    private long nanos;

    public FxHandler() {
        super("Special Effects");
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        this.handlers.values().removeIf(HANDLER_UPDATE_REMOVE);
        this.compute.update(this.nanos);
        this.nanos = 0L;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void diagnostics(@Nonnull DiagnosticEvent.Gather event) {
        StringBuilder builder = new StringBuilder();
        builder.append("EffectHandlers: ").append(this.handlers.size());
        event.output.add(builder.toString());
    }

    public List<String> getEffects(@Nonnull Entity entity) {
        EntityEffectHandler eh = this.handlers.get(entity.func_110124_au());
        if (eh != null) {
            return eh.getAttachedEffects();
        }
        return ImmutableList.of();
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onLivingUpdate(@Nonnull LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (entity == null || !entity.func_130014_f_().field_72995_K) {
            return;
        }
        long start = System.nanoTime();
        double distanceThreshold = ModOptions.general.specialEffectRange * ModOptions.general.specialEffectRange;
        boolean inRange = entity.func_70068_e((Entity)EnvironStateHandler.EnvironState.getPlayer()) <= distanceThreshold && entity.field_71093_bK == EnvironStateHandler.EnvironState.getDimensionId();
        EntityEffectHandler handler = this.handlers.get(entity.func_110124_au());
        if (handler != null && !inRange) {
            handler.die();
        } else if (handler == null && inRange && entity.func_70089_S()) {
            this.handlers.put(entity.func_110124_au(), library.create(entity).get());
        }
        this.nanos += System.nanoTime() - start;
    }

    protected void clearHandlers() {
        this.handlers.values().forEach(EntityEffectHandler::die);
        this.handlers.clear();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoin(@Nonnull EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerSP) {
            this.clearHandlers();
        }
    }

    @SubscribeEvent
    public void registryReload(@Nonnull ReloadEvent.Registry event) {
        this.clearHandlers();
    }

    @Override
    public void onConnect() {
        this.clearHandlers();
        this.eventLibrary.register(new CraftingSoundEffect());
        INSTANCE = this;
        DiagnosticHandler.INSTANCE.addTimer(this.compute);
    }

    @Override
    public void onDisconnect() {
        this.clearHandlers();
        this.eventLibrary.cleanup();
        INSTANCE = null;
    }

    static {
        library.register(FrostBreathEffect.DEFAULT_FILTER, new FrostBreathEffect.Factory());
        library.register(EntityChatEffect.DEFAULT_FILTER, new EntityChatEffect.Factory());
        library.register(VillagerChatEffect.DEFAULT_FILTER, new VillagerChatEffect.Factory());
        library.register(PlayerToolBarSoundEffect.DEFAULT_FILTER, new PlayerToolBarSoundEffect.Factory());
        library.register(EntityFootprintEffect.DEFAULT_FILTER, new EntityFootprintEffect.Factory());
        library.register(EntitySwingEffect.DEFAULT_FILTER, new EntitySwingEffect.Factory());
        library.register(EntityBowSoundEffect.DEFAULT_FILTER, new EntityBowSoundEffect.Factory());
        library.register(EntityHealthPopoffEffect.DEFAULT_FILTER, new EntityHealthPopoffEffect.Factory());
    }
}

