/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.effects;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.sound.Sounds;
import org.blockartistry.lib.effects.EventEffect;
import org.blockartistry.lib.sound.BasicSound;

@SideOnly(value=Side.CLIENT)
public class CraftingSoundEffect
extends EventEffect {
    private int craftSoundThrottle = 0;

    @SubscribeEvent
    public void onEvent(@Nonnull PlayerEvent.ItemCraftedEvent event) {
        if (!ModOptions.sound.enableCraftingSound || !this.isClientValid((PlayerEvent)event)) {
            return;
        }
        if (this.craftSoundThrottle >= EnvironStateHandler.EnvironState.getTickCounter() - 30) {
            return;
        }
        this.craftSoundThrottle = EnvironStateHandler.EnvironState.getTickCounter();
        BasicSound<?> fx = this.getState().createSound(Sounds.CRAFTING, (Entity)event.player);
        fx.setRoutable(true);
        this.getState().playSound(fx);
    }
}

