/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.registry.EntityEffectInfo;
import org.blockartistry.lib.ItemStackUtil;
import org.blockartistry.lib.effects.EntityEffect;
import org.blockartistry.lib.effects.IEntityEffectFactory;
import org.blockartistry.lib.effects.IEntityEffectFactoryFilter;
import org.blockartistry.lib.sound.BasicSound;

@SideOnly(value=Side.CLIENT)
public class EntityBowSoundEffect
extends EntityEffect {
    protected ItemStack lastActiveStack;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER = new IEntityEffectFactoryFilter(){

        @Override
        public boolean applies(@Nonnull Entity e, @Nonnull EntityEffectInfo eei) {
            return eei.effects.contains("bow");
        }
    };

    @Override
    public String name() {
        return "Bow Sound";
    }

    @Override
    public void update(@Nonnull Entity subject) {
        EntityLivingBase entity = (EntityLivingBase)subject;
        ItemStack currentStack = entity.func_184607_cu();
        if (ItemStackUtil.isValidItemStack(currentStack)) {
            if (this.lastActiveStack == null || !ItemStack.func_77989_b((ItemStack)currentStack, (ItemStack)this.lastActiveStack)) {
                SoundEffect soundEffect;
                if ((ClientRegistry.ITEMS.isBow(currentStack) || ClientRegistry.ITEMS.isShield(currentStack)) && (soundEffect = ClientRegistry.ITEMS.getUseSound(currentStack)) != null) {
                    BasicSound<?> fx = this.getState().createSound(soundEffect, (Entity)entity);
                    this.getState().playSound(fx);
                }
                this.lastActiveStack = currentStack;
            }
        } else {
            this.lastActiveStack = null;
        }
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        public List<EntityEffect> create(@Nonnull Entity entity, @Nonnull EntityEffectInfo eei) {
            return ImmutableList.of((Object)new EntityBowSoundEffect());
        }
    }
}

