/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.fx.particle.ParticleTextPopOff;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.registry.EntityEffectInfo;
import org.blockartistry.lib.Color;
import org.blockartistry.lib.effects.EntityEffect;
import org.blockartistry.lib.effects.IEntityEffectFactory;
import org.blockartistry.lib.effects.IEntityEffectFactoryFilter;
import org.blockartistry.lib.effects.IEntityEffectHandlerState;
import org.blockartistry.lib.math.MathStuff;
import org.blockartistry.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class EntityHealthPopoffEffect
extends EntityEffect {
    private static final Color CRITICAL_TEXT_COLOR = Color.MC_GOLD;
    private static final Color HEAL_TEXT_COLOR = Color.MC_GREEN;
    private static final Color DAMAGE_TEXT_COLOR = Color.MC_RED;
    private static final String[] POWER_WORDS = new String[]{"AIEEE", "AIIEEE", "ARRGH", "AWK", "AWKKKKKK", "BAM", "BANG", "BANG-ETH", "BIFF", "BLOOP", "BLURP", "BOFF", "BONK", "CLANK", "CLANK-EST", "CLASH", "CLUNK", "CLUNK-ETH", "CRRAACK", "CRASH", "CRRAACK", "CRUNCH", "CRUNCH-ETH", "EEE-YOW", "FLRBBBBB", "GLIPP", "GLURPP", "KAPOW", "KAYO", "KER-SPLOOSH", "KERPLOP", "KLONK", "KLUNK", "KRUNCH", "OOOFF", "OOOOFF", "OUCH", "OUCH-ETH", "OWWW", "OW-ETH", "PAM", "PLOP", "POW", "POWIE", "QUNCKKK", "RAKKK", "RIP", "SLOSH", "SOCK", "SPLATS", "SPLATT", "SPLOOSH", "SWAAP", "SWISH", "SWOOSH", "THUNK", "THWACK", "THWACKE", "THWAPE", "THWAPP", "UGGH", "URKKK", "VRONK", "WHACK", "WHACK-ETH", "WHAM-ETH", "WHAMM", "WHAMMM", "WHAP", "Z-ZWAP", "ZAM", "ZAMM", "ZAMMM", "ZAP", "ZAP-ETH", "ZGRUPPP", "ZLONK", "ZLOPP", "ZLOTT", "ZOK", "ZOWIE", "ZWAPP", "ZZWAP", "ZZZZWAP", "ZZZZZWAP"};
    protected float lastHealth;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER = new IEntityEffectFactoryFilter(){

        @Override
        public boolean applies(@Nonnull Entity e, @Nonnull EntityEffectInfo eei) {
            return e instanceof EntityLivingBase;
        }
    };

    private String getPowerWord() {
        return POWER_WORDS[XorShiftRandom.current().nextInt(POWER_WORDS.length)] + "!";
    }

    @Override
    public void intitialize(@Nonnull IEntityEffectHandlerState state) {
        super.intitialize(state);
        EntityLivingBase entity = (EntityLivingBase)this.getState().subject().get();
        this.lastHealth = entity.func_110143_aJ();
    }

    @Override
    public String name() {
        return "Health Tracker";
    }

    @Override
    public boolean receiveLastCall() {
        return true;
    }

    @Override
    public void update(@Nonnull Entity subject) {
        if (!ModOptions.player.enableDamagePopoffs) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)subject;
        if (this.lastHealth != entity.func_110143_aJ()) {
            World world = EnvironStateHandler.EnvironState.getWorld();
            int adjustment = MathHelper.func_76123_f((float)(entity.func_110143_aJ() - this.lastHealth));
            this.lastHealth = entity.func_110143_aJ();
            if (!EnvironStateHandler.EnvironState.isPlayer(subject) || Minecraft.func_71410_x().func_175598_ae().field_78733_k.field_74320_O != 0) {
                int delta = Math.max(1, MathStuff.abs(adjustment));
                int criticalAmount = (int)(entity.func_110138_aP() / 2.5f);
                AxisAlignedBB bb = entity.func_174813_aQ();
                double posX = entity.field_70165_t;
                double posY = bb.field_72337_e + 0.5;
                double posZ = entity.field_70161_v;
                String text = String.valueOf(delta);
                Color color = adjustment > 0 ? HEAL_TEXT_COLOR : DAMAGE_TEXT_COLOR;
                ParticleTextPopOff particle = null;
                if (ModOptions.player.showCritWords && adjustment < 0 && delta >= criticalAmount) {
                    particle = new ParticleTextPopOff(world, this.getPowerWord(), CRITICAL_TEXT_COLOR, posX, posY + 0.5, posZ);
                    this.getState().addParticle(particle);
                }
                particle = new ParticleTextPopOff(world, text, color, posX, posY, posZ);
                this.getState().addParticle(particle);
            }
        }
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        public List<EntityEffect> create(@Nonnull Entity entity, @Nonnull EntityEffectInfo eei) {
            return ImmutableList.of((Object)new EntityHealthPopoffEffect());
        }
    }
}

