/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.handlers.SoundEffectHandler;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.registry.EntityEffectInfo;
import org.blockartistry.lib.effects.EntityEffect;
import org.blockartistry.lib.effects.IEntityEffectFactory;
import org.blockartistry.lib.effects.IEntityEffectFactoryFilter;
import org.blockartistry.lib.math.RayTrace;
import org.blockartistry.lib.sound.BasicSound;

@SideOnly(value=Side.CLIENT)
public class EntitySwingEffect
extends EntityEffect {
    protected int swingProgress = 0;
    protected boolean isSwinging = false;
    protected String soundId;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER = new IEntityEffectFactoryFilter(){

        @Override
        public boolean applies(@Nonnull Entity e, @Nonnull EntityEffectInfo eei) {
            return eei.effects.contains("swing");
        }
    };

    @Override
    public String name() {
        return "Item Swing";
    }

    @Override
    public void update(@Nonnull Entity subject) {
        EntityLivingBase entity = (EntityLivingBase)subject;
        if (entity.func_184187_bx() instanceof EntityBoat) {
            return;
        }
        if (entity.field_184622_au != null && entity.field_110158_av > this.swingProgress) {
            if (!this.isSwinging) {
                float reach;
                RayTraceResult whatImHitting;
                ItemStack currentItem;
                SoundEffect soundEffect;
                if (!StringUtils.isEmpty((CharSequence)this.soundId)) {
                    SoundEffectHandler.INSTANCE.stopSound(this.soundId);
                    this.soundId = null;
                }
                if ((soundEffect = ClientRegistry.ITEMS.getSwingSound(currentItem = entity.func_184586_b(entity.field_184622_au))) != null && (whatImHitting = new RayTrace((Entity)entity).trace(reach = Minecraft.func_71410_x().field_71442_b.func_78757_d())) != null && (whatImHitting.field_72313_a == RayTraceResult.Type.ENTITY || whatImHitting.field_72313_a == RayTraceResult.Type.MISS)) {
                    BasicSound<?> sound2 = this.getState().createSound(soundEffect, (Entity)entity);
                    this.soundId = this.getState().playSound(sound2);
                }
            }
            this.isSwinging = true;
            this.swingProgress = entity.field_110158_av;
        } else {
            this.isSwinging = false;
            this.swingProgress = entity.field_110158_av;
        }
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        public List<EntityEffect> create(@Nonnull Entity entity, @Nonnull EntityEffectInfo eei) {
            return ImmutableList.of((Object)new EntitySwingEffect());
        }
    }
}

