/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.fx.particle.ParticleBreath;
import org.blockartistry.DynSurround.registry.EntityEffectInfo;
import org.blockartistry.lib.effects.EntityEffect;
import org.blockartistry.lib.effects.IEntityEffectFactory;
import org.blockartistry.lib.effects.IEntityEffectFactoryFilter;
import org.blockartistry.lib.effects.IEntityEffectHandlerState;

@SideOnly(value=Side.CLIENT)
public class FrostBreathEffect
extends EntityEffect {
    private static final int PRIME = 311;
    private int seed;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER = new IEntityEffectFactoryFilter(){

        @Override
        public boolean applies(@Nonnull Entity e, @Nonnull EntityEffectInfo eei) {
            return eei.effects.contains("breath");
        }
    };

    @Override
    public String name() {
        return "Frost Breath";
    }

    @Override
    public void intitialize(@Nonnull IEntityEffectHandlerState state) {
        super.intitialize(state);
        this.seed = state.subject().get().func_145782_y() * 311;
    }

    @Override
    public void update(@Nonnull Entity subject) {
        EntityPlayer player2;
        if (!ModOptions.player.showBreath) {
            return;
        }
        int interval = (int)((this.getState().getWorldTime() + (long)this.seed) / 10L % 8L);
        if (interval < 3 && this.isPossibleToShow(subject) && (subject == (player2 = this.getState().thePlayer().get()) || !subject.func_98034_c(player2) && player2.func_70685_l(subject))) {
            this.getState().addParticle((Particle)new ParticleBreath(subject));
        }
    }

    protected boolean isPossibleToShow(Entity entity) {
        if (entity.func_70055_a(Material.field_151579_a)) {
            BlockPos entityPos = entity.func_180425_c();
            float temp = entity.func_130014_f_().func_180494_b(entityPos).func_180626_a(entityPos);
            return temp < 0.2f;
        }
        return false;
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        public List<EntityEffect> create(@Nonnull Entity entity, @Nonnull EntityEffectInfo eei) {
            return ImmutableList.of((Object)new FrostBreathEffect());
        }
    }
}

