/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.effects;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.handlers.effects.EntityChatEffect;
import org.blockartistry.DynSurround.registry.EntityEffectInfo;
import org.blockartistry.lib.effects.EntityEffect;
import org.blockartistry.lib.effects.IEntityEffectFactory;
import org.blockartistry.lib.effects.IEntityEffectFactoryFilter;
import org.blockartistry.lib.effects.IEntityEffectHandlerState;

@SideOnly(value=Side.CLIENT)
public class VillagerChatEffect
extends EntityEffect {
    protected final Predicate<Entity>[] preds;
    protected final EntityChatEffect normalChat;
    protected final EntityChatEffect fleeChat;
    protected boolean runningScared = false;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER;

    public VillagerChatEffect(@Nonnull Entity entity) {
        final EntityVillager villager = (EntityVillager)entity;
        this.preds = new Predicate[]{EntitySelectors.field_188444_d, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity.func_70089_S() && villager.func_70635_at().func_75522_a(entity);
            }
        }, Predicates.alwaysTrue()};
        this.normalChat = new EntityChatEffect(entity);
        this.fleeChat = new EntityChatEffect(entity, "villager.flee");
    }

    @Override
    public String name() {
        return "Villager Chat";
    }

    @Override
    public void intitialize(@Nonnull IEntityEffectHandlerState state) {
        super.intitialize(state);
        this.normalChat.intitialize(state);
        this.fleeChat.intitialize(state);
    }

    @Override
    public void update(@Nonnull Entity subject) {
        if (!ModOptions.speechbubbles.enableEntityChat) {
            return;
        }
        EntityVillager entity = (EntityVillager)subject;
        if (entity.func_70631_g_()) {
            return;
        }
        if (this.villagerThreatened((Entity)entity)) {
            this.runningScared = true;
            this.fleeChat.update(subject);
        } else {
            if (this.runningScared) {
                this.runningScared = false;
                this.normalChat.genNextChatTime();
            }
            this.normalChat.update(subject);
        }
    }

    protected boolean villagerThreatened(Entity entity) {
        AxisAlignedBB bbox = entity.func_174813_aQ().func_72314_b(8.0, 3.0, 8.0);
        return !entity.func_130014_f_().func_175647_a(EntityZombie.class, bbox, Predicates.and(this.preds)).isEmpty();
    }

    static {
        EntityChatEffect.setTimers("villager.flee", 250, 200);
        DEFAULT_FILTER = new IEntityEffectFactoryFilter(){

            @Override
            public boolean applies(@Nonnull Entity e, @Nonnull EntityEffectInfo eei) {
                return eei.effects.contains("chat") && e instanceof EntityVillager && EntityChatEffect.hasMessages(e);
            }
        };
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        public List<EntityEffect> create(@Nonnull Entity entity, @Nonnull EntityEffectInfo eei) {
            return ImmutableList.of((Object)new VillagerChatEffect(entity));
        }
    }
}

