/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.fog;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.handlers.fog.FogResult;
import org.blockartistry.DynSurround.client.handlers.fog.VanillaFogRangeCalculator;
import org.blockartistry.DynSurround.client.weather.Weather;
import org.blockartistry.DynSurround.registry.BiomeInfo;
import org.blockartistry.lib.BlockStateProvider;
import org.blockartistry.lib.WorldUtils;
import org.blockartistry.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class BiomeFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected static final int DISTANCE = 20;
    protected static final float DUST_FOG_IMPACT = 0.9f;
    protected final Context[] context = new Context[]{new Context(), new Context()};

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        EntityPlayer player2 = EnvironStateHandler.EnvironState.getPlayer();
        World world = EnvironStateHandler.EnvironState.getWorld();
        BlockStateProvider provider = WorldUtils.getDefaultBlockStateProvider().setWorld(world);
        int playerX = MathStuff.floor(player2.field_70165_t);
        int playerZ = MathStuff.floor(player2.field_70161_v);
        float rainStr = Weather.getIntensityLevel();
        Context ctx = this.context[event.getFogMode() == -1 ? 0 : 1];
        if (ctx.returnCached(playerX, playerZ, rainStr, event)) {
            return ctx.cached;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        float fpDistanceBiomeFog = 0.0f;
        float weightBiomeFog = 0.0f;
        boolean isRaining = Weather.isRaining();
        ctx.rain = rainStr;
        ctx.doScan = false;
        block0: for (int x = -20; x <= 20; ++x) {
            for (int z = -20; z <= 20; ++z) {
                pos.func_181079_c(playerX + x, 0, playerZ + z);
                ctx.doScan = ctx.doScan | !provider.isAvailable((BlockPos)pos);
                if (ctx.doScan) break block0;
                BiomeInfo biome = ClientRegistry.BIOME.get(provider.getBiome((BlockPos)pos));
                float distancePart = 1.0f;
                float weightPart = 1.0f;
                if (isRaining && biome.getHasDust()) {
                    distancePart = 1.0f - 0.9f * rainStr;
                } else if (biome.getHasFog()) {
                    distancePart = biome.getFogDensity();
                }
                fpDistanceBiomeFog += distancePart;
                weightBiomeFog += weightPart;
            }
        }
        if (ctx.doScan) {
            ctx.cached.set(event);
        } else {
            float weightMixed = 1681.0f;
            float weightDefault = 1681.0f - weightBiomeFog;
            float fpDistanceBiomeFogAvg = weightBiomeFog == 0.0f ? 0.0f : fpDistanceBiomeFog / weightBiomeFog;
            float farPlaneDistance = (fpDistanceBiomeFog * 240.0f + event.getFarPlaneDistance() * weightDefault) / 1681.0f;
            float farPlaneDistanceScaleBiome = 0.1f * (1.0f - fpDistanceBiomeFogAvg) + 0.75f * fpDistanceBiomeFogAvg;
            float farPlaneDistanceScale = (farPlaneDistanceScaleBiome * weightBiomeFog + 0.75f * weightDefault) / 1681.0f;
            ctx.posX = playerX;
            ctx.posZ = playerZ;
            ctx.lastFarPlane = event.getFarPlaneDistance();
            farPlaneDistance = Math.min(farPlaneDistance, event.getFarPlaneDistance());
            ctx.cached.set(event.getFogMode(), farPlaneDistance, farPlaneDistanceScale);
        }
        return ctx.cached;
    }

    private static class Context {
        public int posX;
        public int posZ;
        public float rain;
        public float lastFarPlane;
        public boolean doScan = true;
        public final FogResult cached = new FogResult();

        private Context() {
        }

        public boolean returnCached(int pX, int pZ, float r, @Nonnull EntityViewRenderEvent.RenderFogEvent event) {
            return !this.doScan && pX == this.posX && pZ == this.posZ && r == this.rain && this.lastFarPlane == event.getFarPlaneDistance() && this.cached.isValid(event);
        }
    }
}

