/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.handlers.scanners;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.fx.BlockEffect;
import org.blockartistry.DynSurround.client.handlers.scanners.ClientPlayerLocus;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.registry.BlockProfile;
import org.blockartistry.lib.scanner.RandomScanner;

@SideOnly(value=Side.CLIENT)
public class RandomBlockEffectScanner
extends RandomScanner {
    private static final float RATIO = 0.24414062f;
    protected BlockProfile profile = null;
    protected IBlockState lastState = null;

    public RandomBlockEffectScanner(int range) {
        super(ClientPlayerLocus.INSTANCE, "RandomBlockEffectScanner", range, (int)((float)(range * range * range) * 0.24414062f));
        this.setLogger(DSurround.log());
    }

    @Override
    protected boolean interestingBlock(@Nonnull IBlockState state) {
        if (state == AIR_BLOCK) {
            return false;
        }
        if (this.lastState != state) {
            this.lastState = state;
            this.profile = ClientRegistry.BLOCK.findProfile(state);
        }
        return this.profile.hasSoundsOrEffects();
    }

    @Override
    public void blockScan(@Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random rand) {
        BlockEffect[] effects2 = this.profile.getEffects();
        for (int i = 0; i < effects2.length; ++i) {
            BlockEffect be = effects2[i];
            if (!be.canTrigger(this.blockProvider, state, pos, rand)) continue;
            be.doEffect(this.blockProvider, state, pos, rand);
        }
        SoundEffect sound2 = this.profile.getSoundToPlay(rand);
        if (sound2 != null) {
            sound2.doEffect(this.blockProvider, state, pos, rand);
        }
    }
}

